/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.commons.throttle.core.ConcurrentAccessController;
import org.apache.synapse.commons.throttle.core.ConcurrentAccessReplicator;
import org.apache.synapse.core.axis2.AnonymousServiceFactory;
import org.apache.synapse.core.axis2.AsyncCallback;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.SOAPUtils;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.message.senders.blocking.BlockingMsgSender;
import org.apache.synapse.transport.passthru.config.PassThroughConfiguration;
import org.apache.synapse.unittest.ConfigModifier;
import org.apache.synapse.util.MediatorPropertyUtils;
import org.apache.synapse.util.MessageHelper;

public class Axis2FlexibleMEPClient {
    private static final Log log = LogFactory.getLog(Axis2FlexibleMEPClient.class);
    private static final String SYNAPSE_TEST = "synapseTest";
    private static final String TRUE = "true";
    private static final String URL_PATH_SEPARATOR = "/";

    public static void send(EndpointDefinition endpoint, MessageContext synapseOutMessageContext) throws AxisFault {
        Boolean isConcurrencyThrottleEnabled;
        Set keySet;
        if (synapseOutMessageContext.getProperty("blockingMsgSender") != null) {
            BlockingMsgSender blockingMsgSender = (BlockingMsgSender)synapseOutMessageContext.getProperty("blockingMsgSender");
            blockingMsgSender.send(endpoint, synapseOutMessageContext);
            return;
        }
        boolean separateListener = false;
        boolean wsSecurityEnabled = false;
        String wsSecPolicyKey = null;
        String inboundWsSecPolicyKey = null;
        String outboundWsSecPolicyKey = null;
        boolean wsRMEnabled = false;
        boolean wsAddressingEnabled = false;
        String wsAddressingVersion = null;
        if (endpoint != null) {
            separateListener = endpoint.isUseSeparateListener();
            wsSecurityEnabled = endpoint.isSecurityOn();
            wsSecPolicyKey = endpoint.getWsSecPolicyKey();
            inboundWsSecPolicyKey = endpoint.getInboundWsSecPolicyKey();
            outboundWsSecPolicyKey = endpoint.getOutboundWsSecPolicyKey();
            wsAddressingEnabled = endpoint.isAddressingOn();
            wsAddressingVersion = endpoint.getAddressingVersion();
        }
        if (log.isDebugEnabled()) {
            String to = endpoint != null && endpoint.getAddress() != null ? endpoint.getAddress(synapseOutMessageContext) : synapseOutMessageContext.getTo().toString();
            log.debug((Object)("Sending [add = " + wsAddressingEnabled + "] [sec = " + wsSecurityEnabled + (endpoint != null ? "] [mtom = " + endpoint.isUseMTOM() + "] [swa = " + endpoint.isUseSwa() + "] [format = " + endpoint.getFormat() + "] [force soap11=" + endpoint.isForceSOAP11() + "] [force soap12=" + endpoint.isForceSOAP12() + "] [pox=" + endpoint.isForcePOX() + "] [get=" + endpoint.isForceGET() + "] [encoding=" + endpoint.getCharSetEncoding() : "") + "] [to=" + to + "]"));
        }
        org.apache.axis2.context.MessageContext originalInMsgCtx = ((Axis2MessageContext)synapseOutMessageContext).getAxis2MessageContext();
        HashMap<String, String> headers = (HashMap<String, String>)originalInMsgCtx.getProperty("TRANSPORT_HEADERS");
        String session = (String)synapseOutMessageContext.getProperty("LB_COOKIE_HEADER");
        if (session != null) {
            headers.put("Cookie", session);
        }
        if (originalInMsgCtx.getProperty("correlation_id") == null) {
            originalInMsgCtx.setProperty("correlation_id", (Object)UUID.randomUUID().toString());
        }
        if (headers == null) {
            headers = new HashMap<String, String>();
            originalInMsgCtx.setProperty("TRANSPORT_HEADERS", headers);
        }
        headers.put(PassThroughConfiguration.getInstance().getCorrelationHeaderName(), originalInMsgCtx.getProperty("correlation_id").toString());
        String preserveAddressingProperty = (String)synapseOutMessageContext.getProperty("PRESERVE_WS_ADDRESSING");
        org.apache.axis2.context.MessageContext axisOutMsgCtx = Axis2FlexibleMEPClient.cloneForSend(originalInMsgCtx, preserveAddressingProperty);
        axisOutMsgCtx.setProperty("INTERNAL_TRANSACTION_COUNTED", originalInMsgCtx.getProperty("INTERNAL_TRANSACTION_COUNTED"));
        Object TRIGGER_NAME = synapseOutMessageContext.getProperty("proxy.name");
        if (TRIGGER_NAME != null) {
            axisOutMsgCtx.setProperty("_INTERNAL_TRIGGER_TYPE", (Object)"proxy");
            axisOutMsgCtx.setProperty("_INTERNAL_TRIGGER_NAME", (Object)TRIGGER_NAME.toString());
        } else {
            TRIGGER_NAME = synapseOutMessageContext.getProperty("SYNAPSE_REST_API");
            if (TRIGGER_NAME != null) {
                axisOutMsgCtx.setProperty("_INTERNAL_TRIGGER_TYPE", (Object)"api");
                axisOutMsgCtx.setProperty("_INTERNAL_TRIGGER_NAME", (Object)TRIGGER_NAME.toString());
            } else {
                TRIGGER_NAME = synapseOutMessageContext.getProperty("inbound.endpoint.name");
                if (TRIGGER_NAME != null) {
                    axisOutMsgCtx.setProperty("_INTERNAL_TRIGGER_TYPE", (Object)"inboundendpoint");
                    axisOutMsgCtx.setProperty("_INTERNAL_TRIGGER_NAME", (Object)TRIGGER_NAME.toString());
                } else {
                    axisOutMsgCtx.setProperty("_INTERNAL_TRIGGER_TYPE", (Object)"anonymous");
                    axisOutMsgCtx.setProperty("_INTERNAL_TRIGGER_NAME", (Object)"anonymous");
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Message [Original Request Message ID : " + synapseOutMessageContext.getMessageID() + "] [New Cloned Request Message ID : " + axisOutMsgCtx.getMessageID() + "]"));
        }
        if (endpoint != null) {
            EndpointReference epr;
            ContentType contentType;
            String trpContentType;
            Map transportHeaders;
            Object o;
            String strCharSetEncoding = "";
            if (endpoint.getCharSetEncoding() != null) {
                strCharSetEncoding = ";" + endpoint.getCharSetEncoding();
            }
            if ("pox".equals(endpoint.getFormat())) {
                axisOutMsgCtx.setDoingREST(true);
                axisOutMsgCtx.setProperty("messageType", (Object)"application/xml");
                axisOutMsgCtx.setProperty("ContentType", (Object)"application/xml");
                o = axisOutMsgCtx.getProperty("TRANSPORT_HEADERS");
                Map _headers = (Map)o;
                if (_headers != null) {
                    _headers.remove("Content-Type");
                    _headers.put("Content-Type", "application/xml" + strCharSetEncoding);
                }
            } else if ("get".equals(endpoint.getFormat())) {
                axisOutMsgCtx.setDoingREST(true);
                axisOutMsgCtx.setProperty("HTTP_METHOD", (Object)"GET");
                axisOutMsgCtx.setProperty("messageType", (Object)"application/x-www-form-urlencoded");
            } else if ("soap11".equals(endpoint.getFormat())) {
                axisOutMsgCtx.setDoingREST(false);
                axisOutMsgCtx.removeProperty("messageType");
                axisOutMsgCtx.setProperty("HTTP_METHOD", (Object)"POST");
                if (axisOutMsgCtx.getSoapAction() == null && axisOutMsgCtx.getWSAAction() != null) {
                    axisOutMsgCtx.setSoapAction(axisOutMsgCtx.getWSAAction());
                }
                if (originalInMsgCtx.isDoingREST()) {
                    try {
                        MediatorPropertyUtils.serializeOMElement(synapseOutMessageContext);
                    }
                    catch (Exception e) {
                        Axis2FlexibleMEPClient.handleException("Error while serializing the  message", e);
                    }
                }
                if (!axisOutMsgCtx.isSOAP11()) {
                    SOAPUtils.convertSOAP12toSOAP11(axisOutMsgCtx);
                }
                if ((transportHeaders = (Map)(o = axisOutMsgCtx.getProperty("TRANSPORT_HEADERS"))) != null) {
                    trpContentType = (String)transportHeaders.get("Content-Type");
                    if (trpContentType == null) {
                        transportHeaders.put("Content-Type", "text/xml" + strCharSetEncoding);
                    } else if (!trpContentType.contains("multipart/related")) {
                        transportHeaders.remove("Content-Type");
                        try {
                            contentType = new ContentType(trpContentType);
                            if (contentType.getParameter(HTTPConstants.CHAR_SET_ENCODING) != null) {
                                strCharSetEncoding = "; charset=" + contentType.getParameter(HTTPConstants.CHAR_SET_ENCODING);
                            }
                        }
                        catch (ParseException e) {
                            log.warn((Object)"Error occurred while parsing ContentType header, using default: text/xml");
                        }
                        transportHeaders.put("Content-Type", "text/xml" + strCharSetEncoding);
                    }
                }
            } else if ("soap12".equals(endpoint.getFormat())) {
                axisOutMsgCtx.setDoingREST(false);
                axisOutMsgCtx.removeProperty("messageType");
                axisOutMsgCtx.setProperty("HTTP_METHOD", (Object)"POST");
                if (axisOutMsgCtx.getSoapAction() == null && axisOutMsgCtx.getWSAAction() != null) {
                    axisOutMsgCtx.setSoapAction(axisOutMsgCtx.getWSAAction());
                }
                if (axisOutMsgCtx.isSOAP11()) {
                    SOAPUtils.convertSOAP11toSOAP12(axisOutMsgCtx);
                }
                if ((transportHeaders = (Map)(o = axisOutMsgCtx.getProperty("TRANSPORT_HEADERS"))) != null) {
                    trpContentType = (String)transportHeaders.get("Content-Type");
                    if (trpContentType == null) {
                        transportHeaders.put("Content-Type", "application/soap+xml" + strCharSetEncoding);
                    } else if (!trpContentType.contains("multipart/related")) {
                        transportHeaders.remove("Content-Type");
                        try {
                            contentType = new ContentType(trpContentType);
                            if (contentType.getParameter(HTTPConstants.CHAR_SET_ENCODING) != null) {
                                strCharSetEncoding = "; charset=" + contentType.getParameter(HTTPConstants.CHAR_SET_ENCODING);
                            }
                        }
                        catch (ParseException e) {
                            log.warn((Object)"Error occurred while parsing ContentType header in property, using default: application/soap+xml");
                        }
                        if (axisOutMsgCtx.getSoapAction() != null) {
                            String actionHeaderPrefix = ";action=\"";
                            String contentTypeWithAction = new StringBuilder("application/soap+xml".length() + axisOutMsgCtx.getSoapAction().length() + actionHeaderPrefix.length() + 1).append("application/soap+xml").append(actionHeaderPrefix).append(axisOutMsgCtx.getSoapAction()).append('\"').toString();
                            transportHeaders.put("Content-Type", contentTypeWithAction + strCharSetEncoding);
                        } else {
                            transportHeaders.put("Content-Type", "application/soap+xml" + strCharSetEncoding);
                        }
                    }
                }
            } else if ("rest".equals(endpoint.getFormat())) {
                if (originalInMsgCtx.getProperty("HTTP_METHOD") != null && (originalInMsgCtx.getProperty("HTTP_METHOD").toString().equals("GET") || originalInMsgCtx.getProperty("HTTP_METHOD").toString().equals("DELETE"))) {
                    axisOutMsgCtx.removeProperty("messageType");
                }
                axisOutMsgCtx.setDoingREST(true);
            } else {
                Axis2FlexibleMEPClient.processWSDL2RESTRequestMessageType(originalInMsgCtx, axisOutMsgCtx);
            }
            if (endpoint.isUseMTOM()) {
                axisOutMsgCtx.setDoingMTOM(true);
                axisOutMsgCtx.setProperty("enableMTOM", (Object)TRUE);
                axisOutMsgCtx.setDoingMTOM(true);
                Object trpHeaders = axisOutMsgCtx.getProperty("TRANSPORT_HEADERS");
                if (trpHeaders != null && trpHeaders instanceof Map && ((Map)trpHeaders).get("Content-Type") != null && !Axis2FlexibleMEPClient.isMultipartContent(((Map)trpHeaders).get("Content-Type").toString())) {
                    ((Map)trpHeaders).remove("Content-Type");
                }
            } else if (endpoint.isUseSwa()) {
                axisOutMsgCtx.setDoingSwA(true);
                axisOutMsgCtx.setProperty("enableSwA", (Object)TRUE);
                axisOutMsgCtx.setDoingSwA(true);
            }
            if (endpoint.getCharSetEncoding() != null) {
                axisOutMsgCtx.setProperty("CHARACTER_SET_ENCODING", (Object)endpoint.getCharSetEncoding());
            }
            if (endpoint.isHTTPEndpoint()) {
                axisOutMsgCtx.setProperty("HTTP_METHOD", synapseOutMessageContext.getProperty("HTTP_METHOD"));
                axisOutMsgCtx.removeProperty("REST_URL_POSTFIX");
            }
            String restSuffix = (String)axisOutMsgCtx.getProperty("REST_URL_POSTFIX");
            boolean isRest = "rest".equals(endpoint.getFormat());
            if (!(isRest || endpoint.isForceSOAP11() || endpoint.isForceSOAP12())) {
                isRest = Axis2FlexibleMEPClient.isRequestRest(originalInMsgCtx);
            }
            if (endpoint.getAddress() != null) {
                String address = endpoint.getAddress(synapseOutMessageContext);
                if (isRest && restSuffix != null && !"".equals(restSuffix)) {
                    String url = "";
                    url = !address.endsWith(URL_PATH_SEPARATOR) && !restSuffix.startsWith(URL_PATH_SEPARATOR) && !restSuffix.startsWith("?") ? address + URL_PATH_SEPARATOR + restSuffix : (address.endsWith(URL_PATH_SEPARATOR) && restSuffix.startsWith(URL_PATH_SEPARATOR) ? address + restSuffix.substring(1) : (address.endsWith(URL_PATH_SEPARATOR) && restSuffix.startsWith("?") ? address.substring(0, address.length() - 1) + restSuffix : (!address.startsWith("jms") ? address + restSuffix : address)));
                    axisOutMsgCtx.setTo(new EndpointReference(url));
                } else {
                    axisOutMsgCtx.setTo(new EndpointReference(address));
                }
                axisOutMsgCtx.setProperty("ENDPOINT_PREFIX", (Object)address);
                synapseOutMessageContext.setProperty("ENDPOINT_PREFIX", address);
            } else if (isRest && restSuffix != null && !"".equals(restSuffix) && (epr = axisOutMsgCtx.getTo()) != null) {
                String address = epr.getAddress();
                String url = !address.endsWith(URL_PATH_SEPARATOR) && !restSuffix.startsWith(URL_PATH_SEPARATOR) && !restSuffix.startsWith("?") ? address + URL_PATH_SEPARATOR + restSuffix : address + restSuffix;
                axisOutMsgCtx.setTo(new EndpointReference(url));
            }
            String endPointName = endpoint.leafEndpoint.getName();
            if (TRUE.equals(System.getProperty(SYNAPSE_TEST)) && synapseOutMessageContext.getConfiguration().getProperty("IS_RUNNING_AS_UNIT_TEST") != null && synapseOutMessageContext.getConfiguration().getProperty("IS_RUNNING_AS_UNIT_TEST").equals(TRUE) && ConfigModifier.unitTestMockEndpointMap.containsKey(endPointName)) {
                Map<String, String> endpointMockResources = ConfigModifier.unitTestMockEndpointMap.get(endPointName);
                String modifiedUrl = Axis2FlexibleMEPClient.modifyEndpointUrlWithMockService(axisOutMsgCtx.getTo().getAddress(), endpointMockResources);
                axisOutMsgCtx.getTo().setAddress(modifiedUrl);
            }
            if (endpoint.isUseSeparateListener()) {
                axisOutMsgCtx.getOptions().setUseSeparateListener(true);
            }
        } else {
            Axis2FlexibleMEPClient.processWSDL2RESTRequestMessageType(originalInMsgCtx, axisOutMsgCtx);
        }
        if (axisOutMsgCtx.isDoingREST() && "application/x-www-form-urlencoded".equals(axisOutMsgCtx.getProperty("messageType")) && axisOutMsgCtx.getProperty("whttp:location") == null && axisOutMsgCtx.getEnvelope().getBody().getFirstElement() != null) {
            axisOutMsgCtx.setProperty("whttp:location", (Object)axisOutMsgCtx.getEnvelope().getBody().getFirstElement().getQName().getLocalPart());
        }
        if (wsAddressingEnabled) {
            if (wsAddressingVersion != null && "submission".equals(wsAddressingVersion)) {
                axisOutMsgCtx.setProperty("WSAddressingVersion", (Object)"http://schemas.xmlsoap.org/ws/2004/08/addressing");
            } else if (wsAddressingVersion != null && "final".equals(wsAddressingVersion)) {
                axisOutMsgCtx.setProperty("WSAddressingVersion", (Object)"http://www.w3.org/2005/08/addressing");
            }
            axisOutMsgCtx.setProperty("disableAddressingForOutMessages", (Object)Boolean.FALSE);
        } else {
            axisOutMsgCtx.setProperty("disableAddressingForOutMessages", (Object)Boolean.TRUE);
        }
        String preserveHeaderProperty = (String)synapseOutMessageContext.getProperty("preserveProcessedHeaders");
        if (preserveHeaderProperty == null || !Boolean.parseBoolean(preserveHeaderProperty)) {
            MessageHelper.removeProcessedHeaders(axisOutMsgCtx, preserveAddressingProperty != null && Boolean.parseBoolean(preserveAddressingProperty));
        }
        ConfigurationContext axisCfgCtx = axisOutMsgCtx.getConfigurationContext();
        AxisConfiguration axisCfg = axisCfgCtx.getAxisConfiguration();
        AxisService anoymousService = AnonymousServiceFactory.getAnonymousService(synapseOutMessageContext.getConfiguration(), axisCfg, wsAddressingEnabled, wsRMEnabled, wsSecurityEnabled);
        anoymousService.getParent().addParameter("hiddenService", (Object)TRUE);
        ServiceGroupContext sgc = new ServiceGroupContext(axisCfgCtx, (AxisServiceGroup)anoymousService.getParent());
        ServiceContext serviceCtx = sgc.getServiceContext(anoymousService);
        boolean outOnlyMessage = TRUE.equals(synapseOutMessageContext.getProperty("OUT_ONLY"));
        AxisOperation axisAnonymousOperation = anoymousService.getOperation(outOnlyMessage ? new QName("anonOutonlyOp") : new QName("anonOutInOp"));
        Options clientOptions = MessageHelper.cloneOptions(originalInMsgCtx.getOptions());
        clientOptions.setUseSeparateListener(separateListener);
        if (wsSecurityEnabled) {
            if (wsSecPolicyKey != null) {
                if (endpoint.isDynamicPolicy()) {
                    wsSecPolicyKey = endpoint.evaluateDynamicEndpointSecurityPolicy(synapseOutMessageContext);
                }
                clientOptions.setProperty("rampartPolicy", (Object)MessageHelper.getPolicy(synapseOutMessageContext, wsSecPolicyKey));
            } else {
                if (inboundWsSecPolicyKey != null) {
                    clientOptions.setProperty("rampartInPolicy", (Object)MessageHelper.getPolicy(synapseOutMessageContext, inboundWsSecPolicyKey));
                }
                if (outboundWsSecPolicyKey != null) {
                    clientOptions.setProperty("rampartOutPolicy", (Object)MessageHelper.getPolicy(synapseOutMessageContext, outboundWsSecPolicyKey));
                }
            }
            if (axisOutMsgCtx.getEnvelope().getHeader() == null) {
                SOAPFactory fac = axisOutMsgCtx.isSOAP11() ? OMAbstractFactory.getSOAP11Factory() : OMAbstractFactory.getSOAP12Factory();
                fac.createSOAPHeader(axisOutMsgCtx.getEnvelope());
            }
        }
        OperationClient mepClient = axisAnonymousOperation.createClient(serviceCtx, clientOptions);
        mepClient.addMessageContext(axisOutMsgCtx);
        axisOutMsgCtx.setAxisMessage(axisAnonymousOperation.getMessage("Out"));
        if (endpoint != null && endpoint.getEffectiveTimeout() > 0L) {
            if (!endpoint.isDynamicTimeoutEndpoint()) {
                axisOutMsgCtx.setProperty("SEND_TIMEOUT", (Object)endpoint.getEffectiveTimeout());
            } else {
                axisOutMsgCtx.setProperty("SEND_TIMEOUT", (Object)endpoint.evaluateDynamicEndpointTimeout(synapseOutMessageContext));
            }
        }
        AsyncCallback callback = new AsyncCallback(axisOutMsgCtx, synapseOutMessageContext);
        if (!outOnlyMessage) {
            if (endpoint != null) {
                long endpointTimeout;
                if (!endpoint.isDynamicTimeoutEndpoint()) {
                    endpointTimeout = endpoint.getEffectiveTimeout();
                    callback.setTimeout(endpointTimeout);
                    callback.setTimeOutAction(endpoint.getTimeoutAction());
                    callback.setTimeoutType(endpoint.getEndpointTimeoutType());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Setting Timeout for endpoint : " + Axis2FlexibleMEPClient.getEndpointLogMessage(synapseOutMessageContext, axisOutMsgCtx) + " to static timeout value : " + endpointTimeout));
                    }
                } else {
                    endpointTimeout = endpoint.evaluateDynamicEndpointTimeout(synapseOutMessageContext);
                    callback.setTimeout(endpointTimeout);
                    callback.setTimeOutAction(endpoint.getTimeoutAction());
                    callback.setTimeoutType(endpoint.getEndpointTimeoutType());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Setting Timeout for endpoint : " + Axis2FlexibleMEPClient.getEndpointLogMessage(synapseOutMessageContext, axisOutMsgCtx) + " to dynamic timeout value : " + endpointTimeout));
                    }
                }
            } else {
                long globalTimeout = synapseOutMessageContext.getEnvironment().getGlobalTimeout();
                callback.setTimeout(globalTimeout);
                callback.setTimeoutType(SynapseConstants.ENDPOINT_TIMEOUT_TYPE.GLOBAL_TIMEOUT);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Setting timeout for implicit endpoint : " + Axis2FlexibleMEPClient.getEndpointLogMessage(synapseOutMessageContext, axisOutMsgCtx) + " to global timeout value of " + globalTimeout));
                }
            }
        }
        mepClient.setCallback((AxisCallback)callback);
        if (originalInMsgCtx.isPropertyTrue("FORCE_HTTP_1.0")) {
            synapseOutMessageContext.getEnvelope().toString();
        }
        originalInMsgCtx.getOperationContext().setProperty("RESPONSE_WRITTEN", (Object)"SKIP");
        Object o = originalInMsgCtx.getProperty("TRANSPORT_OUT_DESCRIPTION");
        if (o != null && o instanceof TransportOutDescription) {
            axisOutMsgCtx.setTransportOut((TransportOutDescription)o);
            clientOptions.setTransportOut((TransportOutDescription)o);
            clientOptions.setProperty("TRANSPORT_OUT_DESCRIPTION", o);
        }
        if ((keySet = synapseOutMessageContext.getPropertyKeySet()) != null) {
            keySet.remove("DYNAMIC_URL_VALUE");
        }
        if (outOnlyMessage && (isConcurrencyThrottleEnabled = (Boolean)synapseOutMessageContext.getProperty("synapse.concurrency.throttle")) != null && isConcurrencyThrottleEnabled.booleanValue()) {
            ConcurrentAccessController concurrentAccessController = (ConcurrentAccessController)synapseOutMessageContext.getProperty("synapse.concurrent.access.controller");
            int available = concurrentAccessController.incrementAndGet();
            int concurrentLimit = concurrentAccessController.getLimit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Concurrency Throttle : Connection returned :: " + available + " of available of " + concurrentLimit + " connections"));
            }
            ConcurrentAccessReplicator concurrentAccessReplicator = (ConcurrentAccessReplicator)synapseOutMessageContext.getProperty("synapse.concurrent.access.replicator");
            String throttleKey = (String)synapseOutMessageContext.getProperty("synapse.concurrency.throttle.key");
            if (concurrentAccessReplicator != null) {
                concurrentAccessReplicator.replicate(throttleKey, Boolean.valueOf(true));
            }
        }
        mepClient.execute(true);
    }

    private static org.apache.axis2.context.MessageContext cloneForSend(org.apache.axis2.context.MessageContext ori, String preserveAddressing) throws AxisFault {
        org.apache.axis2.context.MessageContext newMC = MessageHelper.clonePartially(ori);
        newMC.setEnvelope(ori.getEnvelope());
        if (preserveAddressing != null && Boolean.parseBoolean(preserveAddressing)) {
            newMC.setMessageID(ori.getMessageID());
        } else {
            MessageHelper.removeAddressingHeaders(newMC);
        }
        newMC.setProperty("TRANSPORT_HEADERS", ori.getProperty("TRANSPORT_HEADERS"));
        return newMC;
    }

    public static void clearSecurtityProperties(Options options) {
        for (Options current = options; current != null && current.getProperty("rampartPolicy") != null; current = current.getParent()) {
            current.setProperty("rampartPolicy", null);
        }
    }

    private static String modifyEndpointUrlWithMockService(String endpointUrl, Map<String, String> mockServiceResources) {
        try {
            URI endpointURI = new URI(endpointUrl);
            String pathWithContextAndParams = endpointUrl.substring(endpointUrl.indexOf(endpointURI.getPath()));
            if (mockServiceResources.containsKey(pathWithContextAndParams)) {
                return mockServiceResources.get(pathWithContextAndParams);
            }
            if (mockServiceResources.containsKey(pathWithContextAndParams + URL_PATH_SEPARATOR)) {
                return mockServiceResources.get(pathWithContextAndParams + URL_PATH_SEPARATOR);
            }
        }
        catch (URISyntaxException e) {
            log.error((Object)"Error while finding the path of the endpoint URL. Hence, proceeding with endpoint url");
        }
        return endpointUrl;
    }

    private static void processWSDL2RESTRequestMessageType(org.apache.axis2.context.MessageContext originalInMsgCtx, org.apache.axis2.context.MessageContext axisOutMsgCtx) {
        String httpMethod;
        Object restContentType = originalInMsgCtx.getProperty("synapse.internal.rest.contentType");
        if (restContentType == null && ("GET".equals(httpMethod = (String)originalInMsgCtx.getProperty("HTTP_METHOD")) || "DELETE".equals(httpMethod))) {
            restContentType = "application/x-www-form-urlencoded";
        }
    }

    private static boolean isRequestRest(org.apache.axis2.context.MessageContext originalInMsgCtx) {
        boolean isRestRequest;
        boolean bl = isRestRequest = originalInMsgCtx.getProperty("synapse.internal.rest.contentType") != null;
        if (!isRestRequest) {
            String httpMethod = (String)originalInMsgCtx.getProperty("HTTP_METHOD");
            boolean bl2 = isRestRequest = "GET".equals(httpMethod) || "DELETE".equals(httpMethod) || "PUT".equals(httpMethod) || "PATCH".equals(httpMethod) || "OPTIONS".equals(httpMethod) || "HEAD".equals(httpMethod) || "PATCH".equals(httpMethod);
            if (!isRestRequest) {
                boolean bl3 = isRestRequest = "POST".equals(httpMethod) && HTTPTransportUtils.isRESTRequest((String)String.valueOf(originalInMsgCtx.getProperty("messageType")));
                if (!isRestRequest) {
                    isRestRequest = String.valueOf(originalInMsgCtx.getProperty("messageType")).equals("text/xml") && originalInMsgCtx.getSoapAction() == null;
                }
            }
        }
        return isRestRequest;
    }

    private static String getEndpointLogMessage(MessageContext synCtx, org.apache.axis2.context.MessageContext axisCtx) {
        return synCtx.getProperty("last_endpoint") + ", URI : " + axisCtx.getTo().getAddress();
    }

    public static boolean isMultipartContent(String contentType) {
        return contentType.contains("multipart/form-data") || contentType.contains("multipart/related");
    }

    private static void handleException(String msg, Exception e) {
        throw new SynapseException(msg, e);
    }
}

