/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import org.apache.axis2.client.async.AxisCallback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;

public class AsyncCallback
implements AxisCallback {
    private static final Log log = LogFactory.getLog(AsyncCallback.class);
    private final MessageContext synapseOutMsgCtx;
    private org.apache.axis2.context.MessageContext axis2OutMsgCtx;
    private long timeOutOn;
    private int timeOutAction = 100;
    private long timeoutDuration;
    private boolean markedForRemoval = false;
    private SynapseConstants.ENDPOINT_TIMEOUT_TYPE timeoutType;

    public AsyncCallback(org.apache.axis2.context.MessageContext messageContext, MessageContext synapseOutMsgCtx) {
        this.synapseOutMsgCtx = synapseOutMsgCtx;
        this.axis2OutMsgCtx = messageContext;
    }

    public void onMessage(org.apache.axis2.context.MessageContext messageContext) {
    }

    public void onFault(org.apache.axis2.context.MessageContext messageContext) {
    }

    public void onError(Exception e) {
        this.axis2OutMsgCtx.setFailureReason(e);
        log.error((Object)e.getMessage(), (Throwable)e);
        if (!this.synapseOutMsgCtx.getFaultStack().isEmpty()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Executing fault handler due to exception encountered");
            }
            this.synapseOutMsgCtx.getFaultStack().pop().handleFault(this.synapseOutMsgCtx, new SynapseException(e.getMessage(), e));
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Exception encountered but no fault handler found - message dropped");
        }
    }

    public void onComplete() {
    }

    public MessageContext getSynapseOutMsgCtx() {
        return this.synapseOutMsgCtx;
    }

    public org.apache.axis2.context.MessageContext getAxis2OutMsgCtx() {
        return this.axis2OutMsgCtx;
    }

    public long getTimeOutOn() {
        return this.timeOutOn;
    }

    public long getTimeoutDuration() {
        return this.timeoutDuration;
    }

    public void setTimeout(long timeoutDuration) {
        this.timeoutDuration = timeoutDuration;
        this.timeOutOn = System.currentTimeMillis() + timeoutDuration;
    }

    public int getTimeOutAction() {
        return this.timeOutAction;
    }

    public void setTimeOutAction(int timeOutAction) {
        this.timeOutAction = timeOutAction;
    }

    public SynapseConstants.ENDPOINT_TIMEOUT_TYPE getTimeoutType() {
        return this.timeoutType;
    }

    public void setTimeoutType(SynapseConstants.ENDPOINT_TIMEOUT_TYPE timeoutType) {
        this.timeoutType = timeoutType;
    }

    public boolean isMarkedForRemoval() {
        return this.markedForRemoval;
    }

    public void setMarkedForRemoval() {
        this.markedForRemoval = true;
    }
}

