/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.axis2.DynamicAxisOperation;
import org.apache.synapse.core.axis2.SynapseCallbackReceiver;

public class AnonymousServiceFactory {
    private static final Log log = LogFactory.getLog(AnonymousServiceFactory.class);
    private static final String NONE = "__NONE__";
    private static final String ADDR_ONLY = "__ADDR_ONLY__";
    private static final String SEC_ONLY = "__SEC_ONLY__";
    private static final String RM_AND_ADDR = "__RM_AND_ADDR__";
    private static final String SEC_AND_ADDR = "__SEC_AND_ADDR__";
    private static final String RM_SEC_AND_ADDR = "__RM_SEC_AND_ADDR__";
    public static final String OUT_IN_OPERATION = "anonOutInOp";
    public static final String OUT_ONLY_OPERATION = "anonOutonlyOp";
    private static SynapseCallbackReceiver synapseCallbackReceiver = null;

    public static AxisService getAnonymousService(SynapseConfiguration synCfg, AxisConfiguration axisCfg, boolean wsAddrOn, boolean wsRMOn, boolean wsSecOn) {
        return AnonymousServiceFactory.getAnonymousService(synCfg, axisCfg, wsAddrOn, wsRMOn, wsSecOn, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AxisService getAnonymousService(SynapseConfiguration synCfg, AxisConfiguration axisCfg, boolean wsAddrOn, boolean wsRMOn, boolean wsSecOn, boolean setCallback) {
        String servicekey;
        int checkbit = 0;
        if (wsAddrOn) {
            ++checkbit;
        }
        if (wsSecOn) {
            checkbit += 2;
        }
        if (wsRMOn) {
            checkbit += 4;
        }
        switch (checkbit) {
            case 0: {
                servicekey = NONE;
                break;
            }
            case 1: {
                servicekey = ADDR_ONLY;
                break;
            }
            case 2: {
                servicekey = SEC_ONLY;
                break;
            }
            case 3: {
                servicekey = SEC_AND_ADDR;
                break;
            }
            case 4: {
                servicekey = RM_AND_ADDR;
                break;
            }
            case 5: {
                servicekey = RM_AND_ADDR;
                break;
            }
            case 6: {
                servicekey = RM_SEC_AND_ADDR;
                break;
            }
            case 7: {
                servicekey = RM_SEC_AND_ADDR;
                break;
            }
            default: {
                servicekey = NONE;
            }
        }
        try {
            AxisService service = axisCfg.getService(servicekey);
            if (service != null) return service;
            Class<AnonymousServiceFactory> clazz = AnonymousServiceFactory.class;
            synchronized (AnonymousServiceFactory.class) {
                service = axisCfg.getService(servicekey);
                if (service != null) {
                    // ** MonitorExit[var9_10] (shouldn't be in output)
                    return service;
                }
                service = AnonymousServiceFactory.createAnonymousService(synCfg, axisCfg, servicekey, setCallback);
                if (wsAddrOn) {
                    service.engageModule(axisCfg.getModule("addressing"), (AxisDescription)axisCfg);
                    if (wsRMOn) {
                        service.engageModule(axisCfg.getModule("sandesha2"), (AxisDescription)axisCfg);
                    }
                }
                if (!wsSecOn) return service;
                service.engageModule(axisCfg.getModule("rampart"), (AxisDescription)axisCfg);
                // ** MonitorExit[var9_10] (shouldn't be in output)
                return service;
            }
        }
        catch (AxisFault e) {
            AnonymousServiceFactory.handleException("Error retrieving anonymous service for QoS : " + servicekey, (Exception)((Object)e));
            return null;
        }
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    private static AxisService createAnonymousService(SynapseConfiguration synCfg, AxisConfiguration axisCfg, String serviceKey, boolean setCallback) {
        try {
            if (setCallback) {
                return AnonymousServiceFactory.getAxisServiceWithCallback(synCfg, axisCfg, serviceKey);
            }
            return AnonymousServiceFactory.getAxisServiceWithoutCallback(synCfg, axisCfg, serviceKey);
        }
        catch (AxisFault e) {
            AnonymousServiceFactory.handleException("Error occured while creating an anonymous service for QoS : " + serviceKey, (Exception)((Object)e));
            return null;
        }
    }

    private static AxisService getAxisServiceWithCallback(SynapseConfiguration synCfg, AxisConfiguration axisCfg, String serviceKey) throws AxisFault {
        DynamicAxisOperation dynamicOperation = new DynamicAxisOperation(new QName(OUT_IN_OPERATION));
        dynamicOperation.setMessageReceiver((MessageReceiver)AnonymousServiceFactory.getCallbackReceiver(synCfg, axisCfg));
        AxisMessage inMsg = new AxisMessage();
        inMsg.setName("in-message");
        inMsg.setParent((AxisDescription)dynamicOperation);
        AxisMessage outMsg = new AxisMessage();
        outMsg.setName("out-message");
        outMsg.setParent((AxisDescription)dynamicOperation);
        dynamicOperation.addMessage(inMsg, "Out");
        dynamicOperation.addMessage(outMsg, "In");
        OutOnlyAxisOperation asyncOperation = new OutOnlyAxisOperation(new QName(OUT_ONLY_OPERATION));
        asyncOperation.setMessageReceiver((MessageReceiver)AnonymousServiceFactory.getCallbackReceiver(synCfg, axisCfg));
        AxisMessage outOnlyMsg = new AxisMessage();
        outOnlyMsg.setName("out-message");
        outOnlyMsg.setParent((AxisDescription)asyncOperation);
        asyncOperation.addMessage(outMsg, "Out");
        AxisService axisAnonymousService = new AxisService(serviceKey);
        axisAnonymousService.addOperation((AxisOperation)dynamicOperation);
        axisAnonymousService.addOperation((AxisOperation)asyncOperation);
        AxisServiceGroup axisAnonSvcGroup = new AxisServiceGroup(axisCfg);
        axisAnonSvcGroup.setServiceGroupName(serviceKey);
        axisAnonSvcGroup.addParameter("hiddenService", (Object)"true");
        axisAnonymousService.setClientSide(true);
        axisAnonSvcGroup.addService(axisAnonymousService);
        axisCfg.addServiceGroup(axisAnonSvcGroup);
        axisCfg.getPhasesInfo().setOperationPhases((AxisOperation)dynamicOperation);
        return axisAnonymousService;
    }

    private static AxisService getAxisServiceWithoutCallback(SynapseConfiguration synCfg, AxisConfiguration axisCfg, String serviceKey) throws AxisFault {
        OutInAxisOperation outInAxisOperation = new OutInAxisOperation(new QName(OUT_IN_OPERATION));
        AxisMessage inMsg = new AxisMessage();
        inMsg.setName("in-message");
        inMsg.setParent((AxisDescription)outInAxisOperation);
        AxisMessage outMsg = new AxisMessage();
        outMsg.setName("out-message");
        outMsg.setParent((AxisDescription)outInAxisOperation);
        outInAxisOperation.addMessage(inMsg, "Out");
        outInAxisOperation.addMessage(outMsg, "In");
        OutOnlyAxisOperation outOnlyAxisOperation = new OutOnlyAxisOperation(new QName(OUT_ONLY_OPERATION));
        AxisMessage outOnlyMsg = new AxisMessage();
        outOnlyMsg.setName("out-message");
        outOnlyMsg.setParent((AxisDescription)outOnlyAxisOperation);
        outOnlyAxisOperation.addMessage(outMsg, "Out");
        AxisService axisAnonymousService = new AxisService(serviceKey);
        axisAnonymousService.addOperation((AxisOperation)outInAxisOperation);
        axisAnonymousService.addOperation((AxisOperation)outOnlyAxisOperation);
        AxisServiceGroup axisAnonSvcGroup = new AxisServiceGroup(axisCfg);
        axisAnonSvcGroup.setServiceGroupName(serviceKey);
        axisAnonSvcGroup.addParameter("hiddenService", (Object)"true");
        axisAnonymousService.setClientSide(true);
        axisAnonSvcGroup.addService(axisAnonymousService);
        axisCfg.addServiceGroup(axisAnonSvcGroup);
        axisCfg.getPhasesInfo().setOperationPhases((AxisOperation)outInAxisOperation);
        return axisAnonymousService;
    }

    private static synchronized SynapseCallbackReceiver getCallbackReceiver(SynapseConfiguration synCfg, AxisConfiguration axisCfg) {
        if (synapseCallbackReceiver == null) {
            Parameter serverCtxParam = axisCfg.getParameter("synapse.server.context.info");
            if (serverCtxParam == null || !(serverCtxParam.getValue() instanceof ServerContextInformation)) {
                String msg = "ServerContextInformation not found";
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            ServerContextInformation contextInformation = (ServerContextInformation)serverCtxParam.getValue();
            synapseCallbackReceiver = new SynapseCallbackReceiver(synCfg, contextInformation);
            contextInformation.setSynapseCallbackReceiver(synapseCallbackReceiver);
        }
        return synapseCallbackReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AxisService getAnonymousService(AxisConfiguration axisCfg, String serviceKey) throws AxisFault {
        AxisService service = axisCfg.getService(serviceKey);
        if (service != null) return service;
        Class<AnonymousServiceFactory> clazz = AnonymousServiceFactory.class;
        synchronized (AnonymousServiceFactory.class) {
            service = axisCfg.getService(serviceKey);
            if (service != null) return service;
            return AnonymousServiceFactory.getAxisServiceWithoutCallback(null, axisCfg, serviceKey);
        }
    }
}

