/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.continuation;

import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ContinuationState;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SequenceType;
import org.apache.synapse.SynapseException;
import org.apache.synapse.api.API;
import org.apache.synapse.api.Resource;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.aspects.flow.statistics.opentracing.OpenTracingManagerHolder;
import org.apache.synapse.aspects.flow.statistics.opentracing.management.OpenTracingManager;
import org.apache.synapse.continuation.ReliantContinuationState;
import org.apache.synapse.continuation.SeqContinuationState;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.inbound.InboundEndpoint;
import org.apache.synapse.mediators.MediatorFaultHandler;
import org.apache.synapse.mediators.base.SequenceMediator;

public class ContinuationStackManager {
    private static Log log = LogFactory.getLog(ContinuationStackManager.class);
    public static final String SKIP_CONTINUATION_STATE = "SKIP_CONTINUATION_STATE";

    public static void addSeqContinuationState(MessageContext synCtx, String seqName, SequenceType seqType) {
        if (synCtx.isContinuationEnabled() && !SequenceType.ANON.equals((Object)seqType)) {
            OpenTracingManager openTracingManager;
            synCtx.pushContinuationState(new SeqContinuationState(seqType, seqName));
            if (RuntimeStatisticCollector.isOpenTracingEnabled() && (openTracingManager = OpenTracingManagerHolder.getOpenTracingManager()) != null) {
                openTracingManager.getHandler().handleStateStackInsertion(synCtx, seqName, seqType);
            }
        }
    }

    public static boolean isSkipSeqContinuationStateAddition(MessageContext synCtx) {
        Boolean isSkipContinuationState = (Boolean)synCtx.getProperty(SKIP_CONTINUATION_STATE);
        if (isSkipContinuationState != null && isSkipContinuationState.booleanValue()) {
            Set keySet = synCtx.getPropertyKeySet();
            if (keySet != null) {
                keySet.remove(SKIP_CONTINUATION_STATE);
            }
            return true;
        }
        return false;
    }

    public static void removeSeqContinuationState(MessageContext synCtx, SequenceType seqType) {
        if (synCtx.isContinuationEnabled() && !synCtx.getContinuationStateStack().isEmpty()) {
            if (!SequenceType.ANON.equals((Object)seqType)) {
                ContinuationStackManager.popContinuationStateStack(synCtx);
            } else {
                ContinuationStackManager.removeReliantContinuationState(synCtx);
            }
        }
    }

    public static void updateSeqContinuationState(MessageContext synCtx, int position) {
        if (synCtx.isContinuationEnabled()) {
            ContinuationState seqContState = ContinuationStackManager.peakContinuationStateStack(synCtx);
            if (seqContState != null) {
                seqContState.getLeafChild().setPosition(position);
            } else {
                log.warn((Object)"Continuation Stack is empty. Probably due to a configuration issue");
            }
        }
    }

    public static void addReliantContinuationState(MessageContext synCtx, int subBranch, int position) {
        if (synCtx.isContinuationEnabled()) {
            ContinuationState seqContState = ContinuationStackManager.peakContinuationStateStack(synCtx);
            if (seqContState != null) {
                seqContState.getLeafChild().setPosition(position);
                seqContState.addLeafChild(new ReliantContinuationState(subBranch));
            } else {
                log.warn((Object)"Continuation Stack is empty. Probably due to a configuration issue");
            }
        }
    }

    public static void removeReliantContinuationState(MessageContext synCtx) {
        if (synCtx.isContinuationEnabled()) {
            ContinuationState seqContState = ContinuationStackManager.peakContinuationStateStack(synCtx);
            if (seqContState != null) {
                seqContState.removeLeafChild();
            } else {
                log.warn((Object)"Continuation Stack is empty. Probably due to a configuration issue");
            }
        }
    }

    public static SeqContinuationState getClonedSeqContinuationState(SeqContinuationState oriSeqContinuationState) {
        SeqContinuationState clone = new SeqContinuationState(oriSeqContinuationState.getSeqType(), oriSeqContinuationState.getSeqName());
        clone.setPosition(oriSeqContinuationState.getPosition());
        if (oriSeqContinuationState.hasChild()) {
            clone.setChildContState(ContinuationStackManager.getClonedReliantContState(oriSeqContinuationState.getChildContState()));
        }
        return clone;
    }

    private static ReliantContinuationState getClonedReliantContState(ContinuationState continuationState) {
        ReliantContinuationState oriConstState = (ReliantContinuationState)continuationState;
        ReliantContinuationState clone = new ReliantContinuationState(oriConstState.getSubBranch());
        clone.setPosition(oriConstState.getPosition());
        if (oriConstState.hasChild()) {
            clone.setChildContState(ContinuationStackManager.getClonedReliantContState(oriConstState.getChildContState()));
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearStack(MessageContext synCtx) {
        Stack<ContinuationState> continuationStack = synCtx.getContinuationStateStack();
        if (synCtx.isContinuationEnabled()) {
            Stack<ContinuationState> stack = continuationStack;
            synchronized (stack) {
                OpenTracingManager openTracingManager;
                continuationStack.clear();
                if (RuntimeStatisticCollector.isOpenTracingEnabled() && (openTracingManager = OpenTracingManagerHolder.getOpenTracingManager()) != null) {
                    openTracingManager.getHandler().handleStateStackClearance(synCtx);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContinuationState peakContinuationStateStack(MessageContext synCtx) {
        Stack<ContinuationState> continuationStack;
        Stack<ContinuationState> stack = continuationStack = synCtx.getContinuationStateStack();
        synchronized (stack) {
            if (!continuationStack.isEmpty()) {
                return continuationStack.peek();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void popContinuationStateStack(MessageContext synCtx) {
        Stack<ContinuationState> continuationStack;
        Stack<ContinuationState> stack = continuationStack = synCtx.getContinuationStateStack();
        synchronized (stack) {
            if (!continuationStack.isEmpty()) {
                OpenTracingManager openTracingManager;
                ContinuationState poppedContinuationState = continuationStack.pop();
                if (RuntimeStatisticCollector.isOpenTracingEnabled() && (openTracingManager = OpenTracingManagerHolder.getOpenTracingManager()) != null) {
                    openTracingManager.getHandler().handleStateStackRemoval(poppedContinuationState, synCtx);
                }
            }
        }
    }

    public static SequenceMediator retrieveSequence(MessageContext synCtx, SeqContinuationState seqContState) {
        SequenceMediator sequence = null;
        switch (seqContState.getSeqType()) {
            case NAMED: {
                sequence = (SequenceMediator)synCtx.getSequence(seqContState.getSeqName());
                if (sequence != null) break;
                ContinuationStackManager.handleException("Sequence : " + seqContState.getSeqName() + " not found");
                break;
            }
            case PROXY_INSEQ: {
                String proxyName = (String)synCtx.getProperty("proxy.name");
                ProxyService proxyService = synCtx.getConfiguration().getProxyService(proxyName);
                if (proxyService != null) {
                    sequence = proxyService.getTargetInLineInSequence();
                    break;
                }
                ContinuationStackManager.handleException("Proxy Service :" + proxyName + " not found");
                break;
            }
            case API_INSEQ: {
                String apiName = (String)synCtx.getProperty("SYNAPSE_REST_API");
                String resourceName = (String)synCtx.getProperty("SYNAPSE_RESOURCE");
                API api = synCtx.getEnvironment().getSynapseConfiguration().getAPI(apiName);
                if (api != null) {
                    Resource resource = api.getResource(resourceName);
                    if (resource != null) {
                        sequence = resource.getInSequence();
                        break;
                    }
                    ContinuationStackManager.handleException("Resource : " + resourceName + " not found");
                    break;
                }
                ContinuationStackManager.handleException("REST API : " + apiName + " not found");
                break;
            }
            case PROXY_OUTSEQ: {
                String proxyName = (String)synCtx.getProperty("proxy.name");
                ProxyService proxyService = synCtx.getConfiguration().getProxyService(proxyName);
                if (proxyService != null) {
                    sequence = proxyService.getTargetInLineOutSequence();
                    break;
                }
                ContinuationStackManager.handleException("Proxy Service :" + proxyName + " not found");
                break;
            }
            case API_OUTSEQ: {
                String apiName = (String)synCtx.getProperty("SYNAPSE_REST_API");
                String resourceName = (String)synCtx.getProperty("SYNAPSE_RESOURCE");
                API api = synCtx.getEnvironment().getSynapseConfiguration().getAPI(apiName);
                if (api != null) {
                    Resource resource = api.getResource(resourceName);
                    if (resource != null) {
                        sequence = resource.getOutSequence();
                        break;
                    }
                    ContinuationStackManager.handleException("Resource : " + resourceName + " not found");
                    break;
                }
                ContinuationStackManager.handleException("REST API : " + apiName + " not found");
                break;
            }
            case PROXY_FAULTSEQ: {
                String proxyName = (String)synCtx.getProperty("proxy.name");
                ProxyService proxyService = synCtx.getConfiguration().getProxyService(proxyName);
                if (proxyService != null) {
                    sequence = proxyService.getTargetInLineFaultSequence();
                    break;
                }
                ContinuationStackManager.handleException("Proxy Service :" + proxyName + " not found");
                break;
            }
            case API_FAULTSEQ: {
                String apiName = (String)synCtx.getProperty("SYNAPSE_REST_API");
                String resourceName = (String)synCtx.getProperty("SYNAPSE_RESOURCE");
                API api = synCtx.getEnvironment().getSynapseConfiguration().getAPI(apiName);
                if (api != null) {
                    Resource resource = api.getResource(resourceName);
                    if (resource != null) {
                        sequence = resource.getFaultSequence();
                        break;
                    }
                    ContinuationStackManager.handleException("Resource : " + resourceName + " not found");
                    break;
                }
                ContinuationStackManager.handleException("REST API : " + apiName + " not found");
                break;
            }
        }
        return sequence;
    }

    public static void pushFaultHandler(MessageContext synCtx, SeqContinuationState seqContState) {
        switch (seqContState.getSeqType()) {
            case NAMED: {
                ContinuationStackManager.pushRootFaultHandlerForSequence(synCtx);
                break;
            }
            case PROXY_INSEQ: {
                String proxyName = (String)synCtx.getProperty("proxy.name");
                ProxyService proxyService = synCtx.getConfiguration().getProxyService(proxyName);
                if (proxyService != null) {
                    proxyService.registerFaultHandler(synCtx);
                    break;
                }
                ContinuationStackManager.handleException("Proxy Service :" + proxyName + " not found");
                break;
            }
            case API_INSEQ: {
                String apiName = (String)synCtx.getProperty("SYNAPSE_REST_API");
                String resourceName = (String)synCtx.getProperty("SYNAPSE_RESOURCE");
                API api = synCtx.getEnvironment().getSynapseConfiguration().getAPI(apiName);
                if (api != null) {
                    Resource resource = api.getResource(resourceName);
                    if (resource != null) {
                        resource.registerFaultHandler(synCtx);
                        break;
                    }
                    ContinuationStackManager.handleException("Resource : " + resourceName + " not found");
                    break;
                }
                ContinuationStackManager.handleException("REST API : " + apiName + " not found");
                break;
            }
            case PROXY_OUTSEQ: {
                String proxyName = (String)synCtx.getProperty("proxy.name");
                ProxyService proxyService = synCtx.getConfiguration().getProxyService(proxyName);
                if (proxyService != null) {
                    proxyService.registerFaultHandler(synCtx);
                    break;
                }
                ContinuationStackManager.handleException("Proxy Service :" + proxyName + " not found");
                break;
            }
            case API_OUTSEQ: {
                String apiName = (String)synCtx.getProperty("SYNAPSE_REST_API");
                String resourceName = (String)synCtx.getProperty("SYNAPSE_RESOURCE");
                API api = synCtx.getEnvironment().getSynapseConfiguration().getAPI(apiName);
                if (api != null) {
                    Resource resource = api.getResource(resourceName);
                    if (resource != null) {
                        resource.registerFaultHandler(synCtx);
                        break;
                    }
                    ContinuationStackManager.handleException("Resource : " + resourceName + " not found");
                    break;
                }
                ContinuationStackManager.handleException("REST API : " + apiName + " not found");
                break;
            }
        }
    }

    private static void pushRootFaultHandlerForSequence(MessageContext synCtx) {
        String inboundEndpointName;
        String proxyName = (String)synCtx.getProperty("proxy.name");
        if (proxyName != null && !"".equals(proxyName)) {
            ProxyService proxyService = synCtx.getConfiguration().getProxyService(proxyName);
            if (proxyService != null) {
                proxyService.registerFaultHandler(synCtx);
            } else {
                ContinuationStackManager.handleException("Proxy service : " + proxyName + " not found");
            }
            return;
        }
        String apiName = (String)synCtx.getProperty("SYNAPSE_REST_API");
        if (apiName != null && !"".equals(apiName)) {
            API api = synCtx.getEnvironment().getSynapseConfiguration().getAPI(apiName);
            if (api != null) {
                String resourceName = (String)synCtx.getProperty("SYNAPSE_RESOURCE");
                Resource resource = api.getResource(resourceName);
                if (resource != null) {
                    resource.registerFaultHandler(synCtx);
                } else {
                    ContinuationStackManager.handleException("Resource : " + resourceName + " not found");
                }
            } else {
                ContinuationStackManager.handleException("REST API : " + apiName + " not found");
            }
            return;
        }
        if (synCtx.getProperty("isInbound") != null && (inboundEndpointName = (String)synCtx.getProperty("inbound.endpoint.name")) != null) {
            InboundEndpoint inboundEndpoint = synCtx.getConfiguration().getInboundEndpoint(inboundEndpointName);
            if (inboundEndpoint != null) {
                String errorSeqName = inboundEndpoint.getOnErrorSeq();
                if (errorSeqName != null) {
                    SequenceMediator errorSeq = (SequenceMediator)synCtx.getConfiguration().getSequence(errorSeqName);
                    if (errorSeq != null) {
                        synCtx.pushFaultHandler(new MediatorFaultHandler(errorSeq));
                        return;
                    }
                    ContinuationStackManager.handleException("Sequence Mediator : " + errorSeqName + "not found");
                }
            } else {
                ContinuationStackManager.handleException("Inbound Endpoint : " + inboundEndpointName + "not found");
            }
        }
        synCtx.pushFaultHandler(new MediatorFaultHandler(synCtx.getFaultSequence()));
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

