/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.rest;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.api.API;
import org.apache.synapse.api.version.ContextVersionStrategy;
import org.apache.synapse.api.version.DefaultStrategy;
import org.apache.synapse.api.version.URLBasedVersionStrategy;
import org.apache.synapse.api.version.VersionStrategy;

public class VersionStrategyFactory {
    private static final Log log = LogFactory.getLog(VersionStrategyFactory.class);
    public static final String TYPE_URL = "url";
    public static final String TYPE_NULL = "";
    public static final String TYPE_CONTEXT = "context";

    public static VersionStrategy createVersioningStrategy(API api, OMElement apiElt) {
        OMAttribute versionAtt = apiElt.getAttribute(new QName("version"));
        if (versionAtt == null || TYPE_NULL.equals(versionAtt.getAttributeValue())) {
            // empty if block
        }
        OMAttribute versionTypeAtt = apiElt.getAttribute(new QName("version-type"));
        if (versionAtt != null && !versionAtt.getAttributeValue().isEmpty() && (versionTypeAtt == null || TYPE_NULL.equals(versionTypeAtt.getAttributeValue()))) {
            VersionStrategyFactory.handleException("Attribute 'version-type' is required for an API definition");
        }
        OMAttribute versionParamAtt = apiElt.getAttribute(new QName("version-param"));
        String version = TYPE_NULL;
        if (versionAtt != null) {
            version = versionAtt.getAttributeValue();
        }
        String versionType = TYPE_NULL;
        if (versionTypeAtt != null) {
            versionType = versionTypeAtt.getAttributeValue();
        }
        String versionParam = TYPE_NULL;
        if (versionParamAtt != null) {
            versionParam = versionParamAtt.getAttributeValue();
        }
        return VersionStrategyFactory.selectVersionStrategy(api, version, versionType, versionParam);
    }

    private static VersionStrategy selectVersionStrategy(API api, String version, String versionType, String versionParam) {
        if (versionType != null && TYPE_URL.equals(versionType.trim())) {
            return new URLBasedVersionStrategy(api, version, versionParam);
        }
        if (versionType != null && TYPE_CONTEXT.equals(versionType.trim())) {
            return new ContextVersionStrategy(api, version, versionParam);
        }
        if (versionType == null || TYPE_NULL.equals(versionType.trim())) {
            return new DefaultStrategy(api);
        }
        return null;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

