/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.rest;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.api.ApiConstants;
import org.apache.synapse.api.Resource;
import org.apache.synapse.api.dispatch.DispatcherHelper;
import org.apache.synapse.api.dispatch.URITemplateHelper;
import org.apache.synapse.api.dispatch.URLMappingHelper;
import org.apache.synapse.config.xml.SequenceMediatorSerializer;

public class ResourceSerializer {
    private static final OMFactory fac = OMAbstractFactory.getOMFactory();

    public static OMElement serializeResource(Resource resource) {
        OMElement resourceElt = fac.createOMElement("resource", SynapseConstants.SYNAPSE_OMNAMESPACE);
        String[] methods = resource.getMethods();
        if (methods.length > 0) {
            String value = "";
            for (String method : methods) {
                value = value + method + " ";
            }
            resourceElt.addAttribute("methods", value.trim(), null);
        }
        if (resource.getBindsTo() != null) {
            resourceElt.addAttribute(ApiConstants.BINDS_TO, String.join((CharSequence)",", resource.getBindsTo()), null);
        }
        if (resource.getContentType() != null) {
            resourceElt.addAttribute("content-type", resource.getContentType(), null);
        }
        if (resource.getUserAgent() != null) {
            resourceElt.addAttribute("user-agent", resource.getUserAgent(), null);
        }
        if (resource.getProtocol() == 1) {
            resourceElt.addAttribute("protocol", "http", null);
        } else if (resource.getProtocol() == 2) {
            resourceElt.addAttribute("protocol", "https", null);
        }
        DispatcherHelper helper = resource.getDispatcherHelper();
        if (helper != null) {
            if (helper instanceof URLMappingHelper) {
                resourceElt.addAttribute("url-mapping", helper.getString(), null);
            } else if (helper instanceof URITemplateHelper) {
                resourceElt.addAttribute("uri-template", helper.getString(), null);
            }
        }
        SequenceMediatorSerializer seqSerializer = new SequenceMediatorSerializer();
        if (resource.getInSequenceKey() != null) {
            resourceElt.addAttribute("inSequence", resource.getInSequenceKey(), null);
        } else if (resource.getInSequence() != null) {
            OMElement inSeqElement = seqSerializer.serializeAnonymousSequence(null, resource.getInSequence());
            inSeqElement.setLocalName("inSequence");
            resourceElt.addChild((OMNode)inSeqElement);
        }
        if (resource.getOutSequenceKey() != null) {
            resourceElt.addAttribute("outSequence", resource.getOutSequenceKey(), null);
        } else if (resource.getOutSequence() != null) {
            OMElement outSeqElement = seqSerializer.serializeAnonymousSequence(null, resource.getOutSequence());
            outSeqElement.setLocalName("outSequence");
            resourceElt.addChild((OMNode)outSeqElement);
        }
        if (resource.getFaultSequenceKey() != null) {
            resourceElt.addAttribute("faultSequence", resource.getFaultSequenceKey(), null);
        } else if (resource.getFaultSequence() != null) {
            OMElement faultSeqElement = seqSerializer.serializeAnonymousSequence(null, resource.getFaultSequence());
            faultSeqElement.setLocalName("faultSequence");
            resourceElt.addChild((OMNode)faultSeqElement);
        }
        return resourceElt;
    }
}

