/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.rest;

import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SequenceType;
import org.apache.synapse.SynapseException;
import org.apache.synapse.api.Resource;
import org.apache.synapse.api.dispatch.URITemplateHelper;
import org.apache.synapse.api.dispatch.URLMappingHelper;
import org.apache.synapse.api.inbound.InboundApiUtils;
import org.apache.synapse.config.xml.SequenceMediatorFactory;
import org.apache.synapse.mediators.base.SequenceMediator;

public class ResourceFactory {
    private static final Log log = LogFactory.getLog(ResourceFactory.class);

    public static Resource createResource(OMElement resourceElt) {
        return ResourceFactory.createResource(resourceElt, new Properties());
    }

    public static Resource createResource(OMElement resourceElt, Properties properties) {
        Resource resource = new Resource();
        ResourceFactory.configureURLMappings(resource, resourceElt);
        ResourceFactory.configureSequences(resource, resourceElt, properties);
        ResourceFactory.configureFilters(resource, resourceElt);
        InboundApiUtils.addBindsTo(resource, resourceElt);
        return resource;
    }

    private static void configureFilters(Resource resource, OMElement resourceElt) {
        OMAttribute methodsAtt;
        OMAttribute userAgentAtt;
        OMAttribute contentTypeAtt;
        OMAttribute protocolAtt = resourceElt.getAttribute(new QName("protocol"));
        if (protocolAtt != null && !"".equals(protocolAtt.getAttributeValue())) {
            if ("http".equals(protocolAtt.getAttributeValue())) {
                resource.setProtocol(1);
            } else if ("https".equals(protocolAtt.getAttributeValue())) {
                resource.setProtocol(2);
            } else {
                ResourceFactory.handleException("Invalid protocol name: " + protocolAtt.getAttributeValue());
            }
        }
        if ((contentTypeAtt = resourceElt.getAttribute(new QName("content-type"))) != null && !"".equals(contentTypeAtt.getAttributeValue())) {
            resource.setContentType(contentTypeAtt.getAttributeValue());
        }
        if ((userAgentAtt = resourceElt.getAttribute(new QName("user-agent"))) != null && !"".equals(userAgentAtt.getAttributeValue())) {
            resource.setUserAgent(userAgentAtt.getAttributeValue());
        }
        if ((methodsAtt = resourceElt.getAttribute(new QName("methods"))) != null && !"".equals(methodsAtt.getAttributeValue())) {
            String[] methods;
            for (String method : methods = methodsAtt.getAttributeValue().trim().split(" ")) {
                boolean added = resource.addMethod(method);
                if (added) continue;
                ResourceFactory.handleException("Invalid or duplicate method definition for resource");
            }
        }
    }

    private static void configureURLMappings(Resource resource, OMElement resourceElt) {
        OMAttribute urlMappingAtt = resourceElt.getAttribute(new QName("url-mapping"));
        OMAttribute uriTemplateAtt = resourceElt.getAttribute(new QName("uri-template"));
        if (urlMappingAtt != null && !"".equals(urlMappingAtt.getAttributeValue())) {
            resource.setDispatcherHelper(new URLMappingHelper(urlMappingAtt.getAttributeValue()));
        } else if (uriTemplateAtt != null && !"".equals(uriTemplateAtt.getAttributeValue())) {
            resource.setDispatcherHelper(new URITemplateHelper(uriTemplateAtt.getAttributeValue()));
        }
    }

    private static void configureSequences(Resource resource, OMElement resourceElt, Properties properties) {
        OMAttribute inSequenceKeyAtt = resourceElt.getAttribute(new QName("inSequence"));
        OMElement inSequenceElt = resourceElt.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "inSequence"));
        if (inSequenceKeyAtt != null && !"".equals(inSequenceKeyAtt.getAttributeValue())) {
            resource.setInSequenceKey(inSequenceKeyAtt.getAttributeValue());
        } else if (inSequenceElt != null) {
            SequenceMediatorFactory fac = new SequenceMediatorFactory();
            SequenceMediator sequence = fac.createAnonymousSequence(inSequenceElt, properties);
            sequence.setSequenceType(SequenceType.API_INSEQ);
            resource.setInSequence(sequence);
        }
        OMAttribute outSequenceKeyAtt = resourceElt.getAttribute(new QName("outSequence"));
        OMElement outSequenceElt = resourceElt.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "outSequence"));
        if (outSequenceKeyAtt != null && !"".equals(outSequenceKeyAtt.getAttributeValue())) {
            resource.setOutSequenceKey(outSequenceKeyAtt.getAttributeValue());
        } else if (outSequenceElt != null) {
            SequenceMediatorFactory fac = new SequenceMediatorFactory();
            SequenceMediator sequence = fac.createAnonymousSequence(outSequenceElt, properties);
            sequence.setSequenceType(SequenceType.API_OUTSEQ);
            resource.setOutSequence(sequence);
        }
        OMAttribute faultSequenceKeyAtt = resourceElt.getAttribute(new QName("faultSequence"));
        OMElement faultSequenceElt = resourceElt.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "faultSequence"));
        if (faultSequenceKeyAtt != null && !"".equals(faultSequenceKeyAtt.getAttributeValue())) {
            resource.setFaultSequenceKey(faultSequenceKeyAtt.getAttributeValue());
        } else if (faultSequenceElt != null) {
            SequenceMediatorFactory fac = new SequenceMediatorFactory();
            SequenceMediator sequence = fac.createAnonymousSequence(faultSequenceElt, properties);
            sequence.setSequenceType(SequenceType.API_FAULTSEQ);
            resource.setFaultSequence(sequence);
        }
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

