/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.rest;

import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.api.API;
import org.apache.synapse.api.inbound.InboundApiUtils;
import org.apache.synapse.api.version.VersionStrategy;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.commons.util.PropertyHelper;
import org.apache.synapse.config.xml.rest.ResourceFactory;
import org.apache.synapse.config.xml.rest.VersionStrategyFactory;
import org.apache.synapse.rest.Handler;
import org.apache.synapse.util.CommentListUtil;

public class APIFactory {
    private static final Log log = LogFactory.getLog(APIFactory.class);
    static final QName PROP_Q = new QName("http://ws.apache.org/ns/synapse", "property");
    static final QName ATT_NAME = new QName("name");
    static final QName ATT_VALUE = new QName("value");

    public static API createAPI(OMElement apiElt) {
        return APIFactory.createAPI(apiElt, new Properties());
    }

    public static API createAPI(OMElement apiElt, Properties properties) {
        String tracingValue;
        OMAttribute tracing;
        String statisticsValue;
        String nameString;
        String transports;
        OMAttribute trans;
        OMElement handlersElt;
        OMAttribute publishSwagger;
        OMAttribute contextAtt;
        OMAttribute nameAtt = apiElt.getAttribute(new QName("name"));
        if (nameAtt == null || "".equals(nameAtt.getAttributeValue())) {
            APIFactory.handleException("Attribute 'name' is required for an API definition");
        }
        if ((contextAtt = apiElt.getAttribute(new QName("context"))) == null || "".equals(contextAtt.getAttributeValue())) {
            APIFactory.handleException("Attribute 'context' is required for an API definition");
        }
        API api = new API(nameAtt.getAttributeValue(), contextAtt.getAttributeValue());
        OMAttribute hostAtt = apiElt.getAttribute(new QName("hostname"));
        if (hostAtt != null && !"".equals(hostAtt.getAttributeValue())) {
            api.setHost(hostAtt.getAttributeValue());
        }
        VersionStrategy vStrategy = VersionStrategyFactory.createVersioningStrategy(api, apiElt);
        api.setVersionStrategy(vStrategy);
        OMAttribute portAtt = apiElt.getAttribute(new QName("port"));
        if (portAtt != null && !"".equals(portAtt.getAttributeValue())) {
            api.setPort(Integer.parseInt(portAtt.getAttributeValue()));
        }
        if ((publishSwagger = apiElt.getAttribute(new QName("publishSwagger"))) != null) {
            api.setSwaggerResourcePath(publishSwagger.getAttributeValue());
        }
        InboundApiUtils.addBindsTo(api, apiElt);
        Iterator resources = apiElt.getChildrenWithName(new QName("http://ws.apache.org/ns/synapse", "resource"));
        boolean noResources = true;
        while (resources.hasNext()) {
            OMElement resourceElt = (OMElement)resources.next();
            api.addResource(ResourceFactory.createResource(resourceElt, properties));
            noResources = false;
        }
        if (noResources) {
            APIFactory.handleException("An API must contain at least one resource definition");
        }
        if ((handlersElt = apiElt.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "handlers"))) != null) {
            Iterator handlers = handlersElt.getChildrenWithName(new QName("http://ws.apache.org/ns/synapse", "handler"));
            while (handlers.hasNext()) {
                OMElement handlerElt = (OMElement)handlers.next();
                APIFactory.defineHandler(api, handlerElt);
            }
        }
        if ((trans = apiElt.getAttribute(new QName("", "transports"))) != null && !"".equals(transports = trans.getAttributeValue())) {
            if ("http".equals(transports)) {
                api.setProtocol(1);
            } else if ("https".equals(transports)) {
                api.setProtocol(2);
            } else {
                APIFactory.handleException("Invalid protocol name: " + transports);
            }
        }
        if ((nameString = api.getName()) == null || "".equals(nameString)) {
            nameString = "AnonymousApi";
        }
        AspectConfiguration aspectConfiguration = new AspectConfiguration(nameString);
        api.configure(aspectConfiguration);
        OMAttribute statistics = apiElt.getAttribute(new QName("", "statistics"));
        if (statistics != null && (statisticsValue = statistics.getAttributeValue()) != null && "enable".equals(statisticsValue)) {
            aspectConfiguration.enableStatistics();
        }
        if ((tracing = apiElt.getAttribute(new QName("", "trace"))) != null && (tracingValue = tracing.getAttributeValue()) != null && "enable".equals(tracingValue)) {
            aspectConfiguration.enableTracing();
        }
        CommentListUtil.populateComments(apiElt, api.getCommentsList());
        return api;
    }

    private static void defineHandler(API api, OMElement handlerElt) {
        String handlerClass = handlerElt.getAttributeValue(new QName("class"));
        if (handlerClass == null || "".equals(handlerClass)) {
            APIFactory.handleException("A handler element must have a class attribute");
        }
        try {
            Class<?> clazz = APIFactory.class.getClassLoader().loadClass(handlerClass);
            Handler handler = (Handler)clazz.newInstance();
            api.addHandler(handler);
            Iterator it = handlerElt.getChildrenWithName(PROP_Q);
            while (it.hasNext()) {
                OMElement child = (OMElement)it.next();
                String propName = child.getAttribute(ATT_NAME).getAttributeValue();
                if (propName == null) {
                    APIFactory.handleException("A Class mediator property must specify the name attribute");
                    continue;
                }
                if (child.getAttribute(ATT_VALUE) != null) {
                    String value = child.getAttribute(ATT_VALUE).getAttributeValue();
                    handler.addProperty(propName, value);
                    PropertyHelper.setInstanceProperty((String)propName, (Object)value, (Object)handler);
                    continue;
                }
                OMElement omElt = child.getFirstElement();
                if (omElt != null) {
                    handler.addProperty(propName, omElt);
                    PropertyHelper.setInstanceProperty((String)propName, (Object)omElt, (Object)handler);
                    continue;
                }
                APIFactory.handleException("A Class mediator property must specify name and value attributes, or a name and a child XML fragment");
            }
        }
        catch (Exception e) {
            APIFactory.handleException("Error initializing API handler: " + handlerClass, e);
        }
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }
}

