/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.inbound;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.inbound.InboundEndpoint;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class InboundEndpointSerializer {
    private static final OMFactory fac = OMAbstractFactory.getOMFactory();
    protected static final OMNamespace nullNS = fac.createOMNamespace("", "");

    public static OMElement serializeInboundEndpoint(InboundEndpoint inboundEndpoint) {
        OMElement inboundEndpointElt = fac.createOMElement("inboundEndpoint", SynapseConstants.SYNAPSE_OMNAMESPACE);
        inboundEndpointElt.addAttribute("name", inboundEndpoint.getName(), null);
        if (inboundEndpoint.getInjectingSeq() != null) {
            inboundEndpointElt.addAttribute("sequence", inboundEndpoint.getInjectingSeq(), null);
        }
        if (inboundEndpoint.getOnErrorSeq() != null) {
            inboundEndpointElt.addAttribute("onError", inboundEndpoint.getOnErrorSeq(), null);
        }
        if (inboundEndpoint.getProtocol() != null) {
            inboundEndpointElt.addAttribute("protocol", inboundEndpoint.getProtocol(), null);
        } else {
            inboundEndpointElt.addAttribute("class", inboundEndpoint.getClassImpl(), null);
        }
        AspectConfiguration statisticsConfigurable = inboundEndpoint.getAspectConfiguration();
        if (statisticsConfigurable != null && statisticsConfigurable.isStatisticsEnable()) {
            inboundEndpointElt.addAttribute("statistics", "enable", null);
        }
        if (statisticsConfigurable != null && statisticsConfigurable.isTracingEnabled()) {
            inboundEndpointElt.addAttribute("trace", "enable", null);
        }
        inboundEndpointElt.addAttribute("suspend", Boolean.toString(inboundEndpoint.isSuspend()), null);
        OMElement parametersElt = fac.createOMElement("parameters", SynapseConstants.SYNAPSE_OMNAMESPACE);
        for (Map.Entry<String, String> paramEntry : inboundEndpoint.getParametersMap().entrySet()) {
            String strKey = paramEntry.getKey();
            OMElement parameter = fac.createOMElement("parameter", SynapseConstants.SYNAPSE_OMNAMESPACE);
            parameter.addAttribute("name", strKey, null);
            if (inboundEndpoint.getParameterKey(strKey) != null) {
                parameter.addAttribute("key", inboundEndpoint.getParameterKey(strKey), null);
            } else if (InboundEndpointSerializer.isWellFormedXML(paramEntry.getValue())) {
                try {
                    OMElement omElement = AXIOMUtil.stringToOM((String)paramEntry.getValue());
                    parameter.addChild((OMNode)omElement);
                }
                catch (XMLStreamException e) {
                    String msg = "Error Parsing OMElement for value of " + paramEntry.getKey();
                    throw new SynapseException(msg, e);
                }
            } else {
                parameter.setText(paramEntry.getValue());
            }
            parametersElt.addChild((OMNode)parameter);
        }
        inboundEndpointElt.addChild((OMNode)parametersElt);
        return inboundEndpointElt;
    }

    public static OMElement serializeInboundEndpoint(OMElement parent, InboundEndpoint inboundEndpoint) {
        OMElement inboundEndpointElt = InboundEndpointSerializer.serializeInboundEndpoint(inboundEndpoint);
        if (parent != null) {
            parent.addChild((OMNode)inboundEndpointElt);
        }
        return inboundEndpointElt;
    }

    private static boolean isWellFormedXML(String value) {
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setErrorHandler(null);
            InputSource source = new InputSource(new ByteArrayInputStream(value.getBytes()));
            parser.parse(source);
        }
        catch (SAXException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

