/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.inbound;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.commons.resolvers.ResolverFactory;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.inbound.InboundEndpoint;

public class InboundEndpointFactory {
    private static final Log log = LogFactory.getLog(InboundEndpointFactory.class);
    private static final QName ATT_NAME = new QName("name");
    private static final QName ATT_PROTOCOL = new QName("protocol");
    private static final QName ATT_ENDPOINT_CLASS = new QName("class");
    private static final QName ATT_ENDPOINT_SUSPEND = new QName("suspend");
    private static final QName ATT_SEQUENCE = new QName("sequence");
    private static final QName ATT_ERROR_SEQUENCE = new QName("onError");

    public static InboundEndpoint createInboundEndpoint(OMElement inboundEndpointElem, SynapseConfiguration config) {
        OMElement parametersElt;
        String tracingValue;
        OMAttribute tracing;
        String statisticsValue;
        String nameString;
        InboundEndpoint inboundEndpoint = new InboundEndpoint();
        if (inboundEndpointElem.getAttributeValue(ATT_NAME) == null) {
            String msg = "Inbound Endpoint name cannot be null";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        inboundEndpoint.setName(inboundEndpointElem.getAttributeValue(ATT_NAME));
        if (inboundEndpointElem.getAttributeValue(ATT_PROTOCOL) != null) {
            inboundEndpoint.setProtocol(inboundEndpointElem.getAttributeValue(ATT_PROTOCOL));
        }
        if (inboundEndpointElem.getAttributeValue(ATT_ENDPOINT_CLASS) != null) {
            inboundEndpoint.setClassImpl(inboundEndpointElem.getAttributeValue(ATT_ENDPOINT_CLASS));
        }
        if (inboundEndpointElem.getAttributeValue(ATT_ENDPOINT_SUSPEND) != null) {
            inboundEndpoint.setSuspend(Boolean.parseBoolean(inboundEndpointElem.getAttributeValue(ATT_ENDPOINT_SUSPEND)));
        } else {
            inboundEndpoint.setSuspend(false);
        }
        if (inboundEndpointElem.getAttributeValue(ATT_SEQUENCE) != null) {
            inboundEndpoint.setInjectingSeq(inboundEndpointElem.getAttributeValue(ATT_SEQUENCE));
        }
        if (inboundEndpointElem.getAttributeValue(ATT_ERROR_SEQUENCE) != null) {
            inboundEndpoint.setOnErrorSeq(inboundEndpointElem.getAttributeValue(ATT_ERROR_SEQUENCE));
        }
        if ((nameString = inboundEndpoint.getName()) == null || "".equals(nameString)) {
            nameString = "inbound.endpoint.name";
        }
        AspectConfiguration aspectConfiguration = new AspectConfiguration(nameString);
        inboundEndpoint.configure(aspectConfiguration);
        OMAttribute statistics = inboundEndpointElem.getAttribute(new QName("", "statistics"));
        if (statistics != null && (statisticsValue = statistics.getAttributeValue()) != null && "enable".equals(statisticsValue)) {
            aspectConfiguration.enableStatistics();
        }
        if ((tracing = inboundEndpointElem.getAttribute(new QName("", "trace"))) != null && (tracingValue = tracing.getAttributeValue()) != null && "enable".equals(tracingValue)) {
            aspectConfiguration.enableTracing();
        }
        if ((parametersElt = inboundEndpointElem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "parameters"))) != null) {
            Iterator parameters = parametersElt.getChildrenWithName(new QName("http://ws.apache.org/ns/synapse", "parameter"));
            while (parameters.hasNext()) {
                OMElement parameter = (OMElement)parameters.next();
                String paramName = parameter.getAttributeValue(new QName("name"));
                String paramKey = parameter.getAttributeValue(new QName("key"));
                if (paramKey != null) {
                    Object obj = config.getEntry(paramKey);
                    if (obj == null) {
                        obj = config.getEntryDefinition(paramKey);
                        obj = config.getEntry(paramKey);
                    }
                    if (obj != null && obj instanceof OMTextImpl) {
                        OMText objText = (OMText)obj;
                        inboundEndpoint.addParameter(paramName, objText.getText(), paramKey);
                        continue;
                    }
                    String msg = "Error while deploying inbound endpoint " + inboundEndpoint.getName() + ".Registry entry defined with key: " + paramKey + " not found.";
                    log.error((Object)msg);
                    throw new SynapseException(msg);
                }
                if (parameter.getFirstElement() != null) {
                    inboundEndpoint.addParameter(paramName, parameter.getFirstElement().toString());
                    continue;
                }
                String resolvedParameter = parameter.getText() == null ? null : ResolverFactory.getInstance().getResolver(parameter.getText()).resolve();
                inboundEndpoint.addParameter(paramName, resolvedParameter);
            }
        }
        inboundEndpoint.setFileName(inboundEndpointElem.getAttributeValue(new QName("name")) + ".xml");
        return inboundEndpoint;
    }
}

