/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.endpoints.Template;
import org.apache.synapse.util.CommentListUtil;

public class TemplateFactory {
    public static final Log log = LogFactory.getLog(TemplateFactory.class);

    public Template createEndpointTemplate(OMElement element, Properties properties) {
        OMElement endpointElement;
        Template template = new Template();
        OMAttribute nameAttribute = element.getAttribute(new QName("", "name"));
        if (nameAttribute != null) {
            template.setName(nameAttribute.getAttributeValue());
        } else {
            this.handleException("Error loading the configuration from endpointTemplate, 'name' attribute missing");
        }
        Iterator paramItr = element.getChildrenWithName(new QName("http://ws.apache.org/ns/synapse", "parameter"));
        while (paramItr.hasNext()) {
            OMElement paramElement = (OMElement)paramItr.next();
            OMAttribute paramName = paramElement.getAttribute(new QName("name"));
            if (paramName == null) {
                this.handleException("parameter name should be present");
            }
            assert (paramName != null);
            template.addParameter(paramName.getAttributeValue().trim());
        }
        if (!template.getParameters().contains("name")) {
            template.addParameter("name");
        }
        if (!template.getParameters().contains("uri")) {
            template.addParameter("uri");
        }
        if ((endpointElement = element.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "endpoint"))) == null) {
            this.handleException("endpoint element is required in an endpoint template");
        }
        template.setElement(endpointElement);
        CommentListUtil.populateComments(element, template.getCommentsList());
        return template;
    }

    protected void handleException(String message) {
        log.error((Object)message);
        throw new SynapseException(message);
    }
}

