/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import java.util.Map;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.config.xml.endpoints.EndpointSerializer;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.ServiceDynamicLoadbalanceEndpoint;
import org.apache.synapse.endpoints.dispatch.Dispatcher;
import org.apache.synapse.endpoints.dispatch.HttpSessionDispatcher;
import org.apache.synapse.endpoints.dispatch.SimpleClientSessionDispatcher;
import org.apache.synapse.endpoints.dispatch.SoapSessionDispatcher;

public class ServiceDynamicLoadbalanceEndpointSerializer
extends EndpointSerializer {
    @Override
    protected OMElement serializeEndpoint(Endpoint endpoint) {
        if (!(endpoint instanceof ServiceDynamicLoadbalanceEndpoint)) {
            this.handleException("Invalid endpoint type.");
        }
        this.fac = OMAbstractFactory.getOMFactory();
        OMElement endpointElement = this.fac.createOMElement("endpoint", SynapseConstants.SYNAPSE_OMNAMESPACE);
        ServiceDynamicLoadbalanceEndpoint dynamicLoadbalanceEndpoint = (ServiceDynamicLoadbalanceEndpoint)endpoint;
        this.serializeProperties(dynamicLoadbalanceEndpoint, endpointElement);
        this.serializeCommonAttributes(endpoint, endpointElement);
        Dispatcher dispatcher = dynamicLoadbalanceEndpoint.getDispatcher();
        if (dispatcher != null) {
            OMElement sessionElement = this.fac.createOMElement("session", SynapseConstants.SYNAPSE_OMNAMESPACE);
            if (dispatcher instanceof SoapSessionDispatcher) {
                sessionElement.addAttribute("type", "soap", null);
            } else if (dispatcher instanceof HttpSessionDispatcher) {
                sessionElement.addAttribute("type", "http", null);
            } else if (dispatcher instanceof SimpleClientSessionDispatcher) {
                sessionElement.addAttribute("type", "simpleClientSession", null);
            } else {
                this.handleException("invalid session dispatcher : " + dispatcher.getClass().getName());
            }
            long sessionTimeout = dynamicLoadbalanceEndpoint.getSessionTimeout();
            if (sessionTimeout != -1L) {
                OMElement sessionTimeoutElement = this.fac.createOMElement("sessionTimeout", SynapseConstants.SYNAPSE_OMNAMESPACE);
                sessionTimeoutElement.setText(String.valueOf(sessionTimeout));
                sessionElement.addChild((OMNode)sessionTimeoutElement);
            }
            endpointElement.addChild((OMNode)sessionElement);
        }
        OMElement dynamicLoadbalanceElement = this.fac.createOMElement("serviceDynamicLoadbalance", SynapseConstants.SYNAPSE_OMNAMESPACE);
        endpointElement.addChild((OMNode)dynamicLoadbalanceElement);
        dynamicLoadbalanceElement.addAttribute("algorithm", dynamicLoadbalanceEndpoint.getAlgorithm().getClass().getName(), null);
        OMElement servicesEle = this.fac.createOMElement("services", SynapseConstants.SYNAPSE_OMNAMESPACE);
        dynamicLoadbalanceElement.addChild((OMNode)servicesEle);
        Map<String, String> hostDomainMap = dynamicLoadbalanceEndpoint.getHostDomainMap();
        for (Map.Entry<String, String> entry : hostDomainMap.entrySet()) {
            OMElement serviceEle = this.fac.createOMElement("service", SynapseConstants.SYNAPSE_OMNAMESPACE);
            servicesEle.addChild((OMNode)serviceEle);
            OMElement hostEle = this.fac.createOMElement("host", SynapseConstants.SYNAPSE_OMNAMESPACE);
            hostEle.setText(entry.getKey());
            serviceEle.addChild((OMNode)hostEle);
            OMElement domainEle = this.fac.createOMElement("domain", SynapseConstants.SYNAPSE_OMNAMESPACE);
            domainEle.setText(entry.getValue());
            serviceEle.addChild((OMNode)domainEle);
        }
        return endpointElement;
    }
}

