/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.config.xml.endpoints.EndpointSerializer;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.SALoadbalanceEndpoint;
import org.apache.synapse.endpoints.dispatch.Dispatcher;
import org.apache.synapse.endpoints.dispatch.HttpSessionDispatcher;
import org.apache.synapse.endpoints.dispatch.SimpleClientSessionDispatcher;
import org.apache.synapse.endpoints.dispatch.SoapSessionDispatcher;

public class SALoadbalanceEndpointSerializer
extends EndpointSerializer {
    @Override
    protected OMElement serializeEndpoint(Endpoint endpoint) {
        if (!(endpoint instanceof SALoadbalanceEndpoint)) {
            this.handleException("Invalid endpoint type for serializing. Expected: SALoadbalanceEndpoint Found: " + endpoint.getClass().getName());
        }
        SALoadbalanceEndpoint loadbalanceEndpoint = (SALoadbalanceEndpoint)endpoint;
        this.fac = OMAbstractFactory.getOMFactory();
        OMElement endpointElement = this.fac.createOMElement("endpoint", SynapseConstants.SYNAPSE_OMNAMESPACE);
        this.serializeProperties(loadbalanceEndpoint, endpointElement);
        this.serializeCommonAttributes(endpoint, endpointElement);
        OMElement loadbalanceElement = this.fac.createOMElement("loadbalance", SynapseConstants.SYNAPSE_OMNAMESPACE);
        endpointElement.addChild((OMNode)loadbalanceElement);
        Dispatcher dispatcher = loadbalanceEndpoint.getDispatcher();
        if (dispatcher != null) {
            OMElement sessionElement = this.fac.createOMElement("session", SynapseConstants.SYNAPSE_OMNAMESPACE);
            if (dispatcher instanceof SoapSessionDispatcher) {
                sessionElement.addAttribute("type", "soap", null);
            } else if (dispatcher instanceof HttpSessionDispatcher) {
                sessionElement.addAttribute("type", "http", null);
            } else if (dispatcher instanceof SimpleClientSessionDispatcher) {
                sessionElement.addAttribute("type", "simpleClientSession", null);
            } else {
                this.handleException("invalid session dispatcher : " + dispatcher.getClass().getName());
            }
            long sessionTimeout = loadbalanceEndpoint.getSessionTimeout();
            if (sessionTimeout != -1L) {
                OMElement sessionTimeoutElement = this.fac.createOMElement("sessionTimeout", SynapseConstants.SYNAPSE_OMNAMESPACE);
                sessionTimeoutElement.setText(String.valueOf(sessionTimeout));
                sessionElement.addChild((OMNode)sessionTimeoutElement);
            }
            endpointElement.addChild((OMNode)sessionElement);
        }
        loadbalanceElement.addAttribute("algorithm", loadbalanceEndpoint.getAlgorithm().getClass().getName(), null);
        if (loadbalanceEndpoint.isBuildMessageAtt()) {
            loadbalanceElement.addAttribute("buildMessage", Boolean.toString(loadbalanceEndpoint.isBuildMessageAtt()), null);
        }
        for (Endpoint childEndpoint : loadbalanceEndpoint.getChildren()) {
            loadbalanceElement.addChild((OMNode)EndpointSerializer.getElementFromEndpoint(childEndpoint));
        }
        return endpointElement;
    }
}

