/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.clustering.Member;
import org.apache.axis2.util.JavaUtils;
import org.apache.synapse.SynapseException;
import org.apache.synapse.commons.resolvers.ResolverFactory;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.config.xml.endpoints.utils.LoadbalanceAlgorithmFactory;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.LoadbalanceEndpoint;
import org.apache.synapse.endpoints.algorithms.LoadbalanceAlgorithm;

public final class LoadbalanceEndpointFactory
extends EndpointFactory {
    private static LoadbalanceEndpointFactory instance = new LoadbalanceEndpointFactory();
    private static final QName MEMBER = new QName("http://ws.apache.org/ns/synapse", "member");

    private LoadbalanceEndpointFactory() {
    }

    public static LoadbalanceEndpointFactory getInstance() {
        return instance;
    }

    @Override
    protected Endpoint createEndpoint(OMElement epConfig, boolean anonymousEndpoint, Properties properties) {
        OMElement loadbalanceElement = epConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "loadbalance"));
        if (loadbalanceElement != null) {
            String buildMessageAtt;
            LoadbalanceEndpoint loadbalanceEndpoint = new LoadbalanceEndpoint();
            OMAttribute name = epConfig.getAttribute(new QName("", "name"));
            if (name != null) {
                loadbalanceEndpoint.setName(name.getAttributeValue());
            }
            LoadbalanceAlgorithm algorithm = null;
            if (loadbalanceElement.getFirstChildWithName(XMLConfigConstants.ENDPOINT_ELT) != null) {
                if (loadbalanceElement.getChildrenWithName(MEMBER).hasNext()) {
                    String msg = "Invalid Synapse configuration. child elements";
                    log.error((Object)msg);
                    throw new SynapseException(msg);
                }
                ArrayList<Endpoint> endpoints = this.getEndpoints(loadbalanceElement, loadbalanceEndpoint, properties);
                loadbalanceEndpoint.setChildren(endpoints);
                algorithm = LoadbalanceAlgorithmFactory.createLoadbalanceAlgorithm(loadbalanceElement, endpoints);
                algorithm.setLoadBalanceEndpoint(loadbalanceEndpoint);
            } else if (loadbalanceElement.getFirstChildWithName(MEMBER) != null) {
                if (loadbalanceElement.getChildrenWithName(XMLConfigConstants.ENDPOINT_ELT).hasNext()) {
                    String msg = "Invalid Synapse configuration. loadbalanceEndpoint element cannot have both member & endpoint child elements";
                    log.error((Object)msg);
                    throw new SynapseException(msg);
                }
                List<Member> members = this.getMembers(loadbalanceElement);
                loadbalanceEndpoint.setMembers(members);
                algorithm = LoadbalanceAlgorithmFactory.createLoadbalanceAlgorithm2(loadbalanceElement, members);
                loadbalanceEndpoint.startApplicationMembershipTimer();
            }
            if (loadbalanceEndpoint.getChildren() == null && loadbalanceEndpoint.getMembers() == null) {
                String msg = "Invalid Synapse configuration.\nA LoadbalanceEndpoint must have child elements, but the LoadbalanceEndpoint '" + loadbalanceEndpoint.getName() + "' does not have any child elements.";
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            loadbalanceEndpoint.setAlgorithm(algorithm);
            String failover = loadbalanceElement.getAttributeValue(new QName("failover"));
            if (failover != null && failover.equalsIgnoreCase("false")) {
                loadbalanceEndpoint.setFailover(false);
            }
            if ((buildMessageAtt = loadbalanceElement.getAttributeValue(new QName("buildMessage"))) != null) {
                loadbalanceEndpoint.setBuildMessageAttAvailable(true);
                if (JavaUtils.isTrueExplicitly((String)buildMessageAtt)) {
                    loadbalanceEndpoint.setBuildMessageAtt(true);
                }
            }
            this.processProperties(loadbalanceEndpoint, epConfig);
            return loadbalanceEndpoint;
        }
        return null;
    }

    private List<Member> getMembers(OMElement loadbalanceElement) {
        ArrayList<Member> members = new ArrayList<Member>();
        Iterator memberIter = loadbalanceElement.getChildrenWithName(MEMBER);
        while (memberIter.hasNext()) {
            String https;
            OMElement memberEle = (OMElement)memberIter.next();
            String memberHostname = memberEle.getAttributeValue(new QName("hostName"));
            memberHostname = ResolverFactory.getInstance().getResolver(memberHostname).resolve();
            Member member = new Member(memberHostname, -1);
            String http = memberEle.getAttributeValue(new QName("httpPort"));
            if (http != null) {
                http = ResolverFactory.getInstance().getResolver(http).resolve();
                member.setHttpPort(Integer.parseInt(http));
            }
            if ((https = memberEle.getAttributeValue(new QName("httpsPort"))) != null && https.trim().length() != 0) {
                https = ResolverFactory.getInstance().getResolver(https).resolve();
                member.setHttpsPort(Integer.parseInt(https.trim()));
            }
            members.add(member);
        }
        return members;
    }
}

