/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.config.xml.endpoints.DefaultEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.EndpointDefinitionSerializer;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.endpoints.HTTPEndpoint;
import org.apache.synapse.endpoints.OAuthConfiguredHTTPEndpoint;
import org.apache.synapse.endpoints.oauth.AuthorizationCodeHandler;
import org.apache.synapse.endpoints.oauth.ClientCredentialsHandler;

public class HTTPEndpointSerializer
extends DefaultEndpointSerializer {
    @Override
    protected OMElement serializeEndpoint(Endpoint endpoint) {
        if (!(endpoint instanceof HTTPEndpoint)) {
            this.handleException("Invalid endpoint type.");
        }
        this.fac = OMAbstractFactory.getOMFactory();
        OMElement endpointElement = this.fac.createOMElement("endpoint", SynapseConstants.SYNAPSE_OMNAMESPACE);
        HTTPEndpoint httpEndpoint = (HTTPEndpoint)endpoint;
        EndpointDefinition epDefinitionHttp = httpEndpoint.getDefinition();
        OMElement httpEPElement = this.serializeEndpointDefinition(epDefinitionHttp);
        if (httpEndpoint.getHttpMethod() != null) {
            httpEPElement.addAttribute(this.fac.createOMAttribute("method", null, httpEndpoint.getHttpMethod()));
        }
        if (httpEndpoint.getUriTemplate() != null) {
            if (httpEndpoint.isLegacySupport()) {
                httpEPElement.addAttribute(this.fac.createOMAttribute("uri-template", null, HTTPEndpoint.legacyPrefix + httpEndpoint.getUriTemplate().getTemplate()));
            } else {
                httpEPElement.addAttribute(this.fac.createOMAttribute("uri-template", null, httpEndpoint.getUriTemplate().getTemplate()));
            }
        }
        endpointElement.addChild((OMNode)httpEPElement);
        if (endpoint instanceof OAuthConfiguredHTTPEndpoint) {
            httpEPElement.addChild((OMNode)this.serializeOAuthConfiguration((OAuthConfiguredHTTPEndpoint)endpoint));
        }
        this.serializeProperties(httpEndpoint, endpointElement);
        this.serializeCommonAttributes(endpoint, endpointElement);
        return endpointElement;
    }

    @Override
    public OMElement serializeEndpointDefinition(EndpointDefinition endpointDefinition) {
        OMElement element = this.fac.createOMElement("http", SynapseConstants.SYNAPSE_OMNAMESPACE);
        EndpointDefinitionSerializer serializer = new EndpointDefinitionSerializer();
        serializer.serializeEndpointDefinition(endpointDefinition, element);
        this.serializeSpecificEndpointProperties(endpointDefinition, element);
        return element;
    }

    private OMElement serializeOAuthConfiguration(OAuthConfiguredHTTPEndpoint oAuthConfiguredHTTPEndpoint) {
        OMElement authentication = this.fac.createOMElement("authentication", SynapseConstants.SYNAPSE_OMNAMESPACE);
        OMElement oauth = this.fac.createOMElement("oauth", SynapseConstants.SYNAPSE_OMNAMESPACE);
        authentication.addChild((OMNode)oauth);
        if (oAuthConfiguredHTTPEndpoint.getOauthHandler() instanceof AuthorizationCodeHandler) {
            oauth.addChild((OMNode)this.serializeAuthorizationCodeConfigurationElements((AuthorizationCodeHandler)oAuthConfiguredHTTPEndpoint.getOauthHandler()));
        }
        if (oAuthConfiguredHTTPEndpoint.getOauthHandler() instanceof ClientCredentialsHandler) {
            oauth.addChild((OMNode)this.serializeClientCredentialsConfigurationElements((ClientCredentialsHandler)oAuthConfiguredHTTPEndpoint.getOauthHandler()));
        }
        return authentication;
    }

    private OMElement serializeClientCredentialsConfigurationElements(ClientCredentialsHandler clientCredentialsHandler) {
        OMElement clientCredentials = this.fac.createOMElement("clientCredentials", SynapseConstants.SYNAPSE_OMNAMESPACE);
        clientCredentials.addChild((OMNode)this.createOMElementWithValue("clientId", clientCredentialsHandler.getClientId()));
        clientCredentials.addChild((OMNode)this.createOMElementWithValue("clientSecret", clientCredentialsHandler.getClientSecret()));
        clientCredentials.addChild((OMNode)this.createOMElementWithValue("tokenUrl", clientCredentialsHandler.getTokenUrl()));
        return clientCredentials;
    }

    private OMElement serializeAuthorizationCodeConfigurationElements(AuthorizationCodeHandler authorizationCodeHandler) {
        OMElement clientCredentials = this.fac.createOMElement("authorizationCode", SynapseConstants.SYNAPSE_OMNAMESPACE);
        clientCredentials.addChild((OMNode)this.createOMElementWithValue("clientId", authorizationCodeHandler.getClientId()));
        clientCredentials.addChild((OMNode)this.createOMElementWithValue("clientSecret", authorizationCodeHandler.getClientSecret()));
        clientCredentials.addChild((OMNode)this.createOMElementWithValue("refreshToken", authorizationCodeHandler.getRefreshToken()));
        clientCredentials.addChild((OMNode)this.createOMElementWithValue("tokenUrl", authorizationCodeHandler.getTokenUrl()));
        return clientCredentials;
    }

    private OMElement createOMElementWithValue(String elementName, String elementValue) {
        OMElement element = this.fac.createOMElement(elementName, SynapseConstants.SYNAPSE_OMNAMESPACE);
        element.setText(elementValue);
        return element;
    }
}

