/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import com.damnhandy.uri.template.UriTemplate;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.commons.resolvers.ResolverFactory;
import org.apache.synapse.config.xml.endpoints.DefaultEndpointFactory;
import org.apache.synapse.config.xml.endpoints.DefinitionFactory;
import org.apache.synapse.config.xml.endpoints.EndpointDefinitionFactory;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.endpoints.HTTPEndpoint;
import org.apache.synapse.endpoints.OAuthConfiguredHTTPEndpoint;
import org.apache.synapse.endpoints.oauth.OAuthException;
import org.apache.synapse.endpoints.oauth.OAuthHandler;
import org.apache.synapse.endpoints.oauth.OAuthUtils;
import org.apache.synapse.util.CommentListUtil;

public class HTTPEndpointFactory
extends DefaultEndpointFactory {
    private static HTTPEndpointFactory instance = new HTTPEndpointFactory();

    public static HTTPEndpointFactory getInstance() {
        return instance;
    }

    @Override
    public EndpointDefinition createEndpointDefinition(OMElement elem) {
        EndpointDefinition endpointDefinition;
        DefinitionFactory fac = this.getEndpointDefinitionFactory();
        if (fac == null) {
            fac = new EndpointDefinitionFactory();
            endpointDefinition = fac.createDefinition(elem);
        } else {
            endpointDefinition = fac.createDefinition(elem);
        }
        this.extractSpecificEndpointProperties(endpointDefinition, elem);
        return endpointDefinition;
    }

    @Override
    protected Endpoint createEndpoint(OMElement epConfig, boolean anonymousEndpoint, Properties properties) {
        OMElement httpElement;
        OAuthHandler oAuthhandler;
        OMAttribute nameAttr = epConfig.getAttribute(new QName("", "name"));
        String name = null;
        if (nameAttr != null) {
            name = nameAttr.getAttributeValue();
        }
        HTTPEndpoint httpEndpoint = (oAuthhandler = this.createOAuthHandler(httpElement = epConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "http")), name)) != null ? new OAuthConfiguredHTTPEndpoint(oAuthhandler) : new HTTPEndpoint();
        if (name != null) {
            httpEndpoint.setName(name);
        }
        if (httpElement != null) {
            EndpointDefinition definition = this.createEndpointDefinition(httpElement);
            OMAttribute uriTemplateAttr = httpElement.getAttribute(new QName("uri-template"));
            if (uriTemplateAttr != null) {
                String uriValue = uriTemplateAttr.getAttributeValue();
                uriValue = ResolverFactory.getInstance().getResolver(uriValue).resolve();
                if (uriValue.startsWith(HTTPEndpoint.legacyPrefix)) {
                    httpEndpoint.setUriTemplate(UriTemplate.fromTemplate((String)uriValue.substring(HTTPEndpoint.legacyPrefix.length())));
                    definition.setAddress(uriValue.substring(HTTPEndpoint.legacyPrefix.length()));
                    httpEndpoint.setLegacySupport(true);
                } else {
                    httpEndpoint.setUriTemplate(UriTemplate.fromTemplate((String)uriValue));
                    definition.setAddress(uriValue);
                    httpEndpoint.setLegacySupport(false);
                }
            }
            httpEndpoint.setDefinition(definition);
            this.processAuditStatus(definition, httpEndpoint.getName(), httpElement);
            OMAttribute methodAttr = httpElement.getAttribute(new QName("method"));
            if (methodAttr != null) {
                this.setHttpMethod(httpEndpoint, methodAttr.getAttributeValue());
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Method is not specified for HttpEndpoint. Hence using the http method from incoming message");
            }
        }
        this.processProperties(httpEndpoint, epConfig);
        CommentListUtil.populateComments(epConfig, httpEndpoint.getCommentsList());
        return httpEndpoint;
    }

    private void setHttpMethod(HTTPEndpoint httpEndpoint, String httpMethod) {
        if (httpMethod != null) {
            if (httpMethod.equalsIgnoreCase("POST")) {
                httpEndpoint.setHttpMethod("POST");
            } else if (httpMethod.equalsIgnoreCase("GET")) {
                httpEndpoint.setHttpMethod("GET");
            } else if (httpMethod.equalsIgnoreCase("PUT")) {
                httpEndpoint.setHttpMethod("PUT");
            } else if (httpMethod.equalsIgnoreCase("DELETE")) {
                httpEndpoint.setHttpMethod("DELETE");
            } else if (httpMethod.equalsIgnoreCase("HEAD")) {
                httpEndpoint.setHttpMethod("HEAD");
            } else if (httpMethod.equalsIgnoreCase("PATCH")) {
                httpEndpoint.setHttpMethod("PATCH");
            } else if (httpMethod.equalsIgnoreCase("OPTIONS")) {
                httpEndpoint.setHttpMethod("OPTIONS");
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Invalid http method specified.Hence using the http method from incoming message");
            }
        }
    }

    private OAuthHandler createOAuthHandler(OMElement httpElement, String endpointName) {
        OAuthHandler handler = null;
        try {
            handler = OAuthUtils.getOAuthHandler(httpElement);
        }
        catch (OAuthException e) {
            if (endpointName == null) {
                endpointName = "";
            }
            HTTPEndpointFactory.handleException("Invalid OAuth configuration for endpoint " + endpointName);
        }
        return handler;
    }
}

