/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import java.util.ArrayList;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.util.JavaUtils;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.FailoverEndpoint;

public class FailoverEndpointFactory
extends EndpointFactory {
    private static FailoverEndpointFactory instance = new FailoverEndpointFactory();

    private FailoverEndpointFactory() {
    }

    public static FailoverEndpointFactory getInstance() {
        return instance;
    }

    @Override
    protected Endpoint createEndpoint(OMElement epConfig, boolean anonymousEndpoint, Properties properties) {
        OMElement failoverElement = epConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "failover"));
        if (failoverElement != null) {
            String buildMessageAtt;
            ArrayList<Endpoint> childEndpoints;
            FailoverEndpoint failoverEndpoint = new FailoverEndpoint();
            String name = epConfig.getAttributeValue(new QName("name"));
            if (name != null && !name.isEmpty()) {
                failoverEndpoint.setName(name);
            }
            if ((childEndpoints = this.getEndpoints(failoverElement, failoverEndpoint, properties)) == null || childEndpoints.size() == 0) {
                String msg = "Invalid Synapse configuration.\nA FailOver must have child elements, but the FailOver '" + failoverEndpoint.getName() + "' does not have any child elements.";
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            failoverEndpoint.setChildren(this.getEndpoints(failoverElement, failoverEndpoint, properties));
            String dynamicFO = failoverElement.getAttributeValue(new QName("dynamic"));
            if (dynamicFO != null && JavaUtils.isFalseExplicitly((String)dynamicFO)) {
                failoverEndpoint.setDynamic(false);
            }
            if ((buildMessageAtt = failoverElement.getAttributeValue(new QName("buildMessage"))) != null) {
                failoverEndpoint.setBuildMessageAttAvailable(true);
                if (JavaUtils.isTrueExplicitly((String)buildMessageAtt)) {
                    failoverEndpoint.setBuildMessageAtt(true);
                }
            }
            this.processProperties(failoverEndpoint, epConfig);
            return failoverEndpoint;
        }
        return null;
    }
}

