/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.endpoints.DefinitionFactory;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class EndpointDefinitionFactory
implements DefinitionFactory {
    public static final Log log = LogFactory.getLog(EndpointDefinitionFactory.class);

    @Override
    public EndpointDefinition createDefinition(OMElement elem) {
        OMElement retryConfig;
        OMElement suspendOnFailure;
        OMElement suspendDurationOnFailure;
        OMElement markAsTimedOut;
        OMElement timeout;
        OMElement wsSec;
        OMElement wsAddr;
        EndpointDefinition definition = new EndpointDefinition();
        OMAttribute optimize = elem.getAttribute(new QName("", "optimize"));
        OMAttribute encoding = elem.getAttribute(new QName("", "encoding"));
        if (optimize != null && optimize.getAttributeValue().length() > 0) {
            String method = optimize.getAttributeValue().trim();
            if ("mtom".equalsIgnoreCase(method)) {
                definition.setUseMTOM(true);
            } else if ("swa".equalsIgnoreCase(method)) {
                definition.setUseSwa(true);
            }
        }
        if (encoding != null && encoding.getAttributeValue() != null) {
            definition.setCharSetEncoding(encoding.getAttributeValue());
        }
        if ((wsAddr = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "enableAddressing"))) != null) {
            String useSepList;
            definition.setAddressingOn(true);
            OMAttribute version = wsAddr.getAttribute(new QName("version"));
            if (version != null && version.getAttributeValue() != null) {
                String versionValue = version.getAttributeValue().trim().toLowerCase();
                if ("final".equals(versionValue) || "submission".equals(versionValue)) {
                    definition.setAddressingVersion(version.getAttributeValue());
                } else {
                    EndpointDefinitionFactory.handleException("Unknown value for the addressing version. Possible values for the addressing version are 'final' and 'submission' only.");
                }
            }
            if ((useSepList = wsAddr.getAttributeValue(new QName("separateListener"))) != null && "true".equals(useSepList.trim().toLowerCase())) {
                definition.setUseSeparateListener(true);
            }
        }
        if ((wsSec = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "enableSec"))) != null) {
            definition.setSecurityOn(true);
            OMAttribute policyKey = wsSec.getAttribute(new QName("", "policy"));
            OMAttribute inboundPolicyKey = wsSec.getAttribute(new QName("", "inboundPolicy"));
            OMAttribute outboundPolicyKey = wsSec.getAttribute(new QName("", "outboundPolicy"));
            if (policyKey != null && policyKey.getAttributeValue() != null) {
                String p = policyKey.getAttributeValue();
                Pattern pattern = Pattern.compile("\\{.*\\}");
                if (pattern.matcher(p).matches()) {
                    try {
                        p = p.trim().substring(1, p.length() - 1);
                        SynapseXPath xpath = null;
                        xpath = new SynapseXPath(p);
                        definition.setDynamicPolicy(xpath);
                        definition.setWsSecPolicyKey(p);
                    }
                    catch (JaxenException e) {
                        EndpointDefinitionFactory.handleException("Couldn't assign dynamic endpoint policy as Synapse expression");
                    }
                } else {
                    String wsSecPolicy = p.trim();
                    definition.setWsSecPolicyKey(wsSecPolicy);
                }
            } else {
                if (inboundPolicyKey != null && inboundPolicyKey.getAttributeValue() != null) {
                    definition.setInboundWsSecPolicyKey(inboundPolicyKey.getAttributeValue());
                }
                if (outboundPolicyKey != null && outboundPolicyKey.getAttributeValue() != null) {
                    definition.setOutboundWsSecPolicyKey(outboundPolicyKey.getAttributeValue());
                }
            }
        }
        if ((timeout = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "timeout"))) != null) {
            OMElement action;
            String d;
            OMElement duration = timeout.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "duration"));
            if (duration != null && (d = duration.getText()) != null) {
                try {
                    Pattern pattern = Pattern.compile("\\{.*\\}");
                    if (pattern.matcher(d).matches()) {
                        d = d.trim().substring(1, d.length() - 1);
                        SynapseXPath xpath = new SynapseXPath(d);
                        definition.setDynamicTimeoutExpression(xpath);
                    } else {
                        long timeoutMilliSeconds = Long.parseLong(d.trim());
                        definition.setTimeoutDuration(timeoutMilliSeconds);
                    }
                }
                catch (NumberFormatException e) {
                    EndpointDefinitionFactory.handleException("Endpoint timeout duration expected as a number but was not a number");
                }
                catch (JaxenException e) {
                    EndpointDefinitionFactory.handleException("Couldn't assign dynamic endpoint timeout as Synapse expression");
                }
            }
            if ((action = timeout.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "responseAction"))) != null && action.getText() != null) {
                String actionString = action.getText();
                if ("discard".equalsIgnoreCase(actionString.trim())) {
                    definition.setTimeoutAction(101);
                } else if ("fault".equalsIgnoreCase(actionString.trim())) {
                    definition.setTimeoutAction(102);
                } else {
                    EndpointDefinitionFactory.handleException("Invalid timeout action, action : " + actionString + " is not supported");
                }
            }
        }
        if ((markAsTimedOut = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "markForSuspension"))) != null) {
            OMElement retryDelay;
            OMElement retriesBeforeSuspend;
            OMElement timeoutCodes = markAsTimedOut.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "errorCodes"));
            if (timeoutCodes != null && timeoutCodes.getText() != null) {
                StringTokenizer st = new StringTokenizer(timeoutCodes.getText().trim(), ", ");
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    try {
                        definition.addTimeoutErrorCode(Integer.parseInt(s));
                    }
                    catch (NumberFormatException e) {
                        EndpointDefinitionFactory.handleException("The timeout error codes should be specified as valid numbers separated by commas : " + timeoutCodes.getText(), e);
                    }
                }
            }
            if ((retriesBeforeSuspend = markAsTimedOut.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "retriesBeforeSuspension"))) != null && retriesBeforeSuspend.getText() != null) {
                try {
                    definition.setRetriesOnTimeoutBeforeSuspend(Integer.parseInt(retriesBeforeSuspend.getText().trim()));
                }
                catch (NumberFormatException e) {
                    EndpointDefinitionFactory.handleException("The retries before suspend [for timeouts] should be specified as a valid number : " + retriesBeforeSuspend.getText(), e);
                }
            }
            if ((retryDelay = markAsTimedOut.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "retryDelay"))) != null && retryDelay.getText() != null) {
                try {
                    definition.setRetryDurationOnTimeout(Integer.parseInt(retryDelay.getText().trim()));
                }
                catch (NumberFormatException e) {
                    EndpointDefinitionFactory.handleException("The retry delay for timeouts should be specified as a valid number : " + retryDelay.getText(), e);
                }
            }
        }
        if ((suspendDurationOnFailure = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "suspendDurationOnFailure"))) != null && suspendDurationOnFailure.getText() != null) {
            log.warn((Object)"Configuration uses deprecated style for endpoint 'suspendDurationOnFailure'");
            try {
                definition.setInitialSuspendDuration(1000L * Long.parseLong(suspendDurationOnFailure.getText().trim()));
                definition.setSuspendProgressionFactor(1.0f);
            }
            catch (NumberFormatException e) {
                EndpointDefinitionFactory.handleException("The initial suspend duration should be specified as a valid number : " + suspendDurationOnFailure.getText(), e);
            }
        }
        if ((suspendOnFailure = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "suspendOnFailure"))) != null) {
            OMElement maximumDuration;
            OMElement progressionFactor;
            OMElement initialDuration;
            OMElement suspendCodes = suspendOnFailure.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "errorCodes"));
            if (suspendCodes != null && suspendCodes.getText() != null) {
                StringTokenizer st = new StringTokenizer(suspendCodes.getText().trim(), ", ");
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    try {
                        definition.addSuspendErrorCode(Integer.parseInt(s));
                    }
                    catch (NumberFormatException e) {
                        EndpointDefinitionFactory.handleException("The suspend error codes should be specified as valid numbers separated by commas : " + suspendCodes.getText(), e);
                    }
                }
            }
            if ((initialDuration = suspendOnFailure.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "initialDuration"))) != null && initialDuration.getText() != null) {
                try {
                    definition.setInitialSuspendDuration(Integer.parseInt(initialDuration.getText().trim()));
                }
                catch (NumberFormatException e) {
                    EndpointDefinitionFactory.handleException("The initial suspend duration should be specified as a valid number : " + initialDuration.getText(), e);
                }
            }
            if ((progressionFactor = suspendOnFailure.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "progressionFactor"))) != null && progressionFactor.getText() != null) {
                try {
                    definition.setSuspendProgressionFactor(Float.parseFloat(progressionFactor.getText().trim()));
                }
                catch (NumberFormatException e) {
                    EndpointDefinitionFactory.handleException("The suspend duration progression factor should be specified as a valid float : " + progressionFactor.getText(), e);
                }
            }
            if ((maximumDuration = suspendOnFailure.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "maximumDuration"))) != null && maximumDuration.getText() != null) {
                try {
                    definition.setSuspendMaximumDuration(Long.parseLong(maximumDuration.getText().trim()));
                }
                catch (NumberFormatException e) {
                    EndpointDefinitionFactory.handleException("The maximum suspend duration should be specified as a valid number : " + maximumDuration.getText(), e);
                }
            }
        }
        if ((retryConfig = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "retryConfig"))) != null) {
            OMElement retryEnabledErrorCodes;
            OMElement retryDisabledErrorCodes = retryConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "disabledErrorCodes"));
            if (retryDisabledErrorCodes != null && retryDisabledErrorCodes.getText() != null) {
                StringTokenizer st = new StringTokenizer(retryDisabledErrorCodes.getText().trim(), ", ");
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    try {
                        definition.addRetryDisabledErrorCode(Integer.parseInt(s));
                    }
                    catch (NumberFormatException e) {
                        EndpointDefinitionFactory.handleException("The suspend error codes should be specified as valid numbers separated by commas : " + retryDisabledErrorCodes.getText(), e);
                    }
                }
            }
            if ((retryEnabledErrorCodes = retryConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "enabledErrorCodes"))) != null && retryEnabledErrorCodes.getText() != null) {
                StringTokenizer st = new StringTokenizer(retryEnabledErrorCodes.getText().trim(), ", ");
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    try {
                        definition.addRetryEnabledErrorCode(Integer.parseInt(s));
                    }
                    catch (NumberFormatException e) {
                        EndpointDefinitionFactory.handleException("The suspend error codes should be specified as valid numbers separated by commas : " + retryEnabledErrorCodes.getText(), e);
                    }
                }
            }
        }
        return definition;
    }

    protected static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    protected static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }
}

