/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.MediatorPropertyFactory;
import org.apache.synapse.config.xml.ResourceMapFactory;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.transform.XSLTMediator;
import org.jaxen.JaxenException;

public class XSLTMediatorFactory
extends AbstractMediatorFactory {
    private static final QName TAG_NAME = new QName("http://ws.apache.org/ns/synapse", "xslt");
    private static final QName ATTRIBUTE_Q = new QName("http://ws.apache.org/ns/synapse", "attribute");
    private static final QName ATT_USECACHE = new QName("useCache");

    @Override
    public QName getTagQName() {
        return TAG_NAME;
    }

    @Override
    public Mediator createSpecificMediator(OMElement elem, Properties properties) {
        XSLTMediator transformMediator = new XSLTMediator();
        OMAttribute attXslt = elem.getAttribute(ATT_KEY);
        OMAttribute attSource = elem.getAttribute(ATT_SOURCE);
        OMAttribute attTarget = elem.getAttribute(ATT_TARGET);
        OMAttribute attUseCache = elem.getAttribute(ATT_USECACHE);
        if (attXslt != null) {
            ValueFactory keyFac = new ValueFactory();
            Value generatedKey = keyFac.createValue("key", elem);
            transformMediator.setXsltKey(generatedKey);
        } else {
            this.handleException("The 'key' attribute is required for the XSLT mediator");
        }
        if (attSource != null) {
            try {
                transformMediator.setSourceXPathString(attSource.getAttributeValue());
                transformMediator.setSource(SynapseXPathFactory.getSynapseXPath(elem, ATT_SOURCE));
            }
            catch (JaxenException e) {
                this.handleException("Invalid XPath specified for the source attribute : " + attSource.getAttributeValue());
            }
        }
        if (attTarget != null) {
            transformMediator.setTargetPropertyName(attTarget.getAttributeValue());
        }
        if (attUseCache != null) {
            transformMediator.setUseCache(Boolean.parseBoolean(attUseCache.getAttributeValue()));
        }
        this.processAuditStatus(transformMediator, elem);
        for (Map.Entry<String, String> entry : this.collectNameValuePairs(elem, FEATURE_Q).entrySet()) {
            boolean isFeatureEnabled;
            String value = entry.getValue();
            if ("true".equals(value)) {
                isFeatureEnabled = true;
            } else if ("false".equals(value)) {
                isFeatureEnabled = false;
            } else {
                this.handleException("The feature must have value true or false");
                break;
            }
            transformMediator.addFeature(entry.getKey(), isFeatureEnabled);
        }
        for (Map.Entry<String, String> entry : this.collectNameValuePairs(elem, ATTRIBUTE_Q).entrySet()) {
            transformMediator.addAttribute(entry.getKey(), entry.getValue());
        }
        transformMediator.addAllProperties(MediatorPropertyFactory.getMediatorProperties(elem));
        transformMediator.setResourceMap(ResourceMapFactory.createResourceMap(elem));
        XSLTMediatorFactory.addAllCommentChildrenToList(elem, transformMediator.getCommentsList());
        return transformMediator;
    }
}

