/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.XMLToObjectMapper;
import org.apache.synapse.config.xml.MediatorFactoryFinder;
import org.apache.synapse.config.xml.endpoints.TemplateFactory;

public class XMLToTemplateMapper
implements XMLToObjectMapper {
    SynapseConfiguration configuration = null;

    public XMLToTemplateMapper() {
        this(null);
    }

    public XMLToTemplateMapper(SynapseConfiguration config) {
        if (config != null) {
            this.setSynapseConfiguration(config);
        }
    }

    @Override
    public Object getObjectFromOMNode(OMNode om, Properties properties) {
        if (!(om instanceof OMElement)) {
            throw new SynapseException("Configuration is not in proper format.");
        }
        OMElement elem = (OMElement)om;
        OMElement element = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "sequence"));
        if (element != null) {
            return MediatorFactoryFinder.getInstance().getMediator(elem, properties, this.getSynapseConfiguration());
        }
        element = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "endpoint"));
        if (element != null) {
            TemplateFactory templateFactory = new TemplateFactory();
            return templateFactory.createEndpointTemplate(elem, properties);
        }
        return null;
    }

    public SynapseConfiguration getSynapseConfiguration() {
        return this.configuration;
    }

    public void setSynapseConfiguration(SynapseConfiguration configuration) {
        this.configuration = configuration;
    }
}

