/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.synapse.config.xml.SynapsePathSerializer;
import org.apache.synapse.mediators.Value;

public class ValueSerializer {
    protected static final OMFactory fac = OMAbstractFactory.getOMFactory();
    protected static final OMNamespace nullNS = fac.createOMNamespace("", "");

    public OMElement serializeValue(Value key, String name, OMElement elem) {
        if (key != null) {
            if (key.getExpression() == null) {
                elem.addAttribute(fac.createOMAttribute(name, nullNS, key.getKeyValue()));
            } else {
                String startChar = "{";
                String endChar = "}";
                if (key.hasExprTypeKey()) {
                    startChar = startChar + "{";
                    endChar = endChar + "}";
                }
                SynapsePathSerializer.serializePath(key.getExpression(), startChar + key.getExpression().toString() + endChar, elem, name);
            }
        }
        return elem;
    }

    public OMElement serializeTextValue(Value key, String name, OMElement elem) {
        if (key != null) {
            if (key.getExpression() == null) {
                elem.setText(key.getKeyValue());
            } else {
                String startChar = "{";
                String endChar = "}";
                if (key.hasExprTypeKey()) {
                    startChar = startChar + "{";
                    endChar = endChar + "}";
                }
                SynapsePathSerializer.serializeTextPath(key.getExpression(), startChar + key.getExpression().toString() + endChar, elem, name);
            }
        }
        return elem;
    }
}

