/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.SynapseJsonPathFactory;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.util.xpath.SynapseJsonPath;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class ValueFactory {
    private static final Log log = LogFactory.getLog(ValueFactory.class);
    private static final QName ATT_KEY = new QName("key");

    public Value createValue(String name, OMElement elem) {
        Value key = null;
        OMAttribute attKey = elem.getAttribute(new QName(name));
        if (attKey != null) {
            String attributeValue = attKey.getAttributeValue();
            boolean hasEscape = this.isEscapedExpression(attributeValue);
            if (!hasEscape && this.isDynamicKey(attributeValue)) {
                if (attributeValue.startsWith("{json-eval(")) {
                    attributeValue = attributeValue.substring(1, attributeValue.length() - 1);
                    SynapseJsonPath synJsonPath = this.createSynJsonPath(attributeValue);
                    key = new Value(synJsonPath);
                } else {
                    SynapseXPath synXpath = this.createSynXpath(elem, attributeValue);
                    key = new Value(synXpath);
                }
            } else if (hasEscape) {
                key = new Value(this.getEscapedExpression(attributeValue));
                key.setNamespaces(elem);
            } else {
                key = new Value(attributeValue);
            }
        } else {
            this.handleException("The '" + name + "' attribute is required for the element '" + elem.getLocalName() + "'");
        }
        return key;
    }

    public Value createTextValue(OMElement elem) {
        Value key = null;
        String textValue = elem.getText();
        if (textValue != null) {
            boolean hasEscape = this.isEscapedExpression(textValue);
            if (!hasEscape && this.isDynamicKey(textValue)) {
                if (textValue.startsWith("{json-eval(")) {
                    textValue = textValue.substring(1, textValue.length() - 1);
                    SynapseJsonPath synJsonPath = this.createSynJsonPath(textValue);
                    key = new Value(synJsonPath);
                } else {
                    SynapseXPath synXpath = this.createSynXpath(elem, textValue);
                    key = new Value(synXpath);
                }
            } else if (hasEscape) {
                key = new Value(this.getEscapedExpression(textValue));
                key.setNamespaces(elem);
            } else {
                key = new Value(textValue);
            }
        } else {
            this.handleException("Text value is required for the element '" + elem.getLocalName() + "'");
        }
        return key;
    }

    public boolean isDynamicKey(String keyValue) {
        boolean dynamicKey = false;
        if (StringUtils.isNotEmpty((String)keyValue)) {
            int startExpression = 123;
            int endExpression = 125;
            char firstChar = keyValue.charAt(0);
            char lastChar = keyValue.charAt(keyValue.length() - 1);
            if ('{' == firstChar && '}' == lastChar) {
                dynamicKey = true;
            }
        }
        return dynamicKey;
    }

    private boolean isEscapedExpression(String escapeExpr) {
        int startEscapeChar = 123;
        int endEscapeChar = 125;
        String expr = escapeExpr.trim();
        if (expr.length() <= 3) {
            return false;
        }
        char firstChar = expr.charAt(0);
        char nextTofirstChar = expr.charAt(1);
        char lastChar = expr.charAt(expr.length() - 1);
        char prevTolastChar = expr.charAt(expr.length() - 2);
        if ('{' == firstChar && '}' == lastChar) {
            return firstChar == nextTofirstChar && lastChar == prevTolastChar;
        }
        return false;
    }

    private String getEscapedExpression(String originalExpr) {
        return originalExpr.trim().substring(1, originalExpr.length() - 1);
    }

    public SynapseXPath createSynXpath(OMElement elem, String key) {
        String xpathExpr = key.trim().substring(1, key.length() - 1);
        SynapseXPath synapseXPath = null;
        try {
            synapseXPath = SynapseXPathFactory.getSynapseXPath(elem, xpathExpr);
        }
        catch (JaxenException e) {
            this.handleException("Can not create Synapse Xpath from given key");
        }
        return synapseXPath;
    }

    public SynapseJsonPath createSynJsonPath(String key) {
        String jsonPathExpr = key.trim().substring(10, key.length() - 1);
        SynapseJsonPath synapseJsonPath = null;
        try {
            synapseJsonPath = SynapseJsonPathFactory.getSynapseJsonPath(jsonPathExpr);
        }
        catch (JaxenException e) {
            this.handleException("Can not create SynapseJsonPath from given: " + key);
        }
        return synapseJsonPath;
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

