/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.commons.evaluators.Evaluator;
import org.apache.synapse.commons.evaluators.EvaluatorException;
import org.apache.synapse.commons.evaluators.config.EvaluatorFactoryFinder;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.mediators.transform.url.RewriteAction;
import org.apache.synapse.mediators.transform.url.RewriteRule;
import org.apache.synapse.mediators.transform.url.URLRewriteMediator;
import org.jaxen.JaxenException;

public class URLRewriteMediatorFactory
extends AbstractMediatorFactory {
    private static final QName REWRITE_Q = new QName("http://ws.apache.org/ns/synapse", "rewrite");
    private static final QName RULE_Q = new QName("http://ws.apache.org/ns/synapse", "rewriterule");
    private static final QName CONDITION_Q = new QName("http://ws.apache.org/ns/synapse", "condition");
    private static final QName ACTION_Q = new QName("http://ws.apache.org/ns/synapse", "action");
    private static final QName ATT_IN_PROPERTY = new QName("inProperty");
    private static final QName ATT_OUT_PROPERTY = new QName("outProperty");
    private static final QName ATT_TYPE = new QName("type");
    private static final QName ATT_FRAGMENT = new QName("fragment");
    public static final String ACTION_SET = "set";
    public static final String ACTION_APPEND = "append";
    public static final String ACTION_PREPEND = "prepend";
    public static final String ACTION_REPLACE = "replace";
    public static final String ACTION_REMOVE = "remove";
    public static final String FRAGMENT_PROTOCOL = "protocol";
    public static final String FRAGMENT_USER_INFO = "user";
    public static final String FRAGMENT_HOST = "host";
    public static final String FRAGMENT_PORT = "port";
    public static final String FRAGMENT_PATH = "path";
    public static final String FRAGMENT_QUERY = "query";
    public static final String FRAGMENT_REF = "ref";
    public static final String FRAGMENT_FULL_URI = "full";

    @Override
    protected Mediator createSpecificMediator(OMElement element, Properties properties) {
        Iterator rules = element.getChildrenWithName(RULE_Q);
        String inputProperty = element.getAttributeValue(ATT_IN_PROPERTY);
        String outputProperty = element.getAttributeValue(ATT_OUT_PROPERTY);
        URLRewriteMediator mediator = new URLRewriteMediator();
        if (inputProperty != null) {
            mediator.setInputProperty(inputProperty);
        }
        if (outputProperty != null) {
            mediator.setOutputProperty(outputProperty);
        }
        while (rules.hasNext()) {
            mediator.addRule(this.parseRule((OMElement)rules.next()));
        }
        this.processAuditStatus(mediator, element);
        URLRewriteMediatorFactory.addAllCommentChildrenToList(element, mediator.getCommentsList());
        return mediator;
    }

    private RewriteRule parseRule(OMElement ruleElement) {
        OMElement child;
        Iterator actions = ruleElement.getChildrenWithName(ACTION_Q);
        if (actions == null) {
            this.handleException("At least one rewrite action is required per rule");
            return null;
        }
        RewriteRule rule = new RewriteRule();
        while (actions.hasNext()) {
            rule.addRewriteAction(this.parseAction((OMElement)actions.next()));
        }
        OMElement condition = ruleElement.getFirstChildWithName(CONDITION_Q);
        if (condition != null && (child = condition.getFirstElement()) != null) {
            try {
                Evaluator eval = EvaluatorFactoryFinder.getInstance().getEvaluator(child);
                rule.setCondition(eval);
            }
            catch (EvaluatorException e) {
                this.handleException("Error while parsing the rule condition", (Exception)((Object)e));
            }
        }
        return rule;
    }

    private RewriteAction parseAction(OMElement actionElement) {
        String fragment;
        String value = actionElement.getAttributeValue(ATT_VALUE);
        String xpath = actionElement.getAttributeValue(ATT_XPATH);
        String type = actionElement.getAttributeValue(ATT_TYPE);
        QName xpath_Q = new QName("", "xpath");
        if (value == null && xpath == null && !ACTION_REMOVE.equals(type)) {
            this.handleException("value or xpath attribute is required on the action element");
        }
        RewriteAction action = new RewriteAction();
        if (xpath != null) {
            try {
                action.setXpath(SynapseXPathFactory.getSynapseXPath(actionElement, xpath_Q));
            }
            catch (JaxenException e) {
                this.handleException("Error while parsing the XPath expression: " + xpath, (Exception)((Object)e));
            }
        } else if (value != null) {
            action.setValue(value);
        }
        if ((fragment = actionElement.getAttributeValue(ATT_FRAGMENT)) != null) {
            if (FRAGMENT_PROTOCOL.equals(fragment)) {
                action.setFragmentIndex(0);
            } else if (FRAGMENT_USER_INFO.equals(fragment)) {
                action.setFragmentIndex(1);
            } else if (FRAGMENT_HOST.equals(fragment)) {
                action.setFragmentIndex(2);
            } else if (FRAGMENT_PORT.equals(fragment)) {
                action.setFragmentIndex(-1);
            } else if (FRAGMENT_PATH.equals(fragment)) {
                action.setFragmentIndex(3);
            } else if (FRAGMENT_QUERY.equals(fragment)) {
                action.setFragmentIndex(4);
            } else if (FRAGMENT_REF.equals(fragment)) {
                action.setFragmentIndex(5);
            } else if (FRAGMENT_FULL_URI.equals(fragment)) {
                action.setFragmentIndex(-2);
            } else {
                this.handleException("Unknown URL fragment name: " + fragment);
            }
        }
        if (type != null) {
            if (ACTION_SET.equals(type)) {
                action.setActionType(0);
            } else if (ACTION_APPEND.equals(type)) {
                action.setActionType(1);
            } else if (ACTION_PREPEND.equals(type)) {
                action.setActionType(2);
            } else if (ACTION_REPLACE.equals(type)) {
                action.setActionType(3);
                String regex = actionElement.getAttributeValue(ATT_REGEX);
                if (regex != null) {
                    action.setRegex(regex);
                } else {
                    this.handleException("regex attribute is required for replace action");
                }
            } else if (ACTION_REMOVE.equals(type)) {
                action.setActionType(4);
            } else {
                this.handleException("Unknown URL rewrite action type: " + type);
            }
        }
        return action;
    }

    @Override
    public QName getTagQName() {
        return REWRITE_Q;
    }
}

