/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.task.TaskManager;

public class TaskManagerSerializer {
    private static final Log log = LogFactory.getLog(TaskManagerSerializer.class);
    protected static final OMFactory fac = OMAbstractFactory.getOMFactory();
    protected static final OMNamespace synNS = SynapseConstants.SYNAPSE_OMNAMESPACE;
    protected static final OMNamespace nullNS = fac.createOMNamespace("", "");

    public static OMElement serializetaskManager(OMElement parent, TaskManager taskManager) {
        OMElement executor = fac.createOMElement("taskManager", synNS);
        if (taskManager.getProviderClass() != null) {
            executor.addAttribute(fac.createOMAttribute("provider", nullNS, taskManager.getProviderClass()));
        } else {
            TaskManagerSerializer.handleException("Invalid taskManager. Provider is required");
        }
        for (String string : taskManager.getConfigurationProperties().keySet()) {
            String value = (String)taskManager.getConfigurationProperties().get(string);
            OMElement property = fac.createOMElement("parameter", synNS);
            property.addAttribute(fac.createOMAttribute("name", nullNS, string));
            property.setText(value.trim());
            executor.addChild((OMNode)property);
        }
        if (parent != null) {
            parent.addChild((OMNode)executor);
        }
        return executor;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

