/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.task.TaskManager;

public class TaskManagerFactory {
    private static final Log log = LogFactory.getLog(TaskManagerFactory.class);
    public static final QName PROVIDER_Q = new QName("", "provider");
    public static final QName PARAMETER_Q = new QName("http://ws.apache.org/ns/synapse", "parameter");
    public static final QName NAME_Q = new QName("", "name");

    public static TaskManager createTaskManager(OMElement elem, Properties properties) {
        OMAttribute prov = elem.getAttribute(PROVIDER_Q);
        if (prov != null) {
            try {
                Class<?> provider = Class.forName(prov.getAttributeValue());
                TaskManager taskManager = (TaskManager)provider.newInstance();
                taskManager.init(TaskManagerFactory.getProperties(elem, properties));
                taskManager.setConfigurationProperties(TaskManagerFactory.getProperties(elem, properties));
                return taskManager;
            }
            catch (ClassNotFoundException e) {
                TaskManagerFactory.handleException("Cannot locate task provider class : " + prov.getAttributeValue(), e);
            }
            catch (IllegalAccessException e) {
                TaskManagerFactory.handleException("Error instantiating task provider : " + prov.getAttributeValue(), e);
            }
            catch (InstantiationException e) {
                TaskManagerFactory.handleException("Error instantiating task provider : " + prov.getAttributeValue(), e);
            }
        } else {
            TaskManagerFactory.handleException("The task 'provider' attribute is required for a taskManager definition");
        }
        return null;
    }

    private static Properties getProperties(OMElement elem, Properties topLevelProps) {
        Iterator params = elem.getChildrenWithName(PARAMETER_Q);
        Properties props = new Properties(topLevelProps);
        while (params.hasNext()) {
            Object o = params.next();
            if (o instanceof OMElement) {
                OMElement prop = (OMElement)o;
                OMAttribute pname = prop.getAttribute(NAME_Q);
                String propertyValue = prop.getText();
                if (pname != null) {
                    if (propertyValue == null) continue;
                    props.setProperty(pname.getAttributeValue(), propertyValue.trim());
                    continue;
                }
                TaskManagerFactory.handleException("Invalid taskManager property - property should have a name ");
                continue;
            }
            TaskManagerFactory.handleException("Invalid taskManager property");
        }
        return props;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }
}

