/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.util.xpath.SynapseXPath;

public class SynapseXPathSerializer {
    private static final Log log = LogFactory.getLog(SynapseXPathSerializer.class);

    public static OMElement serializeXPath(SynapseXPath xpath, OMElement elem, String attribName) {
        OMNamespace nullNS = elem.getOMFactory().createOMNamespace("", "");
        if (xpath != null) {
            elem.addAttribute(elem.getOMFactory().createOMAttribute(attribName, nullNS, xpath.toString()));
            SynapseXPathSerializer.serializeNamespaces(elem, xpath);
        } else {
            SynapseXPathSerializer.handleException("Couldn't find the xpath in the SynapseXPath");
        }
        return elem;
    }

    public static OMElement serializeXPath(SynapseXPath xpath, String expression, OMElement elem, String attribName) {
        OMNamespace nullNS = elem.getOMFactory().createOMNamespace("", "");
        if (xpath != null && expression != null) {
            elem.addAttribute(elem.getOMFactory().createOMAttribute(attribName, nullNS, expression));
            SynapseXPathSerializer.serializeNamespaces(elem, xpath);
        } else {
            SynapseXPathSerializer.handleException("Couldn't find the xpath in the SynapseXPath");
        }
        return elem;
    }

    public static OMElement serializeTextXPath(SynapseXPath xpath, String expression, OMElement elem, String attribName) {
        if (xpath != null && expression != null) {
            elem.setText(expression);
            SynapseXPathSerializer.serializeNamespaces(elem, xpath);
        } else {
            SynapseXPathSerializer.handleException("Couldn't find the xpath in the SynapseXPath");
        }
        return elem;
    }

    private static void serializeNamespaces(OMElement elem, SynapseXPath xpath) {
        for (Object o : xpath.getNamespaces().keySet()) {
            String prefix = (String)o;
            String uri = xpath.getNamespaceContext().translateNamespacePrefixToUri(prefix);
            if ("http://ws.apache.org/ns/synapse".equals(uri)) continue;
            elem.declareNamespace(uri, prefix);
        }
    }

    private static void handleException(String message) {
        log.error((Object)message);
        throw new SynapseException(message);
    }
}

