/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.SynapsePath;

public class SynapsePathSerializer {
    private static final Log log = LogFactory.getLog(SynapsePathSerializer.class);

    public static OMElement serializePath(SynapsePath path, OMElement elem, String attribName) {
        OMNamespace nullNS = elem.getOMFactory().createOMNamespace("", "");
        if (path != null) {
            elem.addAttribute(elem.getOMFactory().createOMAttribute(attribName, nullNS, path.toString()));
            SynapsePathSerializer.serializeNamespaces(elem, path);
        } else {
            SynapsePathSerializer.handleException("Couldn't find the xpath in the SynapseXPath");
        }
        return elem;
    }

    public static OMElement serializePath(SynapsePath path, String expression, OMElement elem, String attribName) {
        OMNamespace nullNS = elem.getOMFactory().createOMNamespace("", "");
        if (path != null && expression != null) {
            if (path.getPathType() == "JSON_PATH") {
                if (expression.contains("json-eval(")) {
                    elem.addAttribute(elem.getOMFactory().createOMAttribute(attribName, nullNS, expression));
                } else {
                    elem.addAttribute(elem.getOMFactory().createOMAttribute(attribName, nullNS, "json-eval(" + expression + ")"));
                }
            } else if (path.getPathType() == "X_PATH") {
                elem.addAttribute(elem.getOMFactory().createOMAttribute(attribName, nullNS, expression));
            }
            SynapsePathSerializer.serializeNamespaces(elem, path);
        } else {
            SynapsePathSerializer.handleException("Couldn't find the xpath in the SynapseXPath");
        }
        return elem;
    }

    public static OMElement serializeTextPath(SynapsePath path, String expression, OMElement elem, String attribName) {
        if (path != null && expression != null) {
            if (path.getPathType() == "JSON_PATH") {
                if (expression.contains("json-eval(")) {
                    elem.setText(expression);
                } else {
                    elem.setText("json-eval(" + expression + ")");
                }
            } else if (path.getPathType() == "X_PATH") {
                elem.setText(expression);
            }
            SynapsePathSerializer.serializeNamespaces(elem, path);
        } else {
            SynapsePathSerializer.handleException("Couldn't find the xpath in the SynapseXPath");
        }
        return elem;
    }

    public static OMElement serializePathWithBraces(SynapsePath path, OMElement elem, String attribName) {
        OMNamespace nullNS = elem.getOMFactory().createOMNamespace("", "");
        if (path != null) {
            elem.addAttribute(elem.getOMFactory().createOMAttribute(attribName, nullNS, '{' + path.toString() + '}'));
            SynapsePathSerializer.serializeNamespaces(elem, path);
        } else {
            SynapsePathSerializer.handleException("Couldn't find the xpath in the SynapseXPath");
        }
        return elem;
    }

    private static void serializeNamespaces(OMElement elem, SynapsePath path) {
        for (Object o : path.getNamespaces().keySet()) {
            String prefix = (String)o;
            String uri = path.getNamespaceContext().translateNamespacePrefixToUri(prefix);
            if ("http://ws.apache.org/ns/synapse".equals(uri)) continue;
            elem.declareNamespace(uri, prefix);
        }
    }

    private static void handleException(String message) {
        log.error((Object)message);
        throw new SynapseException(message);
    }
}

