/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapsePropertiesLoader;
import org.apache.synapse.config.xml.OMElementUtils;
import org.apache.synapse.config.xml.SynapsePath;
import org.apache.synapse.util.xpath.SynapseJsonPath;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.jaxen.XPathSyntaxException;

public class SynapsePathFactory {
    private static final Log log = LogFactory.getLog(SynapsePathFactory.class);

    public static SynapsePath getSynapsePath(OMElement elem, QName attribName) throws JaxenException {
        SynapsePath path = null;
        OMAttribute pathAttrib = elem.getAttribute(attribName);
        if (pathAttrib != null && pathAttrib.getAttributeValue() != null) {
            if (pathAttrib.getAttributeValue().startsWith("json-eval(")) {
                path = new SynapseJsonPath(pathAttrib.getAttributeValue().substring(10, pathAttrib.getAttributeValue().length() - 1));
            } else {
                try {
                    path = new SynapseXPath(pathAttrib.getAttributeValue());
                }
                catch (XPathSyntaxException ex) {
                    if (Boolean.parseBoolean(SynapsePropertiesLoader.loadSynapseProperties().getProperty("synapse.xpath.dom.failover.enabled"))) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Trying to compile the expression in XPath 2.0: " + pathAttrib.getAttributeValue()));
                        }
                        path = new SynapseXPath(pathAttrib.getAttributeValue(), elem);
                    }
                    throw ex;
                }
            }
            OMElementUtils.addNameSpaces((XPath)path, elem, log);
            path.addNamespacesForFallbackProcessing(elem);
        } else {
            SynapsePathFactory.handleException("Couldn't find the XPath attribute with the QName : " + attribName.toString() + " in the element : " + elem.toString());
        }
        return path;
    }

    public static SynapsePath getSynapsePathfromExpression(OMElement elem, String expression) throws JaxenException {
        SynapsePath path = null;
        if (expression != null) {
            if (expression.startsWith("json-eval(")) {
                path = new SynapseJsonPath(expression.substring(10, expression.length() - 1));
            } else {
                try {
                    path = new SynapseXPath(expression);
                }
                catch (XPathSyntaxException ex) {
                    if (Boolean.parseBoolean(SynapsePropertiesLoader.loadSynapseProperties().getProperty("synapse.xpath.dom.failover.enabled"))) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Trying to compile the expression in XPath 2.0: " + expression));
                        }
                        path = new SynapseXPath(expression, elem);
                    }
                    throw ex;
                }
            }
            OMElementUtils.addNameSpaces((XPath)path, elem, log);
            path.addNamespacesForFallbackProcessing(elem);
        } else {
            SynapsePathFactory.handleException("Couldn't find the XPath expression");
        }
        return path;
    }

    public static SynapsePath getSynapsePath(OMElement elem, String expression) throws JaxenException {
        if (expression == null) {
            SynapsePathFactory.handleException("XPath expression cannot be null");
        }
        SynapseXPath xpath = new SynapseXPath(expression);
        OMElementUtils.addNameSpaces((XPath)xpath, elem, log);
        return xpath;
    }

    private static void handleException(String message) {
        log.error((Object)message);
        throw new SynapseException(message);
    }
}

