/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.config.PassThroughConfiguration;
import org.apache.synapse.transport.passthru.util.RelayUtils;
import org.apache.synapse.util.streaming_xpath.custom.components.ParserComponent;
import org.apache.synapse.util.xpath.DOMSynapseXPathNamespaceMap;
import org.jaxen.JaxenException;

public abstract class SynapsePath
extends AXIOMXPath {
    public static final String X_PATH = "X_PATH";
    public static final String JSON_PATH = "JSON_PATH";
    private String pathType = null;
    public DOMSynapseXPathNamespaceMap domNamespaceMap = new DOMSynapseXPathNamespaceMap();
    public String expression;
    public int bufferSizeSupport = 8192;
    public Log log;
    public boolean contentAware;

    public SynapsePath(OMElement element, String xpathExpr, Log log) throws JaxenException {
        super(element, xpathExpr);
        this.pathType = this.inferPathType(xpathExpr);
        this.log = log;
    }

    public SynapsePath(String xpathExpr, Log log) throws JaxenException {
        super(xpathExpr);
        this.pathType = this.inferPathType(xpathExpr);
        this.log = log;
    }

    public SynapsePath(String path, String pathType, Log log) throws JaxenException {
        super("/");
        this.expression = path;
        this.pathType = this.inferPathType(path);
        this.log = log;
    }

    private String inferPathType(String expression) {
        if (expression.startsWith("json-eval(")) {
            return X_PATH;
        }
        return JSON_PATH;
    }

    public SynapsePath(OMAttribute attribute, Log log) throws JaxenException {
        super(attribute);
        this.pathType = X_PATH;
        this.log = log;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getPathType() {
        return this.pathType;
    }

    public void setPathType(String pathType) {
        this.pathType = pathType;
    }

    public boolean isContentAware() {
        return this.contentAware;
    }

    public String toString() {
        if (this.pathType.equals(JSON_PATH)) {
            return "json-eval(" + this.getExpression().toString() + ")";
        }
        return this.getExpression().toString();
    }

    public abstract String stringValueOf(MessageContext var1);

    public void handleException(String msg, Throwable e) {
        this.log.error((Object)msg, e);
        throw new SynapseException(msg, e);
    }

    public void addNamespacesForFallbackProcessing(OMElement element) {
        OMElement currentElem = element;
        while (currentElem != null) {
            Iterator it = currentElem.getAllDeclaredNamespaces();
            while (it.hasNext()) {
                OMNamespace n = (OMNamespace)it.next();
                if (n == null || "".equals(n.getPrefix())) continue;
                ParserComponent.addToNameSpaceMap(n.getPrefix(), n.getNamespaceURI());
                this.domNamespaceMap.addNamespace(n.getPrefix(), n.getNamespaceURI());
            }
            OMContainer parent = currentElem.getParent();
            if (parent == null || parent instanceof OMDocument) {
                return;
            }
            if (!(parent instanceof OMElement)) continue;
            currentElem = (OMElement)parent;
        }
    }

    public InputStream getMessageInputStreamPT(org.apache.axis2.context.MessageContext context) throws IOException {
        Pipe pipe = (Pipe)context.getProperty("pass-through.pipe");
        if (pipe != null && context.getProperty("bufferedInputStream") != null) {
            BufferedInputStream bufferedInputStream = (BufferedInputStream)context.getProperty("bufferedInputStream");
            try {
                bufferedInputStream.reset();
                bufferedInputStream.mark(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return bufferedInputStream;
        }
        if (pipe != null) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(pipe.getInputStream());
            bufferedInputStream.mark(PassThroughConfiguration.getInstance().getIOBufferSize() * 2);
            OutputStream resetOutStream = pipe.resetOutputStream();
            ReadableByteChannel inputChannel = Channels.newChannel(bufferedInputStream);
            WritableByteChannel outputChannel = Channels.newChannel(resetOutStream);
            if (!this.isMessageBiggerThanBuffer(inputChannel, outputChannel)) {
                try {
                    bufferedInputStream.reset();
                    context.setProperty("bufferedInputStream", (Object)bufferedInputStream);
                    RelayUtils.buildMessage((org.apache.axis2.context.MessageContext)context);
                }
                catch (Exception e) {
                    this.log.error((Object)"Error while building message", (Throwable)e);
                }
                return null;
            }
            try {
                bufferedInputStream.reset();
            }
            catch (Exception exception) {
                // empty catch block
            }
            pipe.setRawSerializationComplete(true);
            return bufferedInputStream;
        }
        return null;
    }

    public boolean isMessageBiggerThanBuffer(ReadableByteChannel src, WritableByteChannel dest) throws IOException {
        this.bufferSizeSupport = PassThroughConfiguration.getInstance().getIOBufferSize();
        ByteBuffer buffer = ByteBuffer.allocate(this.bufferSizeSupport + 1);
        while (src.read(buffer) != -1) {
            if (this.bufferSizeSupport >= buffer.position()) continue;
            return false;
        }
        buffer.flip();
        dest.write(buffer);
        return true;
    }
}

