/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.AnonymousListMediatorFactory;
import org.apache.synapse.config.xml.SwitchCase;
import org.apache.synapse.config.xml.SynapsePathFactory;
import org.apache.synapse.mediators.filters.SwitchMediator;
import org.jaxen.JaxenException;

public class SwitchMediatorFactory
extends AbstractMediatorFactory {
    private static final QName SWITCH_Q = new QName("http://ws.apache.org/ns/synapse", "switch");
    private static final QName CASE_Q = new QName("http://ws.apache.org/ns/synapse", "case");
    private static final QName DEFAULT_Q = new QName("http://ws.apache.org/ns/synapse", "default");

    @Override
    public Mediator createSpecificMediator(OMElement elem, Properties properties) {
        SwitchMediator switchMediator = new SwitchMediator();
        OMAttribute source = elem.getAttribute(ATT_SOURCE);
        if (source == null) {
            String msg = "A 'source' XPath attribute is required for a switch mediator";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        try {
            switchMediator.setSource(SynapsePathFactory.getSynapsePath(elem, ATT_SOURCE));
        }
        catch (JaxenException e) {
            String msg = "Invalid XPath for attribute 'source' : " + source.getAttributeValue();
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        this.processAuditStatus(switchMediator, elem);
        Iterator iter = elem.getChildrenWithName(CASE_Q);
        while (iter.hasNext()) {
            OMElement caseElem = (OMElement)iter.next();
            SwitchCase aCase = new SwitchCase();
            OMAttribute regex = caseElem.getAttribute(ATT_REGEX);
            if (regex == null) {
                String msg = "The 'regex' attribute is required for a switch case definition";
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            try {
                aCase.setRegex(Pattern.compile(regex.getAttributeValue()));
            }
            catch (PatternSyntaxException pse) {
                String msg = "Invalid Regular Expression for attribute 'regex' : " + regex.getAttributeValue();
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            aCase.setCaseMediator(AnonymousListMediatorFactory.createAnonymousListMediator(caseElem, properties));
            switchMediator.addCase(aCase);
        }
        iter = elem.getChildrenWithName(DEFAULT_Q);
        if (iter.hasNext()) {
            SwitchCase aCase = new SwitchCase();
            aCase.setCaseMediator(AnonymousListMediatorFactory.createAnonymousListMediator((OMElement)iter.next(), properties));
            switchMediator.setDefaultCase(aCase);
        }
        SwitchMediatorFactory.addAllCommentChildrenToList(elem, switchMediator.getCommentsList());
        return switchMediator;
    }

    @Override
    public QName getTagQName() {
        return SWITCH_Q;
    }
}

