/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.SequenceType;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.AbstractListMediatorFactory;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.base.SequenceMediator;

public class SequenceMediatorFactory
extends AbstractListMediatorFactory {
    private static final QName SEQUENCE_Q = new QName("http://ws.apache.org/ns/synapse", "sequence");

    @Override
    public QName getTagQName() {
        return SEQUENCE_Q;
    }

    public SequenceMediator createAnonymousSequence(OMElement elem, Properties properties) {
        SequenceMediator seqMediator = new SequenceMediator();
        OMAttribute e = elem.getAttribute(ATT_ONERROR);
        if (e != null) {
            seqMediator.setErrorHandler(e.getAttributeValue());
        }
        this.processAuditStatus(seqMediator, elem);
        OMElement descElem = elem.getFirstChildWithName(DESCRIPTION_Q);
        if (descElem != null) {
            seqMediator.setDescription(descElem.getText());
        }
        SequenceMediatorFactory.addChildren(elem, seqMediator, properties);
        seqMediator.setSequenceType(SequenceType.ANON);
        return seqMediator;
    }

    @Override
    public Mediator createSpecificMediator(OMElement elem, Properties properties) {
        SequenceMediator seqMediator = new SequenceMediator();
        OMAttribute n = elem.getAttribute(ATT_NAME);
        OMAttribute e = elem.getAttribute(ATT_ONERROR);
        if (n != null) {
            seqMediator.setName(n.getAttributeValue());
            if (e != null) {
                seqMediator.setErrorHandler(e.getAttributeValue());
            }
            this.processAuditStatus(seqMediator, elem);
            SequenceMediatorFactory.addChildren(elem, seqMediator, properties);
        } else {
            n = elem.getAttribute(ATT_KEY);
            if (n != null) {
                ValueFactory keyFac = new ValueFactory();
                Value generatedKey = keyFac.createValue("key", elem);
                seqMediator.setKey(generatedKey);
                if (e != null) {
                    String msg = "A sequence mediator with a reference to another sequence can not have 'ErrorHandler'";
                    log.error((Object)msg);
                    throw new SynapseException(msg);
                }
            } else {
                String msg = "A sequence mediator should be a named sequence or a reference to another sequence (i.e. a name attribute or key attribute is required)";
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
        }
        SequenceMediatorFactory.addAllCommentChildrenToList(elem, seqMediator.getCommentsList());
        return seqMediator;
    }
}

