/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.builtin.SendMediator;

public class SendMediatorFactory
extends AbstractMediatorFactory {
    private static final QName SEND_Q = new QName("http://ws.apache.org/ns/synapse", "send");
    private static final QName ENDPOINT_Q = new QName("http://ws.apache.org/ns/synapse", "endpoint");
    private static final QName RECEIVING_SEQUENCE = new QName("receive");
    private static final QName BUILD_MESSAGE = new QName("buildmessage");

    @Override
    public Mediator createSpecificMediator(OMElement elem, Properties properties) {
        String buildMessage;
        String receivingSequence;
        Endpoint endpoint;
        SendMediator sm = new SendMediator();
        this.processAuditStatus(sm, elem);
        OMElement epElement = elem.getFirstChildWithName(ENDPOINT_Q);
        if (epElement != null && (endpoint = EndpointFactory.getEndpointFromElement(epElement, true, properties)) != null) {
            sm.setEndpoint(endpoint);
        }
        if ((receivingSequence = elem.getAttributeValue(RECEIVING_SEQUENCE)) != null) {
            ValueFactory valueFactory = new ValueFactory();
            Value value = valueFactory.createValue("receive", elem);
            sm.setReceivingSequence(value);
        }
        if ("true".equals(buildMessage = elem.getAttributeValue(BUILD_MESSAGE))) {
            sm.setBuildMessage(true);
        }
        SendMediatorFactory.addAllCommentChildrenToList(elem, sm.getCommentsList());
        return sm;
    }

    @Override
    public QName getTagQName() {
        return SEND_Q;
    }
}

