/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.util.resolver.ResourceMap;

public class ResourceMapFactory {
    private static final Log log = LogFactory.getLog(ResourceMapFactory.class);

    public static ResourceMap createResourceMap(OMElement elem) {
        ResourceMap resourceMap = null;
        Iterator it = elem.getChildrenWithName(new QName("http://ws.apache.org/ns/synapse", "resource"));
        ValueFactory keyFac = new ValueFactory();
        while (it.hasNext()) {
            OMAttribute key;
            OMElement resourceElem;
            OMAttribute location;
            if (resourceMap == null) {
                resourceMap = new ResourceMap();
            }
            if ((location = (resourceElem = (OMElement)it.next()).getAttribute(new QName("", "location"))) == null) {
                ResourceMapFactory.handleException("The 'location' attribute is required for a resource definition");
            }
            if ((key = resourceElem.getAttribute(new QName("", "key"))) == null) {
                ResourceMapFactory.handleException("The 'key' attribute is required for a resource definition");
            }
            Value generatedKey = keyFac.createValue("key", resourceElem);
            Value generatedLocation = keyFac.createValue("location", resourceElem);
            resourceMap.addResource(generatedLocation, generatedKey);
        }
        return resourceMap;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

