/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Properties;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.SynapsePathFactory;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.builtin.PropertyMediator;
import org.apache.synapse.util.MediatorPropertyUtils;
import org.apache.synapse.util.xpath.SynapseJsonPath;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class PropertyMediatorFactory
extends AbstractMediatorFactory {
    private static final QName ATT_SCOPE = new QName("scope");
    private static final QName ATT_ACTION = new QName("action");
    private static final QName ATT_TYPE = new QName("type");
    private static final QName ATT_PATTERN = new QName("pattern");
    private static final QName ATT_GROUP = new QName("group");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Mediator createSpecificMediator(OMElement elem, Properties properties) {
        PropertyMediator propMediator = new PropertyMediator();
        OMAttribute name = elem.getAttribute(ATT_NAME);
        OMAttribute value = elem.getAttribute(ATT_VALUE);
        OMAttribute expression = elem.getAttribute(ATT_EXPRN);
        OMAttribute scope = elem.getAttribute(ATT_SCOPE);
        OMAttribute action = elem.getAttribute(ATT_ACTION);
        OMAttribute type = elem.getAttribute(ATT_TYPE);
        OMAttribute pattern = elem.getAttribute(ATT_PATTERN);
        OMAttribute group = elem.getAttribute(ATT_GROUP);
        OMElement valueElement = elem.getFirstElement();
        if (name == null || name.getAttributeValue().isEmpty()) {
            String msg = "The 'name' attribute is required for the configuration of a property mediator";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        if (!(value != null || valueElement != null || expression != null || action != null && "remove".equals(action.getAttributeValue()))) {
            String msg = "Either a child element or one of 'value', 'expression' attributes is required for a property mediator when action is SET";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        String nameAttributeValue = name.getAttributeValue();
        if (MediatorPropertyUtils.isDynamicName(nameAttributeValue)) {
            try {
                String nameExpression = nameAttributeValue.substring(1, nameAttributeValue.length() - 1);
                if (nameExpression.startsWith("json-eval(")) {
                    new SynapseJsonPath(nameExpression.substring(10, nameExpression.length() - 1));
                } else {
                    new SynapseXPath(nameExpression);
                }
            }
            catch (JaxenException e) {
                String msg = "Invalid expression for attribute 'name' : " + nameAttributeValue;
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            ValueFactory nameValueFactory = new ValueFactory();
            Value generatedNameValue = nameValueFactory.createValue("name", elem);
            propMediator.setDynamicNameValue(generatedNameValue);
        }
        propMediator.setName(name.getAttributeValue());
        String dataType = null;
        if (type != null) {
            dataType = type.getAttributeValue();
        }
        if (value != null) {
            propMediator.setValue(value.getAttributeValue(), dataType);
        } else if (valueElement != null) {
            propMediator.setValueElement(valueElement.cloneOMElement());
        } else if (expression != null) {
            try {
                propMediator.setExpression(SynapsePathFactory.getSynapsePath(elem, ATT_EXPRN), dataType);
            }
            catch (JaxenException e) {
                String msg = "Invalid XPath expression for attribute 'expression' : " + expression.getAttributeValue();
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
        }
        if (pattern != null) {
            propMediator.setPattern(Pattern.compile(pattern.getAttributeValue()));
            if (group != null) {
                int groupValue = Integer.parseInt(group.getAttributeValue());
                if (groupValue < 0) {
                    String msg = "group can have a positive value only";
                    log.error((Object)msg);
                    throw new SynapseException(msg);
                }
                propMediator.setGroup(groupValue);
            }
        } else if (group != null) {
            String msg = "group is only allowed when a pattern is specified";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        if (action != null && "remove".equals(action.getAttributeValue())) {
            propMediator.setAction(1);
        }
        if (scope != null) {
            String valueStr = scope.getAttributeValue();
            if (!("axis2".equals(valueStr) || "transport".equals(valueStr) || "operation".equals(valueStr) || "default".equals(valueStr) || "axis2-client".equals(valueStr) || "registry".equals(valueStr) || "trace".equals(valueStr))) {
                String msg = "Only 'axis2' or 'transport' or 'axis2-client' or 'default' or 'operation' or 'registry' or 'trace' values are allowed for attribute scope for a property mediator, Unsupported scope " + valueStr;
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            propMediator.setScope(valueStr);
        }
        this.processAuditStatus(propMediator, elem);
        PropertyMediatorFactory.addAllCommentChildrenToList(elem, propMediator.getCommentsList());
        return propMediator;
    }

    @Override
    public QName getTagQName() {
        return PROP_Q;
    }
}

