/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;

public class PropertyHelper {
    private static final Log log = LogFactory.getLog(PropertyHelper.class);

    public static void setInstanceProperty(String name, Object val, Object obj) {
        String mName = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        try {
            Method[] methods = obj.getClass().getMethods();
            boolean invoked = false;
            for (Method method1 : methods) {
                Method method;
                if (method1 == null || !mName.equals(method1.getName())) continue;
                Class<?>[] params = method1.getParameterTypes();
                if (params.length != 1) {
                    PropertyHelper.handleException("Did not find a setter method named : " + mName + "() that takes a single String, int, long, float, double or boolean parameter");
                } else if (val instanceof String) {
                    String value = (String)val;
                    if (params[0].equals(String.class)) {
                        method = obj.getClass().getMethod(mName, String.class);
                        method.invoke(obj, (Object[])new String[]{value});
                    } else if (params[0].equals(Integer.TYPE)) {
                        method = obj.getClass().getMethod(mName, Integer.TYPE);
                        method.invoke(obj, (Object[])new Integer[]{new Integer(value)});
                    } else if (params[0].equals(Long.TYPE)) {
                        method = obj.getClass().getMethod(mName, Long.TYPE);
                        method.invoke(obj, (Object[])new Long[]{new Long(value)});
                    } else if (params[0].equals(Float.TYPE)) {
                        method = obj.getClass().getMethod(mName, Float.TYPE);
                        method.invoke(obj, (Object[])new Float[]{new Float(value)});
                    } else if (params[0].equals(Double.TYPE)) {
                        method = obj.getClass().getMethod(mName, Double.TYPE);
                        method.invoke(obj, (Object[])new Double[]{new Double(value)});
                    } else if (params[0].equals(Boolean.TYPE)) {
                        method = obj.getClass().getMethod(mName, Boolean.TYPE);
                        method.invoke(obj, (Object[])new Boolean[]{Boolean.valueOf(value)});
                    } else {
                        PropertyHelper.handleException("Did not find a setter method named : " + mName + "() that takes a single String, int, long, float, double or boolean parameter");
                    }
                } else if (params[0].equals(OMElement.class)) {
                    method = obj.getClass().getMethod(mName, OMElement.class);
                    method.invoke(obj, (Object[])new OMElement[]{(OMElement)val});
                }
                invoked = true;
            }
            if (!invoked) {
                PropertyHelper.handleException("Did not find a setter method named : " + mName + "() that takes a single String, int, long, float, double or boolean parameter");
            }
        }
        catch (Exception e) {
            PropertyHelper.handleException("Error invoking setter method named : " + mName + "() that takes a single String, int, long, float, double or boolean parameter", e);
        }
    }

    public static void setStaticProperty(OMElement property, Object o) {
        if (property.getLocalName().toLowerCase().equals("property")) {
            String propertyName = property.getAttributeValue(new QName("name"));
            String mName = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
            if (property.getAttributeValue(new QName("value")) != null) {
                String value = property.getAttributeValue(new QName("value"));
                try {
                    Method method = o.getClass().getMethod(mName, String.class);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Setting property :: invoking method " + mName + "(" + value + ")"));
                    }
                    method.invoke(o, value);
                }
                catch (Exception e) {
                    PropertyHelper.handleException("Error setting property : " + propertyName + " as a String property into class mediator : " + o.getClass() + " : " + e.getMessage(), e);
                }
            } else {
                OMElement value = property.getFirstElement();
                if (value != null) {
                    try {
                        Method method = o.getClass().getMethod(mName, OMElement.class);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Setting property :: invoking method " + mName + "(" + value + ")"));
                        }
                        method.invoke(o, value);
                    }
                    catch (Exception e) {
                        PropertyHelper.handleException("Error setting property : " + propertyName + " as an OMElement property into class mediator : " + o.getClass() + " : " + e.getMessage(), e);
                    }
                }
            }
        }
    }

    public static boolean isStaticProperty(OMElement property) {
        return "property".equals(property.getLocalName().toLowerCase()) && property.getAttributeValue(new QName("expression")) == null;
    }

    private static void handleException(String message, Throwable e) {
        log.error((Object)(message + e.getMessage()));
        throw new SynapseException(message, e);
    }

    private static void handleException(String message) {
        log.error((Object)message);
        throw new SynapseException(message);
    }
}

