/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.SynapsePathSerializer;
import org.apache.synapse.config.xml.ValueSerializer;
import org.apache.synapse.mediators.transform.Argument;
import org.apache.synapse.mediators.transform.PayloadFactoryMediator;

public class PayloadFactoryMediatorSerializer
extends AbstractMediatorSerializer {
    private static final String PAYLOAD_FACTORY = "payloadFactory";
    private static final String FORMAT = "format";
    private static final String ARGS = "args";
    private static final String ARG = "arg";
    private static final String VALUE = "value";
    private static final String EXPRESSION = "expression";
    private static final String EVALUATOR = "evaluator";
    private final String JSON_TYPE = "json";
    private final String MEDIA_TYPE = "media-type";
    private final String TEMPLATE_TYPE = "template-type";
    private final String ESCAPE_XML_CHARS = "escapeXmlChars";
    private final String XML = "xml";
    private final String JSON = "json";
    private final String TEXT = "text";
    private final String LITERAL = "literal";
    private final String FREEMARKER = "freemarker";

    private String getEvaluator(String pathType) {
        if (pathType == "JSON_PATH") {
            return "json";
        }
        return "xml";
    }

    @Override
    public OMElement serializeSpecificMediator(Mediator m) {
        OMElement formatElem;
        if (!(m instanceof PayloadFactoryMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
            return null;
        }
        PayloadFactoryMediator mediator = (PayloadFactoryMediator)m;
        OMElement payloadFactoryElem = fac.createOMElement(PAYLOAD_FACTORY, synNS);
        if (mediator.getType() != null) {
            payloadFactoryElem.addAttribute(fac.createOMAttribute("media-type", null, mediator.getType()));
        }
        if (this.isFreeMarkerTemplate(mediator)) {
            payloadFactoryElem.addAttribute(fac.createOMAttribute("template-type", null, "freemarker"));
        }
        if (mediator.isEscapeXmlChars()) {
            payloadFactoryElem.addAttribute(fac.createOMAttribute("escapeXmlChars", null, Boolean.toString(mediator.isEscapeXmlChars())));
        }
        PayloadFactoryMediatorSerializer.saveTracingState(payloadFactoryElem, mediator);
        if (!mediator.isFormatDynamic()) {
            if (mediator.getFormat() != null) {
                try {
                    formatElem = fac.createOMElement(FORMAT, synNS);
                    String type = mediator.getType();
                    if (type != null && (type.contains("json") || type.contains("text"))) {
                        if (this.isFreeMarkerTemplate(mediator)) {
                            this.createCdataTag(mediator, formatElem);
                        } else {
                            formatElem.setText(mediator.getFormat());
                        }
                    } else if (this.isFreeMarkerTemplate(mediator)) {
                        this.createCdataTag(mediator, formatElem);
                    } else {
                        formatElem.addChild((OMNode)AXIOMUtil.stringToOM((String)mediator.getFormat()));
                    }
                    payloadFactoryElem.addChild((OMNode)formatElem);
                }
                catch (XMLStreamException e) {
                    this.handleException("Error while serializing payloadFactory mediator", e);
                }
            } else {
                this.handleException("Invalid payloadFactory mediator, format is required");
            }
        } else {
            formatElem = fac.createOMElement(FORMAT, synNS);
            formatElem.addAttribute(fac.createOMAttribute("key", nullNS, mediator.getFormatKey().getKeyValue()));
            ValueSerializer keySerializer = new ValueSerializer();
            keySerializer.serializeValue(mediator.getFormatKey(), "key", formatElem);
            payloadFactoryElem.addChild((OMNode)formatElem);
        }
        OMElement argumentsElem = fac.createOMElement(ARGS, synNS);
        List<Argument> pathArgList = mediator.getTemplateProcessor().getPathArgumentList();
        if (null != pathArgList && pathArgList.size() > 0) {
            for (Argument arg : pathArgList) {
                if (arg.getExpression() == null && arg.getValue() == null) continue;
                OMElement argElem = fac.createOMElement(ARG, synNS);
                if (arg.isLiteral()) {
                    argElem.addAttribute(fac.createOMAttribute("literal", nullNS, "true"));
                }
                if (null != arg.getExpression() && null != arg.getExpression().getPathType()) {
                    argElem.addAttribute(fac.createOMAttribute(EVALUATOR, nullNS, this.getEvaluator(arg.getExpression().getPathType())));
                } else if (null == arg.getExpression() && arg.getValue() != null) {
                    argElem.addAttribute(fac.createOMAttribute(VALUE, nullNS, arg.getValue()));
                } else {
                    argElem.addAttribute(fac.createOMAttribute(EVALUATOR, nullNS, this.getEvaluator("X_PATH")));
                }
                if (null != arg.getExpression()) {
                    SynapsePathSerializer.serializePath(arg.getExpression(), argElem, EXPRESSION);
                    QName EXPR_Q = new QName(EXPRESSION);
                    String strExpr = argElem.getAttribute(EXPR_Q).getAttributeValue();
                    if (strExpr.startsWith("json-eval(")) {
                        argElem.getAttribute(EXPR_Q).setAttributeValue(strExpr.substring(10, strExpr.length() - 1));
                    }
                }
                argumentsElem.addChild((OMNode)argElem);
            }
        }
        payloadFactoryElem.addChild((OMNode)argumentsElem);
        this.serializeComments(payloadFactoryElem, mediator.getCommentsList());
        return payloadFactoryElem;
    }

    private void createCdataTag(PayloadFactoryMediator mediator, OMElement formatElem) {
        String formatString = mediator.getFormat();
        formatString = PayloadFactoryMediatorSerializer.removeCDATAFromPayload(formatString);
        OMTextImpl omText = (OMTextImpl)formatElem.getOMFactory().createOMText((OMContainer)formatElem, formatString, 12);
        formatElem.addChild((OMNode)omText);
    }

    private boolean isFreeMarkerTemplate(PayloadFactoryMediator mediator) {
        return mediator.getTemplateType() != null && mediator.getTemplateType().equalsIgnoreCase("freemarker");
    }

    @Override
    public String getMediatorClassName() {
        return PayloadFactoryMediator.class.getName();
    }

    public static String removeCDATAFromPayload(String inputPayload) {
        if (inputPayload.startsWith("<![CDATA[")) {
            int i = (inputPayload = inputPayload.substring(9)).lastIndexOf("]]>");
            if (i == -1) {
                throw new IllegalStateException("argument starts with <![CDATA[ but cannot find pairing ]]>");
            }
            inputPayload = inputPayload.substring(0, i);
        }
        return inputPayload;
    }
}

