/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMText;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.PayloadFactoryMediatorSerializer;
import org.apache.synapse.config.xml.SynapseJsonPathFactory;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.transform.Argument;
import org.apache.synapse.mediators.transform.PayloadFactoryMediator;
import org.apache.synapse.mediators.transform.pfutils.FreeMarkerTemplateProcessor;
import org.apache.synapse.mediators.transform.pfutils.RegexTemplateProcessor;
import org.apache.synapse.mediators.transform.pfutils.TemplateProcessor;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class PayloadFactoryMediatorFactory
extends AbstractMediatorFactory {
    private static final QName PAYLOAD_FACTORY_Q = new QName("http://ws.apache.org/ns/synapse", "payloadFactory");
    private static final QName FORMAT_Q = new QName("http://ws.apache.org/ns/synapse", "format");
    private static final QName ARGS_Q = new QName("http://ws.apache.org/ns/synapse", "args");
    private static final QName ATT_LITERAL = new QName("literal");
    private static final QName TYPE_Q = new QName("media-type");
    private static final QName ESCAPE_XML_CHARS_Q = new QName("escapeXmlChars");
    private static final QName TEMPLATE_TYPE_Q = new QName("template-type");

    @Override
    public Mediator createSpecificMediator(OMElement elem, Properties properties) {
        PayloadFactoryMediator payloadFactoryMediator = new PayloadFactoryMediator();
        TemplateProcessor templateProcessor = this.getTemplateProcessor(elem, payloadFactoryMediator);
        this.processAuditStatus(payloadFactoryMediator, elem);
        String mediaTypeValue = elem.getAttributeValue(TYPE_Q);
        if (mediaTypeValue != null) {
            payloadFactoryMediator.setType(mediaTypeValue);
            templateProcessor.setMediaType(mediaTypeValue);
        } else {
            payloadFactoryMediator.setType("xml");
            templateProcessor.setMediaType("xml");
        }
        boolean escapeXmlCharsValue = Boolean.parseBoolean(elem.getAttributeValue(ESCAPE_XML_CHARS_Q));
        templateProcessor.setEscapeXmlChars(escapeXmlCharsValue);
        OMElement formatElem = elem.getFirstChildWithName(FORMAT_Q);
        if (formatElem != null) {
            OMAttribute n = formatElem.getAttribute(ATT_KEY);
            if (n == null) {
                OMElement copy = formatElem.cloneOMElement();
                this.removeIndentations(copy);
                String format = mediaTypeValue != null && (mediaTypeValue.contains("json") || mediaTypeValue.contains("text")) ? (this.isFreeMarkerTemplate(payloadFactoryMediator) ? PayloadFactoryMediatorSerializer.removeCDATAFromPayload(copy.getText()) : copy.getText()) : (this.isFreeMarkerTemplate(payloadFactoryMediator) ? PayloadFactoryMediatorSerializer.removeCDATAFromPayload(copy.getText()) : copy.getFirstElement().toString());
                payloadFactoryMediator.setFormat(format);
                templateProcessor.setFormat(format);
            } else {
                ValueFactory keyFac = new ValueFactory();
                Value generatedKey = keyFac.createValue("key", formatElem);
                payloadFactoryMediator.setFormatKey(generatedKey);
                payloadFactoryMediator.setFormatDynamic(true);
            }
        } else {
            this.handleException("format element of payloadFactoryMediator is required");
        }
        OMElement argumentsElem = elem.getFirstChildWithName(ARGS_Q);
        if (argumentsElem != null) {
            Iterator itr = argumentsElem.getChildElements();
            while (itr.hasNext()) {
                OMElement argElem = (OMElement)itr.next();
                Argument arg = new Argument();
                boolean isLiteral = false;
                String isLiteralString = argElem.getAttributeValue(ATT_LITERAL);
                if (isLiteralString != null) {
                    isLiteral = Boolean.parseBoolean(isLiteralString);
                }
                arg.setLiteral(isLiteral);
                String value = argElem.getAttributeValue(ATT_VALUE);
                if (value != null) {
                    arg.setValue(value);
                    arg.setExpression(null);
                    templateProcessor.addPathArgument(arg);
                    continue;
                }
                value = argElem.getAttributeValue(ATT_EXPRN);
                if (value != null) {
                    if (value.trim().length() == 0) {
                        this.handleException("Attribute value for xpath cannot be empty");
                        continue;
                    }
                    try {
                        String evaluator = argElem.getAttributeValue(ATT_EVAL);
                        if (evaluator != null && evaluator.equals("json")) {
                            if (value.startsWith("json-eval(")) {
                                value = value.substring(10, value.length() - 1);
                            }
                            arg.setExpression(SynapseJsonPathFactory.getSynapseJsonPath(value));
                            arg.getExpression().setPathType("JSON_PATH");
                            templateProcessor.addPathArgument(arg);
                            continue;
                        }
                        SynapseXPath sxp = SynapseXPathFactory.getSynapseXPath(argElem, ATT_EXPRN);
                        sxp.setForceDisableStreamXpath(Boolean.TRUE);
                        arg.setExpression(sxp);
                        arg.getExpression().setPathType("X_PATH");
                        templateProcessor.addPathArgument(arg);
                    }
                    catch (JaxenException e) {
                        this.handleException("Invalid XPath expression for attribute expression : " + value, (Exception)((Object)e));
                    }
                    continue;
                }
                this.handleException("Unsupported arg type. value or expression attribute required");
            }
        }
        PayloadFactoryMediatorFactory.addAllCommentChildrenToList(elem, payloadFactoryMediator.getCommentsList());
        templateProcessor.init();
        payloadFactoryMediator.setTemplateProcessor(templateProcessor);
        return payloadFactoryMediator;
    }

    private boolean isFreeMarkerTemplate(PayloadFactoryMediator payloadFactoryMediator) {
        return payloadFactoryMediator.getTemplateType() != null && payloadFactoryMediator.getTemplateType().equalsIgnoreCase("FREEMARKER");
    }

    private TemplateProcessor getTemplateProcessor(OMElement elem, PayloadFactoryMediator payloadFactoryMediator) {
        TemplateProcessor templateProcessor;
        String templateTypeValue = elem.getAttributeValue(TEMPLATE_TYPE_Q);
        if (templateTypeValue != null && templateTypeValue.equalsIgnoreCase("FREEMARKER")) {
            payloadFactoryMediator.setTemplateType("FREEMARKER");
            templateProcessor = new FreeMarkerTemplateProcessor();
        } else {
            payloadFactoryMediator.setTemplateType("DEFAULT");
            templateProcessor = new RegexTemplateProcessor();
        }
        return templateProcessor;
    }

    @Override
    public QName getTagQName() {
        return PAYLOAD_FACTORY_Q;
    }

    private void removeIndentations(OMElement element) {
        ArrayList<OMText> removables = new ArrayList<OMText>();
        this.removeIndentations(element, removables);
        for (OMText node : removables) {
            node.detach();
        }
    }

    private void removeIndentations(OMElement element, List<OMText> removables) {
        Iterator children = element.getChildren();
        while (children.hasNext()) {
            Object next = children.next();
            if (next instanceof OMText) {
                OMText text = (OMText)next;
                if (!text.getText().trim().equals("")) continue;
                removables.add(text);
                continue;
            }
            if (!(next instanceof OMElement)) continue;
            this.removeIndentations((OMElement)next, removables);
        }
    }
}

