/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.mediators.builtin.NTLMMediator;

public class NTLMMediatorSerializer
extends AbstractMediatorSerializer {
    @Override
    protected OMElement serializeSpecificMediator(Mediator m) {
        if (!(m instanceof NTLMMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        }
        NTLMMediator mediator = (NTLMMediator)m;
        OMElement ntlmMediator = fac.createOMElement("NTLM", synNS);
        NTLMMediatorSerializer.saveTracingState(ntlmMediator, mediator);
        if (mediator.getUsername() != null) {
            ntlmMediator.addAttribute(fac.createOMAttribute("username", nullNS, mediator.getUsername()));
        }
        if (mediator.getPassword() != null) {
            ntlmMediator.addAttribute(fac.createOMAttribute("password", nullNS, mediator.getPassword()));
        }
        if (mediator.getHost() != null) {
            ntlmMediator.addAttribute(fac.createOMAttribute("host", nullNS, mediator.getHost()));
        }
        if (mediator.getDomain() != null) {
            ntlmMediator.addAttribute(fac.createOMAttribute("domain", nullNS, mediator.getDomain()));
        }
        if (mediator.getNtlmVersion() != null) {
            ntlmMediator.addAttribute(fac.createOMAttribute("ntlmVersion", nullNS, mediator.getNtlmVersion()));
        }
        return ntlmMediator;
    }

    @Override
    public String getMediatorClassName() {
        return NTLMMediator.class.getName();
    }
}

