/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.builtin.NTLMMediator;
import org.apache.synapse.util.xpath.SynapseJsonPath;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class NTLMMediatorFactory
extends AbstractMediatorFactory {
    private static final String USERNAME_ATTRIBUTE_NAME = "username";
    private static final String PASSWORD_ATTRIBUTE_NAME = "password";
    private static final String DOMAIN_ATTRIBUTE_NAME = "domain";
    private static final String HOST_ATTRIBUTE_NAME = "host";
    private static final String NTLM_VERSION_ATTRIBUTE_NAME = "ntlmVersion";
    private static final QName TAG_NAME = new QName("http://ws.apache.org/ns/synapse", "NTLM");
    private static final QName ATT_USER_NAME = new QName("username");
    private static final QName ATT_PASSWORD = new QName("password");
    private static final QName ATT_DOMAIN = new QName("domain");
    private static final QName ATT_HOST = new QName("host");
    private static final QName ATT_NTLM_VERSION = new QName("ntlmVersion");

    @Override
    protected Mediator createSpecificMediator(OMElement elem, Properties properties) {
        NTLMMediator ntlmMediator = new NTLMMediator();
        this.processAuditStatus(ntlmMediator, elem);
        OMAttribute attUserName = elem.getAttribute(ATT_USER_NAME);
        OMAttribute attPassword = elem.getAttribute(ATT_PASSWORD);
        OMAttribute attHost = elem.getAttribute(ATT_HOST);
        OMAttribute attDomain = elem.getAttribute(ATT_DOMAIN);
        OMAttribute attVersion = elem.getAttribute(ATT_NTLM_VERSION);
        if (attUserName != null) {
            String userName = attUserName.getAttributeValue();
            ntlmMediator.setUsername(userName);
            if (this.isDynamicAttribute(userName)) {
                ntlmMediator.setDynamicUsername(this.createValueObject(userName, USERNAME_ATTRIBUTE_NAME, elem));
            }
        }
        if (attPassword != null) {
            String password = attPassword.getAttributeValue();
            ntlmMediator.setPassword(password);
            if (this.isDynamicAttribute(password)) {
                ntlmMediator.setDynamicPassword(this.createValueObject(password, PASSWORD_ATTRIBUTE_NAME, elem));
            }
        }
        if (attHost != null) {
            String host = attHost.getAttributeValue();
            ntlmMediator.setHost(host);
            if (this.isDynamicAttribute(host)) {
                ntlmMediator.setDynamicHost(this.createValueObject(host, HOST_ATTRIBUTE_NAME, elem));
            }
        }
        if (attDomain != null) {
            String domain = attDomain.getAttributeValue();
            ntlmMediator.setDomain(domain);
            if (this.isDynamicAttribute(domain)) {
                ntlmMediator.setDynamicDomain(this.createValueObject(domain, DOMAIN_ATTRIBUTE_NAME, elem));
            }
        }
        if (attVersion != null) {
            String ntlmVersion = attVersion.getAttributeValue();
            ntlmMediator.setNtlmVersion(ntlmVersion);
            if (this.isDynamicAttribute(ntlmVersion)) {
                ntlmMediator.setDynamicNtmlVersion(this.createValueObject(ntlmVersion, NTLM_VERSION_ATTRIBUTE_NAME, elem));
            }
        }
        return ntlmMediator;
    }

    @Override
    public QName getTagQName() {
        return TAG_NAME;
    }

    private boolean isDynamicAttribute(String attributeValue) {
        if (attributeValue.length() < 2) {
            return false;
        }
        int startExpression = 123;
        int endExpression = 125;
        char firstChar = attributeValue.charAt(0);
        char lastChar = attributeValue.charAt(attributeValue.length() - 1);
        return '{' == firstChar && '}' == lastChar;
    }

    private Value createValueObject(String attributeValue, String attributeName, OMElement element) {
        try {
            String nameExpression = attributeValue.substring(1, attributeValue.length() - 1);
            if (nameExpression.startsWith("json-eval(")) {
                new SynapseJsonPath(nameExpression.substring(10, nameExpression.length() - 1));
            } else {
                new SynapseXPath(nameExpression);
            }
        }
        catch (JaxenException e) {
            String msg = "Invalid expression for attribute '" + attributeName + "' : " + attributeValue;
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        ValueFactory nameValueFactory = new ValueFactory();
        return nameValueFactory.createValue(attributeName, element);
    }
}

