/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.util.XMLPrettyPrinter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Startup;
import org.apache.synapse.api.API;
import org.apache.synapse.commons.executors.PriorityExecutor;
import org.apache.synapse.commons.executors.config.PriorityExecutorSerializer;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.CommentSerializer;
import org.apache.synapse.config.xml.EntrySerializer;
import org.apache.synapse.config.xml.MediatorSerializerFinder;
import org.apache.synapse.config.xml.MessageProcessorSerializer;
import org.apache.synapse.config.xml.MessageStoreSerializer;
import org.apache.synapse.config.xml.ProxyServiceSerializer;
import org.apache.synapse.config.xml.RegistrySerializer;
import org.apache.synapse.config.xml.StartupFinder;
import org.apache.synapse.config.xml.SynapseImportSerializer;
import org.apache.synapse.config.xml.TaskManagerSerializer;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.config.xml.endpoints.EndpointSerializer;
import org.apache.synapse.config.xml.endpoints.TemplateSerializer;
import org.apache.synapse.config.xml.eventing.EventSourceSerializer;
import org.apache.synapse.config.xml.inbound.InboundEndpointSerializer;
import org.apache.synapse.config.xml.rest.APISerializer;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.deployers.SynapseArtifactDeploymentStore;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.Template;
import org.apache.synapse.eventing.SynapseEventSource;
import org.apache.synapse.inbound.InboundEndpoint;
import org.apache.synapse.libraries.imports.SynapseImport;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.template.TemplateMediator;
import org.apache.synapse.message.processor.MessageProcessor;
import org.apache.synapse.message.store.MessageStore;
import org.apache.synapse.registry.Registry;
import org.apache.synapse.startup.AbstractStartup;
import org.apache.synapse.task.TaskManager;

public class MultiXMLConfigurationSerializer {
    private static final Log log = LogFactory.getLog(MultiXMLConfigurationSerializer.class);
    private File rootDirectory;
    private File currentDirectory;

    public MultiXMLConfigurationSerializer(String directoryPath) {
        this.currentDirectory = this.rootDirectory = new File(directoryPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(SynapseConfiguration synapseConfig) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Serializing Synapse configuration to the file system");
        }
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement definitions = fac.createOMElement("definitions", XMLConfigConstants.SYNAPSE_OMNAMESPACE);
        boolean errorOccurred = false;
        try {
            this.currentDirectory = this.createTempDirectoryStructure();
            if (synapseConfig.getRegistry() != null) {
                this.serializeSynapseRegistry(synapseConfig.getRegistry(), synapseConfig, definitions);
            }
            if (synapseConfig.getTaskManager() != null) {
                this.serializeTaskManager(synapseConfig.getTaskManager(), synapseConfig, definitions);
            }
            this.serializeProxyServices(synapseConfig.getProxyServices(), synapseConfig, definitions);
            this.serializeEventSources(synapseConfig.getEventSources(), synapseConfig, definitions);
            this.serializeTasks(synapseConfig.getStartups(), synapseConfig, definitions);
            this.serializeLocalRegistryValues(synapseConfig.getLocalRegistry().values(), synapseConfig, definitions);
            this.serializeExecutors(synapseConfig.getPriorityExecutors().values(), synapseConfig, definitions);
            this.serializeMessageStores(synapseConfig.getMessageStores().values(), synapseConfig, definitions);
            this.serializeMessageProcessors(synapseConfig.getMessageProcessors().values(), synapseConfig, definitions);
            this.serializeAPIs(synapseConfig.getAPIs(), synapseConfig, definitions);
            this.serializeInboundEndpoints(synapseConfig.getInboundEndpoints(), synapseConfig, definitions);
            this.serializeImports(synapseConfig.getSynapseImports().values(), synapseConfig, definitions);
            this.serializeComments(synapseConfig.getCommentedTextList(), definitions);
            this.serializeSynapseXML(definitions);
            this.markConfigurationForSerialization(synapseConfig);
            if (this.rootDirectory.exists()) {
                this.cleanupOldFiles();
            }
            FileUtils.copyDirectory((File)this.currentDirectory, (File)this.rootDirectory);
        }
        catch (Exception e) {
            log.error((Object)"Error while serializing the configuration to the file system", (Throwable)e);
            errorOccurred = true;
        }
        finally {
            if (!errorOccurred) {
                this.deleteTempDirectory();
            }
            this.currentDirectory = this.rootDirectory;
        }
    }

    private void cleanupOldFiles() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleting existing files at : " + this.rootDirectory.getAbsolutePath()));
        }
        Collection xmlFiles = FileUtils.listFiles((File)this.rootDirectory, (String[])new String[]{"xml"}, (boolean)true);
        for (File xmlFile : xmlFiles) {
            boolean deleted = FileUtils.deleteQuietly((File)xmlFile);
            if (!log.isDebugEnabled()) continue;
            if (deleted) {
                log.debug((Object)("Deleted the XML file at: " + xmlFile.getPath()));
                continue;
            }
            log.debug((Object)("Failed to delete the XML file at: " + xmlFile.getPath()));
        }
    }

    public boolean isWritable() {
        return this.isWritable(this.rootDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWritable(File file) {
        boolean writable;
        if (file.isDirectory()) {
            File[] children;
            if (".svn".equals(file.getName())) {
                return true;
            }
            for (File child : children = file.listFiles()) {
                if (this.isWritable(child)) continue;
                log.warn((Object)("File: " + child.getName() + " is not writable"));
                return false;
            }
            if (!file.canWrite()) {
                log.warn((Object)("Directory: " + file.getName() + " is not writable"));
                return false;
            }
            return true;
        }
        if (!file.canWrite()) {
            log.warn((Object)("File: " + file.getName() + " is not writable"));
            return false;
        }
        FileOutputStream fos = null;
        FileLock lock = null;
        try {
            fos = new FileOutputStream(file, true);
            FileChannel channel = fos.getChannel();
            lock = channel.tryLock();
        }
        catch (IOException e) {
            log.warn((Object)("Error while attempting to lock the file: " + file.getName()), (Throwable)e);
            writable = false;
        }
        finally {
            if (lock != null) {
                writable = true;
                try {
                    lock.release();
                }
                catch (IOException e) {
                    log.warn((Object)("Error while releasing the lock on file: " + file.getName()), (Throwable)e);
                    writable = false;
                }
            } else {
                log.warn((Object)("Unable to acquire lock on file: " + file.getName()));
                writable = false;
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)("Error while closing the stream on file: " + file.getName()), (Throwable)e);
                writable = false;
            }
        }
        return writable;
    }

    public void serializeSynapseXML(SynapseConfiguration synapseConfig) throws Exception {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement definitions = fac.createOMElement("definitions", XMLConfigConstants.SYNAPSE_OMNAMESPACE);
        if (synapseConfig.getRegistry() != null && !Boolean.valueOf(synapseConfig.getProperty("__separateRegDef")).booleanValue()) {
            RegistrySerializer.serializeRegistry(definitions, synapseConfig.getRegistry());
        }
        if (synapseConfig.getTaskManager() != null && !Boolean.valueOf(synapseConfig.getProperty("__separateTaskManagerDef")).booleanValue()) {
            TaskManagerSerializer.serializetaskManager(definitions, synapseConfig.getTaskManager());
        }
        Collection<ProxyService> proxyServices = synapseConfig.getProxyServices();
        Collection<SynapseEventSource> eventSources = synapseConfig.getEventSources();
        Collection<Startup> tasks = synapseConfig.getStartups();
        Collection localEntries = synapseConfig.getLocalRegistry().values();
        Collection<PriorityExecutor> executors = synapseConfig.getPriorityExecutors().values();
        Collection<MessageStore> messageStores = synapseConfig.getMessageStores().values();
        Collection<MessageProcessor> messageProcessors = synapseConfig.getMessageProcessors().values();
        Collection<API> apiCollection = synapseConfig.getAPIs();
        Collection<SynapseImport> synapseImportsCollection = synapseConfig.getSynapseImports().values();
        Collection<InboundEndpoint> inboundEndpoints = synapseConfig.getInboundEndpoints();
        List<String> comments = synapseConfig.getCommentedTextList();
        for (ProxyService service : proxyServices) {
            if (service.getFileName() != null) continue;
            ProxyServiceSerializer.serializeProxy(definitions, service);
        }
        for (SynapseEventSource source : eventSources) {
            if (source.getFileName() != null) continue;
            EventSourceSerializer.serializeEventSource(definitions, source);
        }
        for (Startup task : tasks) {
            if (!(task instanceof AbstractStartup) || task.getFileName() != null) continue;
            StartupFinder.getInstance().serializeStartup(definitions, task);
        }
        for (Object o : localEntries) {
            Entry entry;
            if (o instanceof TemplateMediator) {
                TemplateMediator template = (TemplateMediator)o;
                if (template.getFileName() != null) continue;
                MediatorSerializerFinder.getInstance().getSerializer(template).serializeMediator(definitions, template);
                continue;
            }
            if (o instanceof SequenceMediator) {
                SequenceMediator seq = (SequenceMediator)o;
                if (seq.getFileName() != null) continue;
                MediatorSerializerFinder.getInstance().getSerializer(seq).serializeMediator(definitions, seq);
                continue;
            }
            if (o instanceof Template) {
                Template templEndpoint = (Template)o;
                if (templEndpoint.getFileName() != null) continue;
                new TemplateSerializer().serializeEndpointTemplate(templEndpoint, definitions);
                continue;
            }
            if (o instanceof AbstractEndpoint) {
                AbstractEndpoint endpoint = (AbstractEndpoint)o;
                if (endpoint.getFileName() != null) continue;
                OMElement endpointElem = EndpointSerializer.getElementFromEndpoint(endpoint);
                definitions.addChild((OMNode)endpointElem);
                continue;
            }
            if (!(o instanceof Entry) || (entry = (Entry)o).getFileName() != null || "SERVER_HOST".equals(entry.getKey()) || "SERVER_IP".equals(entry.getKey()) || entry.getType() == 3) continue;
            EntrySerializer.serializeEntry(entry, definitions);
        }
        for (PriorityExecutor executor : executors) {
            PriorityExecutorSerializer.serialize((OMElement)definitions, (PriorityExecutor)executor, (String)"http://ws.apache.org/ns/synapse");
        }
        for (MessageStore messageStore : messageStores) {
            if (messageStore.getFileName() != null) continue;
            MessageStoreSerializer.serializeMessageStore(definitions, messageStore);
        }
        for (MessageProcessor messageProcessor : messageProcessors) {
            if (messageProcessor.getFileName() != null) continue;
            MessageProcessorSerializer.serializeMessageProcessor(definitions, messageProcessor);
        }
        for (API api : apiCollection) {
            if (api.getFileName() != null) continue;
            APISerializer.serializeAPI(definitions, api);
        }
        for (SynapseImport synapseImport : synapseImportsCollection) {
            if (synapseImport.getFileName() != null) continue;
            SynapseImportSerializer.serializeImport(definitions, synapseImport);
        }
        for (InboundEndpoint inboundEndpoint : inboundEndpoints) {
            if (inboundEndpoint.getFileName() != null) continue;
            InboundEndpointSerializer.serializeInboundEndpoint(definitions, inboundEndpoint);
        }
        this.serializeComments(comments, definitions);
        this.serializeSynapseXML(definitions);
    }

    public OMElement serializeSynapseRegistry(Registry registry, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        OMElement registryElem = RegistrySerializer.serializeRegistry(null, registry);
        if (!Boolean.valueOf(synapseConfig.getProperty("__separateRegDef")).booleanValue() && parent != null) {
            parent.addChild((OMNode)registryElem);
            return registryElem;
        }
        File registryConf = new File(this.currentDirectory, "registry.xml");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Serializing Synapse registry definition to : " + registryConf.getPath()));
        }
        this.writeToFile(registryElem, registryConf);
        return registryElem;
    }

    public OMElement serializeTaskManager(TaskManager taskManager, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        OMElement taskManagerElem = TaskManagerSerializer.serializetaskManager(null, taskManager);
        if (!Boolean.valueOf(synapseConfig.getProperty("__separateTaskManagerDef")).booleanValue() && parent != null) {
            parent.addChild((OMNode)taskManagerElem);
            return taskManagerElem;
        }
        File taskManagerConf = new File(this.currentDirectory, "task-manager.xml");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Serializing Task Manager definition to : " + taskManagerConf.getPath()));
        }
        this.writeToFile(taskManagerElem, taskManagerConf);
        return taskManagerElem;
    }

    public OMElement serializeProxy(ProxyService service, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        File proxyDir = this.createDirectory(this.currentDirectory, "proxy-services");
        OMElement proxyElem = ProxyServiceSerializer.serializeProxy(null, service);
        String fileName = service.getFileName();
        if (fileName != null) {
            if (this.currentDirectory == this.rootDirectory) {
                this.handleDeployment(proxyDir, fileName, service.getName(), synapseConfig.getArtifactDeploymentStore());
            }
            File proxyFile = new File(proxyDir, fileName);
            this.writeToFile(proxyElem, proxyFile);
        } else if (parent != null) {
            parent.addChild((OMNode)proxyElem);
        }
        return proxyElem;
    }

    public OMElement serializeEventSource(SynapseEventSource source, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        File eventsDir = this.createDirectory(this.currentDirectory, "event-sources");
        OMElement eventSrcElem = EventSourceSerializer.serializeEventSource(null, source);
        String fileName = source.getFileName();
        if (fileName != null) {
            if (this.currentDirectory == this.rootDirectory) {
                this.handleDeployment(eventsDir, fileName, source.getName(), synapseConfig.getArtifactDeploymentStore());
            }
            File eventSrcFile = new File(eventsDir, source.getFileName());
            this.writeToFile(eventSrcElem, eventSrcFile);
        } else if (parent != null) {
            parent.addChild((OMNode)eventSrcElem);
        }
        return eventSrcElem;
    }

    public OMElement serializeTask(Startup task, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        File tasksDir = this.createDirectory(this.currentDirectory, "tasks");
        OMElement taskElem = StartupFinder.getInstance().serializeStartup(null, task);
        if (task.getFileName() != null) {
            String fileName = task.getFileName();
            if (this.currentDirectory == this.rootDirectory) {
                this.handleDeployment(tasksDir, fileName, task.getName(), synapseConfig.getArtifactDeploymentStore());
            }
            File taskFile = new File(tasksDir, fileName);
            this.writeToFile(taskElem, taskFile);
        } else if (parent != null) {
            parent.addChild((OMNode)taskElem);
        }
        return taskElem;
    }

    public OMElement serializeSequence(SequenceMediator seq, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        if (!seq.getName().startsWith("_Hidden_Sequence_")) {
            File seqDir = this.createDirectory(this.currentDirectory, "sequences");
            OMElement seqElem = MediatorSerializerFinder.getInstance().getSerializer(seq).serializeMediator(null, seq);
            String fileName = seq.getFileName();
            if (fileName != null) {
                if (this.currentDirectory == this.rootDirectory) {
                    this.handleDeployment(seqDir, fileName, seq.getName(), synapseConfig.getArtifactDeploymentStore());
                }
                File seqFile = new File(seqDir, fileName);
                this.writeToFile(seqElem, seqFile);
            } else if (parent != null) {
                parent.addChild((OMNode)seqElem);
            }
            return seqElem;
        }
        return null;
    }

    public OMElement serializeTemplate(TemplateMediator template, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        File seqDir = this.createDirectory(this.currentDirectory, "templates");
        OMElement seqElem = MediatorSerializerFinder.getInstance().getSerializer(template).serializeMediator(null, template);
        String fileName = template.getFileName();
        if (fileName != null) {
            if (this.currentDirectory == this.rootDirectory) {
                this.handleDeployment(seqDir, fileName, template.getName(), synapseConfig.getArtifactDeploymentStore());
            }
            File seqFile = new File(seqDir, fileName);
            this.writeToFile(seqElem, seqFile);
        } else if (parent != null) {
            parent.addChild((OMNode)seqElem);
        }
        return seqElem;
    }

    public OMElement serializeTemplate(Template template, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        File seqDir = this.createDirectory(this.currentDirectory, "templates");
        OMElement seqElem = new TemplateSerializer().serializeEndpointTemplate(template, null);
        String fileName = template.getFileName();
        if (fileName != null) {
            if (this.currentDirectory == this.rootDirectory) {
                this.handleDeployment(seqDir, fileName, template.getName(), synapseConfig.getArtifactDeploymentStore());
            }
            File seqFile = new File(seqDir, fileName);
            this.writeToFile(seqElem, seqFile);
        } else if (parent != null) {
            parent.addChild((OMNode)seqElem);
        }
        return seqElem;
    }

    public OMElement serializeEndpoint(Endpoint epr, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        File eprDir = this.createDirectory(this.currentDirectory, "endpoints");
        OMElement eprElem = EndpointSerializer.getElementFromEndpoint(epr);
        String fileName = epr.getFileName();
        if (fileName != null) {
            if (this.currentDirectory == this.rootDirectory) {
                this.handleDeployment(eprDir, fileName, epr.getName(), synapseConfig.getArtifactDeploymentStore());
            }
            File eprFile = new File(eprDir, fileName);
            this.writeToFile(eprElem, eprFile);
        } else if (parent != null) {
            parent.addChild((OMNode)eprElem);
        }
        return eprElem;
    }

    public OMElement serializeLocalEntry(Object o, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        if (o instanceof TemplateMediator) {
            return this.serializeTemplate((TemplateMediator)o, synapseConfig, parent);
        }
        if (o instanceof SequenceMediator) {
            return this.serializeSequence((SequenceMediator)o, synapseConfig, parent);
        }
        if (o instanceof Template) {
            return this.serializeTemplate((Template)o, synapseConfig, parent);
        }
        if (o instanceof Endpoint) {
            return this.serializeEndpoint((Endpoint)o, synapseConfig, parent);
        }
        if (o instanceof Entry) {
            Entry entry = (Entry)o;
            if ("SERVER_HOST".equals(entry.getKey()) || "SERVER_IP".equals(entry.getKey()) || entry.getType() == 3) {
                return null;
            }
            File entriesDir = this.createDirectory(this.currentDirectory, "local-entries");
            OMElement entryElem = EntrySerializer.serializeEntry(entry, null);
            String fileName = entry.getFileName();
            if (fileName != null) {
                if (this.currentDirectory == this.rootDirectory) {
                    this.handleDeployment(entriesDir, fileName, entry.getKey(), synapseConfig.getArtifactDeploymentStore());
                }
                File entryFile = new File(entriesDir, fileName);
                this.writeToFile(entryElem, entryFile);
            } else if (parent != null) {
                parent.addChild((OMNode)entryElem);
            }
            return entryElem;
        }
        return null;
    }

    public OMElement serializeExecutor(PriorityExecutor source, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        File executorDir = this.createDirectory(this.currentDirectory, "priority-executors");
        OMElement eventDirElem = PriorityExecutorSerializer.serialize(null, (PriorityExecutor)source, (String)"http://ws.apache.org/ns/synapse");
        File entriesDir = this.createDirectory(this.currentDirectory, "priority-executors");
        String fileName = source.getFileName();
        if (source.getFileName() != null) {
            if (this.currentDirectory == this.rootDirectory) {
                this.handleDeployment(entriesDir, fileName, source.getName(), synapseConfig.getArtifactDeploymentStore());
            }
            File eventSrcFile = new File(executorDir, source.getFileName());
            this.writeToFile(eventDirElem, eventSrcFile);
        } else if (parent != null) {
            parent.addChild((OMNode)eventDirElem);
        }
        return eventDirElem;
    }

    public OMElement serializeMessageStore(MessageStore messagestore, SynapseConfiguration synConfig, OMElement parent) throws Exception {
        File messageStoreDir = this.createDirectory(this.currentDirectory, "message-stores");
        OMElement messageStoreElem = MessageStoreSerializer.serializeMessageStore(null, messagestore);
        String fileName = messagestore.getFileName();
        if (fileName != null) {
            if (this.currentDirectory == this.rootDirectory) {
                this.handleDeployment(messageStoreDir, fileName, messagestore.getName(), synConfig.getArtifactDeploymentStore());
            }
            File messageStoreFile = new File(messageStoreDir, fileName);
            this.writeToFile(messageStoreElem, messageStoreFile);
        } else if (parent != null) {
            parent.addChild((OMNode)messageStoreElem);
        }
        return messageStoreElem;
    }

    public OMElement serializeMessageProcessor(MessageProcessor messageProcessor, SynapseConfiguration synapseConfiguration, OMElement parent) throws Exception {
        File messageProcessorDir = this.createDirectory(this.currentDirectory, "message-processors");
        OMElement messageProcessorElem = MessageProcessorSerializer.serializeMessageProcessor(null, messageProcessor);
        String fileName = messageProcessor.getFileName();
        if (fileName != null) {
            if (this.currentDirectory == this.rootDirectory) {
                this.handleDeployment(messageProcessorDir, fileName, messageProcessor.getName(), synapseConfiguration.getArtifactDeploymentStore());
            }
            File messageProcessorFile = new File(messageProcessorDir, fileName);
            this.writeToFile(messageProcessorElem, messageProcessorFile);
        } else if (parent != null) {
            parent.addChild((OMNode)messageProcessorElem);
        }
        return messageProcessorElem;
    }

    public OMElement serializeAPI(API api, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        File apiDir = this.createDirectory(this.currentDirectory, "api");
        OMElement apiElement = APISerializer.serializeAPI(api);
        String fileName = api.getFileName();
        if (fileName != null) {
            if (this.currentDirectory == this.rootDirectory) {
                this.handleDeployment(apiDir, fileName, api.getName(), synapseConfig.getArtifactDeploymentStore());
            }
            File apiFile = new File(apiDir, fileName);
            this.writeToFile(apiElement, apiFile);
        } else if (parent != null) {
            parent.addChild((OMNode)apiElement);
        }
        return apiElement;
    }

    public OMElement serializeInboundEndpoint(InboundEndpoint inboundEndpoint, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        File inboundEndpointDir = this.createDirectory(this.currentDirectory, "inbound-endpoints");
        OMElement inboundEndpointElt = InboundEndpointSerializer.serializeInboundEndpoint(inboundEndpoint);
        String fileName = inboundEndpoint.getFileName();
        if (fileName != null) {
            if (this.currentDirectory == this.rootDirectory) {
                this.handleDeployment(inboundEndpointDir, fileName, inboundEndpoint.getName(), synapseConfig.getArtifactDeploymentStore());
            }
            File apiFile = new File(inboundEndpointDir, fileName);
            this.writeToFile(inboundEndpointElt, apiFile);
        } else if (parent != null) {
            parent.addChild((OMNode)inboundEndpointElt);
        }
        return inboundEndpointElt;
    }

    public OMElement serializeImport(SynapseImport synapseImport, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        File importDir = this.createDirectory(this.currentDirectory, "imports");
        OMElement importElement = SynapseImportSerializer.serializeImport(synapseImport);
        String fileName = synapseImport.getFileName();
        if (fileName != null) {
            if (this.currentDirectory == this.rootDirectory) {
                this.handleDeployment(importDir, fileName, synapseImport.getName(), synapseConfig.getArtifactDeploymentStore());
            }
            File importFile = new File(importDir, fileName);
            this.writeToFile(importElement, importFile);
        } else if (parent != null) {
            parent.addChild((OMNode)importElement);
        }
        return importElement;
    }

    public OMElement serializeComments(String comment, OMElement parent) {
        if (comment != null) {
            CommentSerializer.serializeComment(parent, comment);
        }
        return parent;
    }

    private void writeToFile(OMElement content, File file) throws Exception {
        File tempFile = File.createTempFile("syn_mx_", ".xml");
        FileOutputStream out = FileUtils.openOutputStream((File)tempFile);
        XMLPrettyPrinter.prettify((OMElement)content, (OutputStream)out);
        out.flush();
        ((OutputStream)out).close();
        FileUtils.copyFile((File)tempFile, (File)file);
        FileUtils.deleteQuietly((File)tempFile);
    }

    private void handleDeployment(File parent, String child, String artifactName, SynapseArtifactDeploymentStore deploymentStore) {
        String fileName = parent.getAbsolutePath() + File.separator + child;
        if (!deploymentStore.containsFileName(fileName)) {
            deploymentStore.addArtifact(fileName, artifactName);
        }
        deploymentStore.addRestoredArtifact(fileName);
    }

    private void serializeProxyServices(Collection<ProxyService> proxyServices, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        for (ProxyService service : proxyServices) {
            this.serializeProxy(service, synapseConfig, parent);
        }
    }

    private void serializeLocalRegistryValues(Collection localValues, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        for (Object o : localValues) {
            this.serializeLocalEntry(o, synapseConfig, parent);
        }
    }

    private void serializeTasks(Collection<Startup> tasks, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        for (Startup task : tasks) {
            this.serializeTask(task, synapseConfig, parent);
        }
    }

    private void serializeEventSources(Collection<SynapseEventSource> eventSources, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        for (SynapseEventSource source : eventSources) {
            this.serializeEventSource(source, synapseConfig, parent);
        }
    }

    private void serializeExecutors(Collection<PriorityExecutor> executors, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        for (PriorityExecutor source : executors) {
            this.serializeExecutor(source, synapseConfig, parent);
        }
    }

    private void serializeMessageStores(Collection<MessageStore> messageStores, SynapseConfiguration synapseConfiguration, OMElement parent) throws Exception {
        for (MessageStore messageStore : messageStores) {
            this.serializeMessageStore(messageStore, synapseConfiguration, parent);
        }
    }

    private void serializeMessageProcessors(Collection<MessageProcessor> messageProcessors, SynapseConfiguration synapseConfiguration, OMElement parent) throws Exception {
        for (MessageProcessor messageProcessor : messageProcessors) {
            this.serializeMessageProcessor(messageProcessor, synapseConfiguration, parent);
        }
    }

    private void serializeAPIs(Collection<API> apiCollection, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        for (API api : apiCollection) {
            this.serializeAPI(api, synapseConfig, parent);
        }
    }

    private void serializeInboundEndpoints(Collection<InboundEndpoint> inboundEndpointCollection, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        for (InboundEndpoint inboundEndpoint : inboundEndpointCollection) {
            this.serializeInboundEndpoint(inboundEndpoint, synapseConfig, parent);
        }
    }

    private void serializeImports(Collection<SynapseImport> importCollection, SynapseConfiguration synapseConfig, OMElement parent) throws Exception {
        for (SynapseImport synapseImport : importCollection) {
            this.serializeImport(synapseImport, synapseConfig, parent);
        }
    }

    private void serializeComments(Collection<String> comments, OMElement parent) {
        for (String comment : comments) {
            this.serializeComments(comment, parent);
        }
    }

    private void serializeSynapseXML(OMElement definitions) throws Exception {
        File synapseXML = new File(this.currentDirectory, "synapse.xml");
        if (!this.currentDirectory.exists()) {
            FileUtils.forceMkdir((File)this.currentDirectory);
        }
        this.writeToFile(definitions, synapseXML);
    }

    private File createTempDirectoryStructure() throws IOException {
        String tempDirName = "__tmp" + new Date().getTime();
        File tempDirectory = new File(this.rootDirectory.getParentFile(), tempDirName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating temporary files at : " + tempDirectory.getAbsolutePath()));
        }
        FileUtils.forceMkdir((File)tempDirectory);
        this.createDirectory(tempDirectory, "proxy-services");
        this.createDirectory(tempDirectory, "event-sources");
        this.createDirectory(tempDirectory, "local-entries");
        this.createDirectory(tempDirectory, "endpoints");
        this.createDirectory(tempDirectory, "sequences");
        this.createDirectory(tempDirectory, "tasks");
        this.createDirectory(tempDirectory, "priority-executors");
        this.createDirectory(tempDirectory, "message-stores");
        this.createDirectory(tempDirectory, "message-processors");
        this.createDirectory(tempDirectory, "api");
        this.createDirectory(tempDirectory, "inbound-endpoints");
        this.createDirectory(tempDirectory, "imports");
        return tempDirectory;
    }

    private void deleteTempDirectory() {
        try {
            if (this.currentDirectory != this.rootDirectory && this.currentDirectory.exists()) {
                FileUtils.deleteDirectory((File)this.currentDirectory);
            }
        }
        catch (IOException e) {
            log.warn((Object)("Error while deleting the temporary files at : " + this.currentDirectory.getAbsolutePath() + " - You may delete them manually."), (Throwable)e);
        }
    }

    private File createDirectory(File parent, String name) throws IOException {
        File dir = new File(parent, name);
        if (!dir.exists()) {
            FileUtils.forceMkdir((File)dir);
        }
        return dir;
    }

    private void markConfigurationForSerialization(SynapseConfiguration synapseConfig) {
        SynapseArtifactDeploymentStore deploymentStore = synapseConfig.getArtifactDeploymentStore();
        for (SequenceMediator seq : synapseConfig.getDefinedSequences().values()) {
            if (seq.getFileName() == null) continue;
            this.handleDeployment(new File(this.rootDirectory, "sequences"), seq.getFileName(), seq.getName(), deploymentStore);
        }
        for (Endpoint ep : synapseConfig.getDefinedEndpoints().values()) {
            if (ep.getFileName() == null) continue;
            this.handleDeployment(new File(this.rootDirectory, "endpoints"), ep.getFileName(), ep.getName(), deploymentStore);
        }
        for (ProxyService proxy : synapseConfig.getProxyServices()) {
            if (proxy.getFileName() == null) continue;
            this.handleDeployment(new File(this.rootDirectory, "proxy-services"), proxy.getFileName(), proxy.getName(), deploymentStore);
        }
        for (Entry e : synapseConfig.getDefinedEntries().values()) {
            if (e.getFileName() == null) continue;
            this.handleDeployment(new File(this.rootDirectory, "local-entries"), File.separator + e.getFileName(), e.getKey(), deploymentStore);
        }
        for (SynapseEventSource es : synapseConfig.getEventSources()) {
            if (es.getFileName() == null) continue;
            this.handleDeployment(new File(this.rootDirectory, "event-sources"), es.getFileName(), es.getName(), deploymentStore);
        }
        for (Startup s : synapseConfig.getStartups()) {
            if (s.getFileName() == null) continue;
            this.handleDeployment(new File(this.rootDirectory, "tasks"), s.getFileName(), s.getName(), deploymentStore);
        }
        for (PriorityExecutor exec : synapseConfig.getPriorityExecutors().values()) {
            if (exec.getFileName() == null) continue;
            this.handleDeployment(new File(this.rootDirectory, "priority-executors"), exec.getFileName(), exec.getName(), deploymentStore);
        }
        for (MessageStore ms : synapseConfig.getMessageStores().values()) {
            if (ms.getFileName() == null) continue;
            this.handleDeployment(new File(this.rootDirectory, "message-stores"), ms.getFileName(), ms.getName(), deploymentStore);
        }
        for (MessageProcessor mp : synapseConfig.getMessageProcessors().values()) {
            if (mp.getFileName() == null) continue;
            this.handleDeployment(new File(this.rootDirectory, "message-processors"), mp.getFileName(), mp.getName(), deploymentStore);
        }
        for (TemplateMediator medTempl : synapseConfig.getSequenceTemplates().values()) {
            if (medTempl.getFileName() == null) continue;
            this.handleDeployment(new File(this.rootDirectory, "templates"), medTempl.getFileName(), medTempl.getName(), deploymentStore);
        }
        for (Template endTempl : synapseConfig.getEndpointTemplates().values()) {
            if (endTempl.getFileName() == null) continue;
            this.handleDeployment(new File(this.rootDirectory, "templates"), endTempl.getFileName(), endTempl.getName(), deploymentStore);
        }
        for (API api : synapseConfig.getAPIs()) {
            if (api.getFileName() == null) continue;
            this.handleDeployment(new File(this.rootDirectory, "api"), api.getFileName(), api.getName(), deploymentStore);
        }
        for (InboundEndpoint inboundEndpoint : synapseConfig.getInboundEndpoints()) {
            if (inboundEndpoint.getFileName() == null) continue;
            this.handleDeployment(new File(this.rootDirectory, "inbound-endpoints"), inboundEndpoint.getFileName(), inboundEndpoint.getName(), deploymentStore);
        }
        for (SynapseImport synapseImport : synapseConfig.getSynapseImports().values()) {
            if (synapseImport.getFileName() == null) continue;
            this.handleDeployment(new File(this.rootDirectory, "imports"), synapseImport.getFileName(), synapseImport.getName(), deploymentStore);
        }
    }
}

