/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.message.store.MessageStore;
import org.apache.synapse.message.store.impl.memory.InMemoryStore;
import org.apache.synapse.util.xpath.SynapseXPath;

public class MessageStoreSerializer {
    private static final Log log = LogFactory.getLog(MessageStoreSerializer.class);
    protected static final OMFactory fac = OMAbstractFactory.getOMFactory();
    protected static final OMNamespace synNS = SynapseConstants.SYNAPSE_OMNAMESPACE;
    protected static final OMNamespace nullNS = fac.createOMNamespace("", "");
    private static final String PWD_ATTR = "password";
    private static final String PWD_MASKED_VALUE = "*****";

    public static OMElement serializeMessageStore(OMElement parent, MessageStore messageStore) {
        return MessageStoreSerializer.serializeMessageStore(parent, messageStore, false);
    }

    public static OMElement serializeMessageStore(OMElement parent, MessageStore messageStore, boolean isUiSerialization) {
        OMElement store = fac.createOMElement("messageStore", synNS);
        if (messageStore != null) {
            if (!messageStore.getClass().getName().equals(InMemoryStore.class.getName())) {
                store.addAttribute(fac.createOMAttribute("class", nullNS, messageStore.getClass().getName()));
            }
        } else {
            MessageStoreSerializer.handleException("Invalid MessageStore. Provider is required");
        }
        if (messageStore.getName() != null) {
            store.addAttribute(fac.createOMAttribute("name", nullNS, messageStore.getName()));
        } else {
            MessageStoreSerializer.handleException("Message store Name not specified");
        }
        if (messageStore.getParameters() != null) {
            for (String name : messageStore.getParameters().keySet()) {
                OMElement property = MessageStoreSerializer.getParameter(messageStore, name, isUiSerialization);
                store.addChild((OMNode)property);
            }
        }
        if (MessageStoreSerializer.getSerializedDescription(messageStore) != null) {
            store.addChild((OMNode)MessageStoreSerializer.getSerializedDescription(messageStore));
        }
        if (parent != null) {
            parent.addChild((OMNode)store);
        }
        return store;
    }

    private static OMElement getParameter(MessageStore messageStore, String name, boolean isUiSerialization) {
        Object paramValue = messageStore.getParameters().get(name);
        OMElement property = null;
        if (paramValue instanceof String) {
            property = fac.createOMElement("parameter", synNS);
            property.addAttribute(fac.createOMAttribute("name", nullNS, name));
            if (messageStore.getParameterKey(name) != null) {
                property.addAttribute(fac.createOMAttribute("key", nullNS, messageStore.getParameterKey(name)));
            } else if (isUiSerialization && name.contains(PWD_ATTR)) {
                property.setText(PWD_MASKED_VALUE);
            } else {
                String value = (String)paramValue;
                property.setText(value.trim());
            }
        } else if (paramValue instanceof SynapseXPath) {
            SynapseXPath value = (SynapseXPath)((Object)paramValue);
            String expression = value.getExpression();
            Map namespaces = value.getNamespaces();
            property = fac.createOMElement("parameter", synNS);
            property.addAttribute(fac.createOMAttribute("name", nullNS, name));
            property.addAttribute(fac.createOMAttribute("expression", nullNS, expression));
            Set nameSpaceAttributes = namespaces.entrySet();
            for (Map.Entry nameSpaceElement : nameSpaceAttributes) {
                String prefix = (String)nameSpaceElement.getKey();
                String uri = (String)nameSpaceElement.getValue();
                property.declareNamespace(uri, prefix);
            }
        }
        return property;
    }

    private static OMElement getSerializedDescription(MessageStore messageStore) {
        OMElement descriptionElem = fac.createOMElement(new QName("http://ws.apache.org/ns/synapse", "description"));
        if (messageStore.getDescription() != null) {
            descriptionElem.setText(messageStore.getDescription());
            return descriptionElem;
        }
        return null;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

