/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.SynapsePathFactory;
import org.apache.synapse.mediators.store.MessageStoreMediator;
import org.jaxen.JaxenException;

public class MessageStoreMediatorFactory
extends AbstractMediatorFactory {
    private static final QName STORE_Q = new QName("http://ws.apache.org/ns/synapse", "store");
    private static final QName ATT_MESSAGE_STORE = new QName("messageStore");
    private static final QName ATT_SEQUENCE = new QName("sequence");

    @Override
    protected Mediator createSpecificMediator(OMElement elem, Properties properties) {
        OMAttribute messageStoreNameAtt;
        MessageStoreMediator messageStoreMediator = new MessageStoreMediator();
        this.processAuditStatus(messageStoreMediator, elem);
        OMAttribute nameAtt = elem.getAttribute(ATT_NAME);
        if (nameAtt != null) {
            messageStoreMediator.setName(nameAtt.getAttributeValue());
        }
        if ((messageStoreNameAtt = elem.getAttribute(ATT_MESSAGE_STORE)) != null) {
            if (this.checkForExpression(messageStoreNameAtt)) {
                String path = messageStoreNameAtt.getAttributeValue().substring(1, messageStoreNameAtt.getAttributeValue().length() - 1);
                try {
                    messageStoreMediator.setMessageStoreExp(SynapsePathFactory.getSynapsePath(elem, path));
                }
                catch (JaxenException e) {
                    String msg = "Invalid XPath expression for attribute 'messageStore' : " + messageStoreNameAtt.getAttributeValue();
                    throw new SynapseException(msg, e);
                }
            } else {
                messageStoreMediator.setMessageStoreName(messageStoreNameAtt.getAttributeValue());
            }
        } else {
            throw new SynapseException("Message Store mediator must have a Message store defined");
        }
        OMAttribute sequenceAtt = elem.getAttribute(ATT_SEQUENCE);
        if (sequenceAtt != null) {
            messageStoreMediator.setOnStoreSequence(sequenceAtt.getAttributeValue());
        }
        MessageStoreMediatorFactory.addAllCommentChildrenToList(elem, messageStoreMediator.getCommentsList());
        return messageStoreMediator;
    }

    @Override
    public QName getTagQName() {
        return STORE_Q;
    }

    private boolean checkForExpression(OMAttribute atr) {
        return atr.getAttributeValue().startsWith("{") && atr.getAttributeValue().endsWith("}");
    }
}

