/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.commons.resolvers.ResolverFactory;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.SynapsePath;
import org.apache.synapse.config.xml.SynapsePathFactory;
import org.apache.synapse.message.store.MessageStore;
import org.apache.synapse.message.store.impl.jms.JmsStore;
import org.apache.synapse.message.store.impl.memory.InMemoryStore;
import org.jaxen.JaxenException;

public class MessageStoreFactory {
    private static final Log log = LogFactory.getLog(MessageStoreFactory.class);
    public static final QName CLASS_Q = new QName("", "class");
    public static final QName NAME_Q = new QName("", "name");
    public static final QName EXPRESSION_Q = new QName("", "expression");
    public static final QName SEQUENCE_Q = new QName("", "sequence");
    public static final QName PARAMETER_Q = new QName("http://ws.apache.org/ns/synapse", "parameter");
    private static final QName DESCRIPTION_Q = new QName("http://ws.apache.org/ns/synapse", "description");
    public static final QName KEY_Q = new QName("", "key");

    public static MessageStore createMessageStore(OMElement elem, Properties properties) {
        return MessageStoreFactory.createMessageStore(elem, properties, null);
    }

    public static MessageStore createMessageStore(OMElement elem, Properties properties, SynapseConfiguration synapseConfiguration) {
        OMAttribute nameAtt;
        MessageStore messageStore;
        OMAttribute clss = elem.getAttribute(CLASS_Q);
        if (clss != null) {
            String clssName = clss.getAttributeValue();
            if ("org.apache.synapse.message.store.InMemoryMessageStore".equals(clssName)) {
                clssName = InMemoryStore.class.getName();
            } else if ("org.wso2.carbon.message.store.persistence.jms.JMSMessageStore".equals(clssName)) {
                clssName = JmsStore.class.getName();
            }
            try {
                Class<?> cls = Class.forName(clssName);
                messageStore = (MessageStore)cls.newInstance();
            }
            catch (Exception e) {
                MessageStoreFactory.handleException("Error while instantiating the message store", e);
                return null;
            }
        } else {
            messageStore = new InMemoryStore();
        }
        if ((nameAtt = elem.getAttribute(NAME_Q)) != null) {
            messageStore.setName(nameAtt.getAttributeValue());
        } else {
            MessageStoreFactory.handleException("Message Store name not specified");
        }
        OMElement descriptionElem = elem.getFirstChildWithName(DESCRIPTION_Q);
        if (descriptionElem != null) {
            messageStore.setDescription(descriptionElem.getText());
        }
        messageStore.setParameters(MessageStoreFactory.getParameters(elem, messageStore, synapseConfiguration));
        log.info((Object)("Successfully added Message Store configuration of : [" + nameAtt.getAttributeValue() + "]."));
        return messageStore;
    }

    private static Map<String, Object> getParameters(OMElement elem, MessageStore messageStore, SynapseConfiguration synapseConfiguration) {
        HashMap<String, Object> parameters = null;
        try {
            Iterator params = elem.getChildrenWithName(PARAMETER_Q);
            parameters = new HashMap<String, Object>();
            while (params.hasNext()) {
                Object o = params.next();
                if (!(o instanceof OMElement)) continue;
                OMElement prop = (OMElement)o;
                OMAttribute paramName = prop.getAttribute(NAME_Q);
                OMAttribute expression = prop.getAttribute(EXPRESSION_Q);
                OMAttribute paramKey = prop.getAttribute(KEY_Q);
                String paramValue = prop.getText();
                if (expression != null) {
                    SynapsePath xPathExpression = SynapsePathFactory.getSynapsePath(prop, EXPRESSION_Q);
                    MessageStoreFactory.registerParameter(parameters, paramName, xPathExpression);
                    continue;
                }
                if (paramKey != null) {
                    MessageStoreFactory.addParameterKey(messageStore, paramName.getAttributeValue(), paramKey.getAttributeValue());
                    if (synapseConfiguration != null) {
                        Object obj = synapseConfiguration.getEntry(paramKey.getAttributeValue());
                        if (obj == null) {
                            synapseConfiguration.getEntryDefinition(paramKey.getAttributeValue());
                            obj = synapseConfiguration.getEntry(paramKey.getAttributeValue());
                        }
                        if (obj != null && obj instanceof OMTextImpl) {
                            OMText objText = (OMText)obj;
                            MessageStoreFactory.registerParameter(parameters, paramName, objText.getText());
                            continue;
                        }
                        String msg = "Registry entry defined with key: " + paramKey.getAttributeValue() + " not found.";
                        MessageStoreFactory.handleException(msg);
                        continue;
                    }
                    MessageStoreFactory.handleException("Synapse configuration is null.");
                    continue;
                }
                String resolvedParameter = paramValue;
                if (resolvedParameter != null) {
                    resolvedParameter = ResolverFactory.getInstance().getResolver(paramValue).resolve();
                }
                MessageStoreFactory.registerParameter(parameters, paramName, resolvedParameter);
            }
        }
        catch (JaxenException e) {
            throw new SynapseException("Error occurred while extracting the parameters", e);
        }
        return parameters;
    }

    private static <T> void registerParameter(Map<String, Object> parameters, OMAttribute paramName, T paramValue) {
        if (paramName != null && paramValue != null) {
            parameters.put(paramName.getAttributeValue(), paramValue);
        } else {
            MessageStoreFactory.handleException("Invalid MessageStore parameter - Parameter must have a name ");
        }
    }

    private static void addParameterKey(MessageStore ms, String key, String value) {
        ms.addParameterKey(key, value);
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }
}

