/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Nameable;
import org.apache.synapse.SynapseException;
import org.apache.synapse.message.processor.MessageProcessor;
import org.apache.synapse.message.processor.impl.forwarder.ScheduledMessageForwardingProcessor;
import org.apache.synapse.message.processor.impl.sampler.SamplingProcessor;

public class MessageProcessorFactory {
    private static final Log log = LogFactory.getLog(MessageProcessorFactory.class);
    public static final String FORWARDING_PROCESSOR = "org.apache.synapse.message.processor.impl.forwarder.ScheduledMessageForwardingProcessor";
    public static final QName CLASS_Q = new QName("", "class");
    public static final QName TARGET_ENDPOINT_Q = new QName("", "targetEndpoint");
    public static final QName SEQUENCE_Q = new QName("", "sequence");
    public static final QName NAME_Q = new QName("", "name");
    public static final QName PARAMETER_Q = new QName("http://ws.apache.org/ns/synapse", "parameter");
    public static final QName MESSAGE_STORE_Q = new QName("", "messageStore");
    private static final QName DESCRIPTION_Q = new QName("http://ws.apache.org/ns/synapse", "description");

    public static MessageProcessor createMessageProcessor(OMElement elem) {
        OMAttribute storeAtt;
        OMAttribute targetSequenceAtt;
        Nameable processor = null;
        OMAttribute clssAtt = elem.getAttribute(CLASS_Q);
        if (clssAtt != null) {
            String clssName = clssAtt.getAttributeValue();
            if ("org.apache.synapse.message.processors.forward.ScheduledMessageForwardingProcessor".equals(clssName)) {
                clssName = ScheduledMessageForwardingProcessor.class.getName();
            } else if ("org.apache.synapse.message.processors.sampler.SamplingProcessor".equals(clssName)) {
                clssName = SamplingProcessor.class.getName();
            }
            try {
                Class<?> cls = Class.forName(clssName);
                processor = (MessageProcessor)cls.newInstance();
            }
            catch (Exception e) {
                MessageProcessorFactory.handleException("Error while creating Message processor " + e.getMessage());
            }
        } else {
            MessageProcessorFactory.handleException("Can't create Message processor without a provider class");
        }
        OMAttribute nameAtt = elem.getAttribute(NAME_Q);
        if (nameAtt != null) {
            assert (processor != null);
            processor.setName(nameAtt.getAttributeValue());
        } else {
            MessageProcessorFactory.handleException("Can't create Message processor without a name ");
        }
        if (FORWARDING_PROCESSOR.equals(clssAtt.getAttributeValue()) && (targetSequenceAtt = elem.getAttribute(TARGET_ENDPOINT_Q)) != null) {
            assert (processor != null);
            processor.setTargetEndpoint(targetSequenceAtt.getAttributeValue());
        }
        if ((storeAtt = elem.getAttribute(MESSAGE_STORE_Q)) != null) {
            assert (processor != null);
            processor.setMessageStoreName(storeAtt.getAttributeValue());
        } else {
            MessageProcessorFactory.handleException("Can't create a message processor with out a message Store");
        }
        OMElement descriptionElem = elem.getFirstChildWithName(DESCRIPTION_Q);
        if (descriptionElem != null) {
            assert (processor != null);
            processor.setDescription(descriptionElem.getText());
        }
        assert (processor != null);
        processor.setParameters(MessageProcessorFactory.getParameters(elem));
        return processor;
    }

    private static Map<String, Object> getParameters(OMElement elem) {
        Iterator params = elem.getChildrenWithName(PARAMETER_Q);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        while (params.hasNext()) {
            Object o = params.next();
            if (!(o instanceof OMElement)) continue;
            OMElement prop = (OMElement)o;
            OMAttribute paramName = prop.getAttribute(NAME_Q);
            String paramValue = prop.getText();
            if (paramName != null) {
                if (paramValue == null) continue;
                parameters.put(paramName.getAttributeValue(), paramValue);
                continue;
            }
            MessageProcessorFactory.handleException("Invalid MessageStore parameter - Parameter must have a name ");
        }
        return parameters;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

