/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.AggregateMediatorSerializer;
import org.apache.synapse.config.xml.BeanMediatorSerializer;
import org.apache.synapse.config.xml.CallMediatorSerializer;
import org.apache.synapse.config.xml.CalloutMediatorSerializer;
import org.apache.synapse.config.xml.ClassMediatorSerializer;
import org.apache.synapse.config.xml.CloneMediatorSerializer;
import org.apache.synapse.config.xml.CommentMediatorSerializer;
import org.apache.synapse.config.xml.ConditionalRouterMediatorSerializer;
import org.apache.synapse.config.xml.DBLookupMediatorSerializer;
import org.apache.synapse.config.xml.DBReportMediatorSerializer;
import org.apache.synapse.config.xml.DropMediatorSerializer;
import org.apache.synapse.config.xml.EJBMediatorSerializer;
import org.apache.synapse.config.xml.EnqueueMediatorSerializer;
import org.apache.synapse.config.xml.EnrichMediatorSerializer;
import org.apache.synapse.config.xml.FaultMediatorSerializer;
import org.apache.synapse.config.xml.FilterMediatorSerializer;
import org.apache.synapse.config.xml.ForEachMediatorSerializer;
import org.apache.synapse.config.xml.HeaderMediatorSerializer;
import org.apache.synapse.config.xml.InMediatorSerializer;
import org.apache.synapse.config.xml.InvokeMediatorSerializer;
import org.apache.synapse.config.xml.IterateMediatorSerializer;
import org.apache.synapse.config.xml.JSONTransformMediatorSerializer;
import org.apache.synapse.config.xml.LogMediatorSerializer;
import org.apache.synapse.config.xml.LoopBackMediatorSerializer;
import org.apache.synapse.config.xml.MediatorSerializer;
import org.apache.synapse.config.xml.MessageStoreMediatorSerializer;
import org.apache.synapse.config.xml.NTLMMediatorSerializer;
import org.apache.synapse.config.xml.OutMediatorSerializer;
import org.apache.synapse.config.xml.POJOCommandMediatorSerializer;
import org.apache.synapse.config.xml.PayloadFactoryMediatorSerializer;
import org.apache.synapse.config.xml.PropertyGroupMediatorSerializer;
import org.apache.synapse.config.xml.PropertyMediatorSerializer;
import org.apache.synapse.config.xml.RespondMediatorSerializer;
import org.apache.synapse.config.xml.SamplingThrottleMediatorSerializer;
import org.apache.synapse.config.xml.SendMediatorSerializer;
import org.apache.synapse.config.xml.SequenceMediatorSerializer;
import org.apache.synapse.config.xml.SwitchMediatorSerializer;
import org.apache.synapse.config.xml.SynapseMediatorSerializer;
import org.apache.synapse.config.xml.TemplateMediatorSerializer;
import org.apache.synapse.config.xml.TransactionMediatorSerializer;
import org.apache.synapse.config.xml.URLRewriteMediatorSerializer;
import org.apache.synapse.config.xml.ValidateMediatorSerializer;
import org.apache.synapse.config.xml.XSLTMediatorSerializer;
import org.apache.synapse.config.xml.eventing.EventPublisherMediatorSerializer;

public class MediatorSerializerFinder {
    private static final Log log = LogFactory.getLog(MediatorSerializerFinder.class);
    private static final Class[] mediatorSerializers = new Class[]{SequenceMediatorSerializer.class, LogMediatorSerializer.class, SendMediatorSerializer.class, FilterMediatorSerializer.class, SynapseMediatorSerializer.class, DropMediatorSerializer.class, HeaderMediatorSerializer.class, FaultMediatorSerializer.class, PropertyMediatorSerializer.class, PropertyGroupMediatorSerializer.class, SwitchMediatorSerializer.class, InMediatorSerializer.class, OutMediatorSerializer.class, ClassMediatorSerializer.class, ValidateMediatorSerializer.class, XSLTMediatorSerializer.class, POJOCommandMediatorSerializer.class, CloneMediatorSerializer.class, IterateMediatorSerializer.class, AggregateMediatorSerializer.class, DBLookupMediatorSerializer.class, DBReportMediatorSerializer.class, CalloutMediatorSerializer.class, EventPublisherMediatorSerializer.class, TransactionMediatorSerializer.class, EnqueueMediatorSerializer.class, ConditionalRouterMediatorSerializer.class, SamplingThrottleMediatorSerializer.class, EnrichMediatorSerializer.class, TemplateMediatorSerializer.class, InvokeMediatorSerializer.class, MessageStoreMediatorSerializer.class, URLRewriteMediatorSerializer.class, PayloadFactoryMediatorSerializer.class, BeanMediatorSerializer.class, EJBMediatorSerializer.class, CallMediatorSerializer.class, LoopBackMediatorSerializer.class, RespondMediatorSerializer.class, CommentMediatorSerializer.class, ForEachMediatorSerializer.class, JSONTransformMediatorSerializer.class, NTLMMediatorSerializer.class};
    private static final MediatorSerializerFinder instance = new MediatorSerializerFinder();
    private final Map<String, MediatorSerializer> serializerMap = new HashMap<String, MediatorSerializer>();

    public static synchronized MediatorSerializerFinder getInstance() {
        return instance;
    }

    public MediatorSerializer getSerializer(Mediator mediator) {
        return this.serializerMap.get(mediator.getClass().getName());
    }

    private MediatorSerializerFinder() {
        for (Class c : mediatorSerializers) {
            try {
                MediatorSerializer ser = (MediatorSerializer)c.newInstance();
                this.serializerMap.put(ser.getMediatorClassName(), ser);
            }
            catch (Exception e) {
                throw new SynapseException("Error instantiating " + c.getName(), e);
            }
        }
        this.registerExtensions();
    }

    private void registerExtensions() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Registering mediator extensions found in the classpath.. ");
        }
        for (MediatorSerializer ms : ServiceLoader.load(MediatorSerializer.class)) {
            String name = ms.getMediatorClassName();
            try {
                this.serializerMap.put(name, (MediatorSerializer)ms.getClass().newInstance());
            }
            catch (InstantiationException e) {
                MediatorSerializerFinder.handleException("Error instantiating mediator serializer : " + ms);
            }
            catch (IllegalAccessException e) {
                MediatorSerializerFinder.handleException("Error instantiating mediator serializer : " + ms);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Added MediatorSerializer " + ms.getClass().getName() + " to handle " + name));
        }
    }

    public Map<String, MediatorSerializer> getSerializerMap() {
        return this.serializerMap;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

