/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.PropertyHelper;
import org.apache.synapse.config.xml.SynapsePathFactory;
import org.apache.synapse.mediators.MediatorProperty;
import org.jaxen.JaxenException;

public class MediatorPropertyFactory {
    private static final Log log = LogFactory.getLog(MediatorPropertyFactory.class);

    public static List<MediatorProperty> getMediatorProperties(OMElement elem, Mediator mediator) {
        ArrayList<MediatorProperty> propertyList = new ArrayList<MediatorProperty>();
        Iterator iter = elem.getChildrenWithName(MediatorProperty.PROPERTY_Q);
        while (iter.hasNext()) {
            String msg;
            OMElement propEle = (OMElement)iter.next();
            OMAttribute attName = propEle.getAttribute(MediatorProperty.ATT_NAME_Q);
            OMAttribute attValue = propEle.getAttribute(MediatorProperty.ATT_VALUE_Q);
            OMAttribute attExpr = propEle.getAttribute(MediatorProperty.ATT_EXPR_Q);
            OMAttribute attScope = propEle.getAttribute(MediatorProperty.ATT_SCOPE_Q);
            MediatorProperty prop = new MediatorProperty();
            if (attName == null || attName.getAttributeValue() == null || attName.getAttributeValue().trim().length() == 0) {
                msg = "Entry name is a required attribute for a Log property";
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            prop.setName(attName.getAttributeValue());
            if (attValue != null) {
                if (mediator == null && (attValue.getAttributeValue() == null || attValue.getAttributeValue().trim().isEmpty())) {
                    msg = "Entry attribute value (if specified) is required for a Log property";
                    log.error((Object)msg);
                    throw new SynapseException(msg);
                }
                String attributeValue = attValue.getAttributeValue();
                prop.setValue(attributeValue);
                if (mediator != null) {
                    PropertyHelper.setInstanceProperty(attName.getAttributeValue(), attributeValue, mediator);
                }
            } else if (attExpr != null) {
                if (attExpr.getAttributeValue() == null || attExpr.getAttributeValue().trim().length() == 0) {
                    msg = "Entry attribute expression (if specified) is required for a mediator property";
                    log.error((Object)msg);
                    throw new SynapseException(msg);
                }
                try {
                    prop.setExpression(SynapsePathFactory.getSynapsePath(propEle, MediatorProperty.ATT_EXPR_Q));
                }
                catch (JaxenException e) {
                    String msg2 = "Invalid XPath expression : " + attExpr.getAttributeValue();
                    log.error((Object)msg2);
                    throw new SynapseException(msg2, e);
                }
            } else if (propEle.getFirstElement() != null) {
                OMElement childElement = propEle.getFirstElement();
                prop.setObject(childElement);
                if (mediator != null) {
                    PropertyHelper.setInstanceProperty(prop.getName(), childElement, mediator);
                }
            } else {
                msg = "Entry attribute value OR expression must be specified for a mediator property";
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            if (attScope != null) {
                String valueStr = attScope.getAttributeValue();
                if (!("axis2".equals(valueStr) || "transport".equals(valueStr) || "default".equals(valueStr) || "axis2-client".equals(valueStr))) {
                    String msg3 = "Only 'axis2' or 'transport' or 'axis2-client' values are allowed for attribute scope for a property, Unsupported scope " + valueStr;
                    log.error((Object)msg3);
                    throw new SynapseException(msg3);
                }
                prop.setScope(valueStr);
            }
            propertyList.add(prop);
        }
        return propertyList;
    }

    public static List<MediatorProperty> getMediatorProperties(OMElement elem) {
        return MediatorPropertyFactory.getMediatorProperties(elem, null);
    }
}

