/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.XMLToObjectMapper;
import org.apache.synapse.config.xml.AggregateMediatorFactory;
import org.apache.synapse.config.xml.AnnotatedCommandMediatorFactory;
import org.apache.synapse.config.xml.BeanMediatorFactory;
import org.apache.synapse.config.xml.CallMediatorFactory;
import org.apache.synapse.config.xml.CalloutMediatorFactory;
import org.apache.synapse.config.xml.ClassMediatorFactory;
import org.apache.synapse.config.xml.CloneMediatorFactory;
import org.apache.synapse.config.xml.CommentMediatorFactory;
import org.apache.synapse.config.xml.ConditionalRouterMediatorFactory;
import org.apache.synapse.config.xml.DBLookupMediatorFactory;
import org.apache.synapse.config.xml.DBReportMediatorFactory;
import org.apache.synapse.config.xml.DropMediatorFactory;
import org.apache.synapse.config.xml.EJBMediatorFactory;
import org.apache.synapse.config.xml.EnqueueMediatorFactory;
import org.apache.synapse.config.xml.EnrichMediatorFactory;
import org.apache.synapse.config.xml.FaultMediatorFactory;
import org.apache.synapse.config.xml.FilterMediatorFactory;
import org.apache.synapse.config.xml.ForEachMediatorFactory;
import org.apache.synapse.config.xml.HeaderMediatorFactory;
import org.apache.synapse.config.xml.InMediatorFactory;
import org.apache.synapse.config.xml.InvokeMediatorFactory;
import org.apache.synapse.config.xml.IterateMediatorFactory;
import org.apache.synapse.config.xml.JSONTransformMediatorFactory;
import org.apache.synapse.config.xml.LogMediatorFactory;
import org.apache.synapse.config.xml.LoopBackMediatorFactory;
import org.apache.synapse.config.xml.MediatorFactory;
import org.apache.synapse.config.xml.MessageStoreMediatorFactory;
import org.apache.synapse.config.xml.NTLMMediatorFactory;
import org.apache.synapse.config.xml.OutMediatorFactory;
import org.apache.synapse.config.xml.POJOCommandMediatorFactory;
import org.apache.synapse.config.xml.PayloadFactoryMediatorFactory;
import org.apache.synapse.config.xml.PropertyGroupMediatorFactory;
import org.apache.synapse.config.xml.PropertyMediatorFactory;
import org.apache.synapse.config.xml.RespondMediatorFactory;
import org.apache.synapse.config.xml.SamplingThrottleMediatorFactory;
import org.apache.synapse.config.xml.SendMediatorFactory;
import org.apache.synapse.config.xml.SequenceMediatorFactory;
import org.apache.synapse.config.xml.SwitchMediatorFactory;
import org.apache.synapse.config.xml.SynapseMediatorFactory;
import org.apache.synapse.config.xml.TemplateMediatorFactory;
import org.apache.synapse.config.xml.TransactionMediatorFactory;
import org.apache.synapse.config.xml.URLRewriteMediatorFactory;
import org.apache.synapse.config.xml.ValidateMediatorFactory;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.config.xml.XSLTMediatorFactory;
import org.apache.synapse.config.xml.eventing.EventPublisherMediatorFactory;
import org.apache.synapse.libraries.imports.SynapseImport;
import org.apache.synapse.libraries.model.Library;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.template.InvokeMediator;

public class MediatorFactoryFinder
implements XMLToObjectMapper {
    private Map<String, Library> synapseLibraryMap;
    private Map<String, SynapseImport> synapseImportMap;
    private static final Log log = LogFactory.getLog(MediatorFactoryFinder.class);
    private static final Class[] mediatorFactories = new Class[]{SequenceMediatorFactory.class, LogMediatorFactory.class, SendMediatorFactory.class, FilterMediatorFactory.class, SynapseMediatorFactory.class, DropMediatorFactory.class, HeaderMediatorFactory.class, FaultMediatorFactory.class, PropertyMediatorFactory.class, PropertyGroupMediatorFactory.class, SwitchMediatorFactory.class, InMediatorFactory.class, OutMediatorFactory.class, ClassMediatorFactory.class, ValidateMediatorFactory.class, XSLTMediatorFactory.class, AnnotatedCommandMediatorFactory.class, POJOCommandMediatorFactory.class, CloneMediatorFactory.class, IterateMediatorFactory.class, AggregateMediatorFactory.class, DBReportMediatorFactory.class, DBLookupMediatorFactory.class, CalloutMediatorFactory.class, EventPublisherMediatorFactory.class, TransactionMediatorFactory.class, EnqueueMediatorFactory.class, ConditionalRouterMediatorFactory.class, SamplingThrottleMediatorFactory.class, URLRewriteMediatorFactory.class, EnrichMediatorFactory.class, MessageStoreMediatorFactory.class, TemplateMediatorFactory.class, InvokeMediatorFactory.class, PayloadFactoryMediatorFactory.class, BeanMediatorFactory.class, EJBMediatorFactory.class, CallMediatorFactory.class, LoopBackMediatorFactory.class, RespondMediatorFactory.class, CommentMediatorFactory.class, ForEachMediatorFactory.class, JSONTransformMediatorFactory.class, NTLMMediatorFactory.class};
    private static final MediatorFactoryFinder instance = new MediatorFactoryFinder();
    private static Map<QName, Class> factoryMap = new HashMap<QName, Class>();
    private static boolean initialized = false;

    public static synchronized MediatorFactoryFinder getInstance() {
        if (!initialized) {
            MediatorFactoryFinder.loadMediatorFactories();
        }
        return instance;
    }

    public static synchronized void reset() {
        factoryMap.clear();
        initialized = false;
    }

    private MediatorFactoryFinder() {
    }

    private static void loadMediatorFactories() {
        for (Class c : mediatorFactories) {
            try {
                MediatorFactory fac = (MediatorFactory)c.newInstance();
                factoryMap.put(fac.getTagQName(), c);
            }
            catch (Exception e) {
                throw new SynapseException("Error instantiating " + c.getName(), e);
            }
        }
        MediatorFactoryFinder.registerExtensions();
        initialized = true;
    }

    private static void registerExtensions() {
        for (MediatorFactory mf : ServiceLoader.load(MediatorFactory.class)) {
            QName tag = mf.getTagQName();
            factoryMap.put(tag, mf.getClass());
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Added MediatorFactory " + mf.getClass() + " to handle " + tag));
        }
    }

    public Mediator getMediator(OMElement element, Properties properties) {
        return this.getMediator(element, properties, null);
    }

    public Mediator getMediator(OMElement element, Properties properties, SynapseConfiguration configuration) {
        Class cls;
        String localName = element.getLocalName();
        QName qName = element.getNamespace() != null ? new QName(element.getNamespace().getNamespaceURI(), localName) : new QName(localName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getMediator(" + qName + ")"));
        }
        if ((cls = factoryMap.get(qName)) == null && localName.indexOf(46) > -1) {
            Iterator<Map.Entry<String, SynapseImport>> newLocalName = localName.substring(0, localName.indexOf(46));
            qName = new QName(element.getNamespace().getNamespaceURI(), (String)((Object)newLocalName));
            if (log.isDebugEnabled()) {
                log.debug((Object)("getMediator.2(" + qName + ")"));
            }
            cls = factoryMap.get(qName);
        }
        if (cls == null) {
            if (this.synapseLibraryMap != null && !this.synapseLibraryMap.isEmpty()) {
                for (Map.Entry entry : this.synapseLibraryMap.entrySet()) {
                    if (!((Library)entry.getValue()).getLibArtifactDetails().containsKey(localName)) continue;
                    return this.getDynamicInvokeMediator(element, ((Library)entry.getValue()).getPackage());
                }
            }
            if (configuration != null) {
                if (configuration.getSynapseImports() != null && !configuration.getSynapseImports().isEmpty()) {
                    for (Map.Entry<String, SynapseImport> entry : configuration.getSynapseImports().entrySet()) {
                        if (!localName.startsWith(entry.getValue().getLibName())) continue;
                        return this.getDynamicInvokeMediator(element, entry.getValue().getLibPackage());
                    }
                }
            } else if (this.synapseImportMap != null && !this.synapseImportMap.isEmpty()) {
                for (Map.Entry<String, SynapseImport> entry : this.synapseImportMap.entrySet()) {
                    if (!localName.startsWith(entry.getValue().getLibName())) continue;
                    return this.getDynamicInvokeMediator(element, entry.getValue().getLibPackage());
                }
            }
            String msg = "Unknown mediator referenced by configuration element : " + qName;
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        try {
            MediatorFactory mf = (MediatorFactory)cls.newInstance();
            return mf.createMediator(element, properties);
        }
        catch (InstantiationException e) {
            String string = "Error initializing mediator factory : " + cls;
            log.error((Object)string);
            throw new SynapseException(string, e);
        }
        catch (IllegalAccessException e) {
            String string = "Error initializing mediator factory : " + cls;
            log.error((Object)string);
            throw new SynapseException(string, e);
        }
    }

    public Map<QName, Class> getFactoryMap() {
        return factoryMap;
    }

    @Override
    public Object getObjectFromOMNode(OMNode om, Properties properties) {
        if (om instanceof OMElement) {
            SynapseConfiguration configuration = properties.get("SynapseConfiguration") != null ? (SynapseConfiguration)properties.get("SynapseConfiguration") : null;
            return this.getMediator((OMElement)om, properties, configuration);
        }
        this.handleException("Invalid mediator configuration XML : " + om);
        return null;
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    public Map<String, Library> getSynapseLibraryMap() {
        return this.synapseLibraryMap;
    }

    public void setSynapseLibraryMap(Map<String, Library> synapseLibraryMap) {
        this.synapseLibraryMap = synapseLibraryMap;
    }

    public Map<String, SynapseImport> getSynapseImportMap() {
        return this.synapseImportMap;
    }

    public void setSynapseImportMap(Map<String, SynapseImport> synapseImportMap) {
        this.synapseImportMap = synapseImportMap;
    }

    public static void main(String[] args) throws Exception {
        String connectorStr = "<sfdc.getContact xmlns=\"http://ws.apache.org/ns/synapse\">\n\t\t <parameter name=\"param1\" value=\"val1\"/>\n\t\t <parameter name=\"param2\" value=\"val2\"/>\n\t</sfdc.getContact>";
        OMElement inConnectorElem = AXIOMUtil.stringToOM((String)connectorStr);
        String libName = "synapse.lang.eip";
        InvokeMediator invokeMediator = MediatorFactoryFinder.getInstance().getDynamicInvokeMediator(inConnectorElem, libName);
        invokeMediator.getTargetTemplate();
    }

    public OMElement getCallTemplateFromConnector(OMElement connectorElem, String libraryName) {
        String callTemplateConfig = "<call-template target=\"synapse.lang.eip.sfdc.getContact\">\n            <with-param name=\"p1\" value=\"abc\"/>\n            <with-param name=\"p2\" value=\"efg\"/>\n        </call-template>";
        OMElement callTemplateElem = null;
        try {
            callTemplateElem = AXIOMUtil.stringToOM((String)callTemplateConfig);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        return callTemplateElem;
    }

    public InvokeMediator getDynamicInvokeMediator(OMElement connectorElem, String libraryName) {
        OMAttribute config_key;
        InvokeMediator invokeMediator = new InvokeMediator();
        if (connectorElem.getLocalName() != null && libraryName != null && !libraryName.equals("")) {
            invokeMediator.setTargetTemplate(libraryName + "." + connectorElem.getLocalName());
        }
        if ((config_key = connectorElem.getAttribute(new QName("configKey"))) != null) {
            ValueFactory keyFac = new ValueFactory();
            Value generatedKey = keyFac.createValue("configKey", connectorElem);
            invokeMediator.setKey(generatedKey);
        }
        this.buildParamteres(connectorElem, invokeMediator);
        invokeMediator.setPackageName(libraryName);
        invokeMediator.setDynamicMediator(true);
        return invokeMediator;
    }

    private void buildParamteres(OMElement connectorElem, InvokeMediator invokeMediator) {
        Iterator parameters = connectorElem.getChildElements();
        while (parameters.hasNext()) {
            OMNode paramNode = (OMNode)parameters.next();
            if (!(paramNode instanceof OMElement)) continue;
            String paramName = ((OMElement)paramNode).getLocalName();
            String paramValueStr = ((OMElement)paramNode).getText();
            if (paramName == null || paramName.equals("") || paramValueStr == null || paramValueStr.equals("")) continue;
            Value paramValue = new ValueFactory().createTextValue((OMElement)paramNode);
            invokeMediator.addExpressionForParamName(paramName, paramValue);
        }
    }
}

