/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.ValueSerializer;
import org.apache.synapse.mediators.builtin.JSONTransformMediator;

public class JSONTransformMediatorSerializer
extends AbstractMediatorSerializer {
    @Override
    protected OMElement serializeSpecificMediator(Mediator mediator) {
        boolean isPropertiesEmpty;
        boolean isSchemaEmpty;
        if (!(mediator instanceof JSONTransformMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + mediator.getType());
        }
        JSONTransformMediator jsonTransformMediator = (JSONTransformMediator)mediator;
        OMElement transformElement = fac.createOMElement("jsontransform", synNS);
        boolean bl = isSchemaEmpty = jsonTransformMediator.getSchemaKey() == null;
        if (!isSchemaEmpty) {
            ValueSerializer keySerializer = new ValueSerializer();
            keySerializer.serializeValue(jsonTransformMediator.getSchemaKey(), "schema", transformElement);
        }
        boolean bl2 = isPropertiesEmpty = jsonTransformMediator.getProperties() == null || jsonTransformMediator.getProperties().isEmpty();
        if (!isPropertiesEmpty) {
            super.serializeProperties(transformElement, jsonTransformMediator.getProperties());
        }
        if (isSchemaEmpty && isPropertiesEmpty) {
            this.handleException("Invalid JSONTransform mediator. Should either contain schema or properties");
        }
        JSONTransformMediatorSerializer.saveTracingState(transformElement, mediator);
        this.serializeComments(transformElement, jsonTransformMediator.getCommentsList());
        return transformElement;
    }

    @Override
    public String getMediatorClassName() {
        return JSONTransformMediator.class.getName();
    }
}

