/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.SynapsePathSerializer;
import org.apache.synapse.config.xml.TargetSerializer;
import org.apache.synapse.mediators.eip.splitter.IterateMediator;

public class IterateMediatorSerializer
extends AbstractMediatorSerializer {
    @Override
    public OMElement serializeSpecificMediator(Mediator m) {
        if (!(m instanceof IterateMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        }
        OMElement itrElem = fac.createOMElement("iterate", synNS);
        IterateMediatorSerializer.saveTracingState(itrElem, m);
        IterateMediator itrMed = (IterateMediator)m;
        if (itrMed.isContinueParent()) {
            itrElem.addAttribute("continueParent", Boolean.toString(true), nullNS);
        }
        if (itrMed.getId() != null) {
            itrElem.addAttribute("id", itrMed.getId(), nullNS);
        }
        if (itrMed.isPreservePayload()) {
            itrElem.addAttribute("preservePayload", Boolean.toString(true), nullNS);
        }
        if (itrMed.isAttachPathPresent()) {
            SynapsePathSerializer.serializePath(itrMed.getAttachPath(), itrElem, "attachPath");
        }
        if (itrMed.getExpression() != null) {
            SynapsePathSerializer.serializePath(itrMed.getExpression(), itrElem, "expression");
        } else {
            this.handleException("Missing expression of the IterateMediator which is required.");
        }
        if (itrMed.getTarget() != null && !itrMed.getTarget().isAsynchronous()) {
            itrElem.addAttribute("sequential", "true", nullNS);
        }
        itrElem.addChild((OMNode)TargetSerializer.serializeTarget(itrMed.getTarget()));
        this.serializeComments(itrElem, itrMed.getCommentsList());
        return itrElem;
    }

    @Override
    public String getMediatorClassName() {
        return IterateMediator.class.getName();
    }
}

