/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.OMElementUtils;
import org.apache.synapse.config.xml.SynapsePathFactory;
import org.apache.synapse.mediators.transform.HeaderMediator;
import org.jaxen.JaxenException;

public class HeaderMediatorFactory
extends AbstractMediatorFactory {
    private static final QName HEADER_Q = new QName("http://ws.apache.org/ns/synapse", "header");
    private static final QName ATT_ACTION = new QName("action");
    private static final QName ATT_SCOPE = new QName("scope");

    @Override
    public Mediator createSpecificMediator(OMElement elem, Properties properties) {
        HeaderMediator headerMediator = new HeaderMediator();
        OMAttribute name = elem.getAttribute(ATT_NAME);
        OMAttribute value = elem.getAttribute(ATT_VALUE);
        OMAttribute exprn = elem.getAttribute(ATT_EXPRN);
        OMAttribute action = elem.getAttribute(ATT_ACTION);
        OMAttribute scope = elem.getAttribute(ATT_SCOPE);
        if (name == null || name.getAttributeValue() == null) {
            if (elem.getChildElements() == null || !elem.getChildElements().hasNext()) {
                String msg = "A valid name attribute is required for the header mediator";
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
        } else if (scope == null || scope.getAttributeValue().equals("default")) {
            String nameAtt = name.getAttributeValue();
            int colonPos = nameAtt.indexOf(":");
            if (colonPos != -1) {
                String prefix = nameAtt.substring(0, colonPos);
                String namespaceURI = OMElementUtils.getNameSpaceWithPrefix(prefix, elem);
                if (namespaceURI == null) {
                    this.handleException("Invalid namespace prefix '" + prefix + "' in name attribute");
                } else {
                    headerMediator.setQName(new QName(namespaceURI, nameAtt.substring(colonPos + 1), prefix));
                }
            } else if ("To".equals(nameAtt) || "From".equals(nameAtt) || "Action".equals(nameAtt) || "FaultTo".equals(nameAtt) || "ReplyTo".equals(nameAtt) || "RelatesTo".equals(nameAtt)) {
                headerMediator.setQName(new QName(nameAtt));
            } else {
                this.handleException("Invalid SOAP header: " + nameAtt + " specified at the header mediator. All SOAP headers must be namespace qualified.");
            }
        } else {
            headerMediator.setQName(new QName(name.getAttributeValue()));
        }
        if (scope != null) {
            String valueStr = scope.getAttributeValue();
            if (!"transport".equals(valueStr) && !"default".equals(valueStr)) {
                String msg = "Only 'transport' or 'default' values are allowed for attribute scope for a header mediator, Unsupported scope " + valueStr;
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            headerMediator.setScope(valueStr);
        }
        this.processAuditStatus(headerMediator, elem);
        if (action != null && "remove".equals(action.getAttributeValue())) {
            headerMediator.setAction(1);
        }
        if (headerMediator.getAction() == 0 && value == null && exprn == null && !headerMediator.isImplicit()) {
            this.handleException("A 'value' or 'expression' attribute is required for a [set] header mediator");
        }
        if (value != null && value.getAttributeValue() != null) {
            headerMediator.setValue(value.getAttributeValue());
        } else if (exprn != null && exprn.getAttributeValue() != null) {
            try {
                headerMediator.setExpression(SynapsePathFactory.getSynapsePath(elem, ATT_EXPRN));
            }
            catch (JaxenException je) {
                this.handleException("Invalid XPath/JSONPath expression : " + exprn.getAttributeValue());
            }
        } else if (headerMediator.isImplicit()) {
            Iterator i = elem.getChildElements();
            if (i == null) {
                this.handleException("A non standard header with both value and expression are null must contain an embedded XML definition.");
            }
            while (i.hasNext()) {
                headerMediator.addEmbeddedXml((OMElement)i.next());
            }
        }
        HeaderMediatorFactory.addAllCommentChildrenToList(elem, headerMediator.getCommentsList());
        return headerMediator;
    }

    @Override
    public QName getTagQName() {
        return HEADER_Q;
    }
}

